/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm;

import java.math.BigDecimal;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlJavaTypeAdapter(value=VersionXmlAdapter.class)
public class Version
extends BigDecimal {
    private Version() {
        super("0.00");
    }

    public Version(String version) {
        this(new BigDecimal(version));
    }

    public Version(BigDecimal version) {
        super(version.movePointRight(2).toBigInteger(), 2);
    }

    public int getMajorVersion() {
        return this.intValue();
    }

    public String format(int majorDigits, char div) {
        int pads;
        int digits = Integer.toString(this.intValue()).length();
        String h2 = this.toString();
        if (div != '.') {
            h2 = h2.replace('.', div);
        }
        if ((pads = majorDigits - digits) <= 0) {
            return h2;
        }
        StringBuilder p2 = new StringBuilder(h2.length() + pads);
        for (int i2 = 0; i2 < pads; ++i2) {
            p2.append('0');
        }
        p2.append(h2);
        return p2.toString();
    }

    protected static class VersionXmlAdapter
    extends XmlAdapter<String, Version> {
        protected VersionXmlAdapter() {
        }

        public String marshal(Version bigDecimal) throws Exception {
            if (bigDecimal != null) {
                return bigDecimal.toString();
            }
            return null;
        }

        public Version unmarshal(String s2) throws Exception {
            try {
                return new Version(s2);
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }
}

