/*
 * Decompiled with CFR 0.152.
 */
package tangram.filter;

import java.math.BigDecimal;
import java.util.Date;
import tangram.filter.TngFilterUtilities;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public final class TngFilter {
    private static final char XSTRING_STRING = '*';
    private static final char XSTRING_CHAR = '?';
    private static final char XSTRING_OR = ';';
    private static final char YSTRING_STRING = '\u0001';
    private static final char YSTRING_CHAR = '\u0002';
    private static final char YSTRING_OR = '\u0003';

    public static String filterStringInterval(String field, String valueA, String valueB) {
        return TngFilter.filterInterval(field, TngFilterUtilities.stringToSql(valueA), TngFilterUtilities.stringToSql(valueB));
    }

    public static String filterXstring(String field, String xstring, boolean sensitive) {
        if (sensitive) {
            return TngFilter.filterXstringSensitive(field, xstring);
        }
        return TngFilter.filterXstringInsensitive(field, xstring);
    }

    public static String filterDescriptionString(String label, String value, boolean sensitive) {
        if (sensitive) {
            return TngFilter.filterDescriptionSensitive(label, value);
        }
        return TngFilter.filterDescriptionInsensitive(label, value);
    }

    public static String filterDescriptionInsensitive(String label, String value) {
        if (value != null && value.length() == 0) {
            value = null;
        }
        return TngFilter.filterDescription(label, value);
    }

    public static String filterDescriptionSensitive(String label, String value) {
        if (value != null && value.length() == 0) {
            value = null;
        }
        return TngFilter.filterDescription(label, value);
    }

    public static String filterXstringInsensitive(String field, String xstring) {
        String ystring = TngFilter.translateXstringToY(xstring);
        String[] values = TngFilter.tokenizeYstring(ystring);
        if (values.length == 0) {
            return field + " IS NULL";
        }
        StringBuilder buff = new StringBuilder(2 * ystring.length());
        for (int i2 = 0; i2 < values.length; ++i2) {
            String v2 = values[i2];
            v2 = TngFilter.filterYstringInsitiveOne(field, v2);
            if (buff.length() == 0 && values.length > 1) {
                buff.append('(');
            }
            if (i2 > 0) {
                buff.append(" OR ");
            }
            buff.append(v2);
        }
        if (buff.charAt(0) == '(') {
            buff.append(')');
        }
        return buff.toString();
    }

    public static String filterXstringSensitive(String field, String xstring) {
        String ystring = TngFilter.translateXstringToY(xstring);
        String[] values = TngFilter.tokenizeYstring(ystring);
        if (values.length == 0) {
            return field + " IS NULL";
        }
        StringBuilder buffAll = new StringBuilder(2 * ystring.length());
        StringBuilder buffEquals = new StringBuilder(2 * ystring.length());
        int equals = 0;
        int wilds = 0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            String v2 = values[i2];
            if (TngFilter.isSingleYstring(v2)) {
                if (++equals > 1) {
                    buffEquals.append(",");
                }
                buffEquals.append(TngFilterUtilities.stringToSql(v2));
                continue;
            }
            ++wilds;
            v2 = TngFilter.filterYstringSensitiveOne(field, v2);
            if (buffAll.length() == 0 && values.length > 1) {
                buffAll.append('(');
            }
            if (wilds > 1) {
                buffAll.append(" OR ");
            }
            buffAll.append(v2);
        }
        if (equals > 0) {
            if (buffAll.length() > 0) {
                buffAll.append(" OR ");
            }
            TngFilter.filterEquals(field, buffEquals, equals, buffAll);
        }
        if (buffAll.charAt(0) == '(') {
            buffAll.append(')');
        }
        return buffAll.toString();
    }

    public static boolean isSingleYstring(String xstring) {
        if (xstring == null || xstring.length() == 0) {
            return true;
        }
        for (int i2 = 0; i2 < xstring.length(); ++i2) {
            char c2 = xstring.charAt(i2);
            if (c2 != '\u0001' && c2 != '\u0002' && c2 != '\u0003') continue;
            return false;
        }
        return true;
    }

    public static String normalizeSingleXstring(String xstring) {
        if (xstring == null || xstring.length() == 0) {
            return xstring;
        }
        StringBuilder buff = new StringBuilder(xstring.length());
        boolean esc = false;
        for (int i2 = 0; i2 < xstring.length(); ++i2) {
            char c2 = xstring.charAt(i2);
            if (esc && c2 != '*' && c2 != '?' && c2 != ';' && c2 != '\\') {
                buff.append('\\');
            }
            boolean bl = c2 == '\\' ? !esc : (esc = false);
            if (esc) continue;
            buff.append(c2);
        }
        return buff.toString();
    }

    public static String normalizeXstring(String xstring) {
        if (xstring == null || xstring.length() == 0) {
            return xstring;
        }
        String ystring = TngFilter.translateXstringToY(xstring);
        String[] values = TngFilter.tokenizeYstring(ystring);
        StringBuilder buff = new StringBuilder(ystring.length());
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (buff.length() > 0) {
                buff.append(';');
            }
            buff.append(TngFilter.transalteYstringToX(values[i2]));
        }
        return buff.toString();
    }

    private static String transalteYstringToX(String ystring) {
        if (ystring == null || ystring.length() == 0) {
            return ystring;
        }
        StringBuilder buff = new StringBuilder(2 * ystring.length());
        for (int i2 = 0; i2 < ystring.length(); ++i2) {
            char c2 = ystring.charAt(i2);
            if (c2 == '\u0001') {
                buff.append('*');
                continue;
            }
            if (c2 == '\u0002') {
                buff.append('?');
                continue;
            }
            if (c2 == '\u0003') {
                buff.append(';');
                continue;
            }
            if (c2 == '*' || c2 == '?' || c2 == ';') {
                buff.append('\\');
                buff.append(c2);
                continue;
            }
            if (c2 == '\\') {
                buff.append("\\\\");
                continue;
            }
            buff.append(c2);
        }
        return buff.toString();
    }

    private static String translateXstringToY(String xstring) {
        if (xstring == null || xstring.length() == 0) {
            return xstring;
        }
        StringBuilder buff = new StringBuilder(xstring.length());
        boolean esc = false;
        for (int i2 = 0; i2 < xstring.length(); ++i2) {
            char c2 = xstring.charAt(i2);
            if (esc) {
                if (c2 != '*' && c2 != '?' && c2 != ';' && c2 != '\\') {
                    buff.append('\\');
                }
            } else if (c2 == '*') {
                c2 = '\u0001';
            } else if (c2 == '?') {
                c2 = '\u0002';
            } else if (c2 == ';') {
                c2 = '\u0003';
            }
            boolean bl = c2 == '\\' ? !esc : (esc = false);
            if (esc) continue;
            buff.append(c2);
        }
        return buff.toString();
    }

    private static String[] tokenizeYstring(String ystring) {
        if (ystring == null || ystring.length() == 0) {
            return new String[0];
        }
        String[] items = TngUtilities.strTokenizeNotNull(ystring, '\u0003');
        String[] pure = new String[items.length];
        int count = 0;
        for (int i2 = 0; i2 < items.length; ++i2) {
            String h2 = TngFilter.normalizeYstringOne(items[i2]);
            if (h2.length() == 0) continue;
            if (h2.length() == 1 && h2.charAt(0) == '\u0001') {
                return new String[]{h2};
            }
            for (int y = 0; y < count; ++y) {
                if (pure[y] == null || !pure[y].equals(h2)) continue;
                h2 = null;
                break;
            }
            if (h2 == null) continue;
            pure[count++] = h2;
        }
        if (count == 0) {
            return new String[0];
        }
        items = new String[count];
        if (pure.length == count) {
            return pure;
        }
        System.arraycopy(pure, 0, items, 0, count);
        return items;
    }

    private static String normalizeYstringOne(String ystring) {
        if (ystring == null || ystring.length() == 0) {
            return ystring;
        }
        StringBuilder buff = new StringBuilder(ystring.length());
        int wildchars = 0;
        for (int i2 = 0; i2 < ystring.length(); ++i2) {
            char c2 = ystring.charAt(i2);
            if (c2 == ' ' && buff.length() == 0) continue;
            if (c2 == '\u0001') {
                if (++wildchars != 1) continue;
                buff.append(c2);
                continue;
            }
            wildchars = 0;
            buff.append(c2);
        }
        int rspaces = 0;
        int i3 = buff.length() - 1;
        while (i3 >= 0 && buff.charAt(i3) == ' ') {
            --i3;
            ++rspaces;
        }
        if (rspaces == 0) {
            return buff.toString();
        }
        return buff.substring(0, buff.length() - rspaces);
    }

    public static String filterDate(String field, Date date) {
        return field + (date == null ? " IS NULL" : "=" + TngFilterUtilities.dateToSql(date));
    }

    public static String filterDateInterval(String field, Date dateA, Date dateB) {
        return TngFilter.filterInterval(field, TngFilterUtilities.dateToSql(dateA), TngFilterUtilities.dateToSql(dateB));
    }

    public static String filterDateDescriptionInterval(String label, Date dateA, Date dateB) {
        return TngFilter.filterDescriptionInterval(label, TngUtilities.dateToStr(dateA), TngUtilities.dateToStr(dateB));
    }

    public static String filterDateDescription(String label, Date date) {
        return TngFilter.filterDescription(label, TngUtilities.dateToStr(date));
    }

    public static String filterNumber(String field, BigDecimal number) {
        return field + (number == null ? " IS NULL" : "=" + TngFilterUtilities.numberToSql(number));
    }

    public static String filterNumberInterval(String field, BigDecimal numberA, BigDecimal numberB) {
        return TngFilter.filterInterval(field, TngFilterUtilities.numberToSql(numberA), TngFilterUtilities.numberToSql(numberB));
    }

    public static String filterNumberDescriptionInterval(String label, BigDecimal numberA, BigDecimal numberB) {
        return TngFilter.filterDescriptionInterval(label, TngUtilities.numberToString(numberA), TngUtilities.numberToString(numberB));
    }

    public static String filterNumberDescription(String label, BigDecimal number) {
        return TngFilter.filterDescription(label, TngUtilities.numberToString(number));
    }

    public static String filterInteger(String field, Integer number) {
        return field + (number == null ? " IS NULL" : "=" + TngFilterUtilities.integerToSql(number));
    }

    public static String filterIntegerInterval(String field, Integer numberA, Integer numberB) {
        return TngFilter.filterInterval(field, TngFilterUtilities.integerToSql(numberA), TngFilterUtilities.integerToSql(numberB));
    }

    public static String filterIntegerDescriptionInterval(String label, Integer numberA, Integer numberB) {
        return TngFilter.filterDescriptionInterval(label, TngFilter.integerToString(numberA), TngFilter.integerToString(numberB));
    }

    public static String filterIntegerDescription(String label, Integer number) {
        return TngFilter.filterDescription(label, TngFilter.integerToString(number));
    }

    public static String filterBoolean(String field, boolean value) {
        return field + (value ? " IS NOT NULL" : " IS NULL");
    }

    public static String filterBooleanDescription(String label, boolean value) {
        return (value ? "je " : "nie je ") + label;
    }

    public static String filterList(String field, String zvalues) {
        String[] values = TngFilterUtilities.tokenizeList(zvalues, true);
        if (values.length == 0) {
            return field + " IS NULL";
        }
        StringBuilder buff = new StringBuilder(2 * zvalues.length());
        for (int i2 = 0; i2 < values.length; ++i2) {
            String v2 = values[i2];
            if (i2 > 0) {
                buff.append(",");
            }
            buff.append(TngFilterUtilities.stringToSql(v2));
        }
        StringBuilder out = new StringBuilder(buff.length() + 50);
        TngFilter.filterEquals(field, buff, values.length, out);
        return out.toString();
    }

    public static String filterListDescription(String label, String zvalues, String[] list) {
        String[] values = TngFilterUtilities.tokenizeList(zvalues, true);
        if (values.length == 0) {
            return label + ":" + Nat.x("pr\u00e1zdne");
        }
        StringBuilder buff = new StringBuilder(10 * zvalues.length());
        buff.append(label);
        buff.append(" " + Nat.x("je") + " ");
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (i2 > 0) {
                buff.append(';');
            }
            buff.append(TngFilterUtilities.getListItem(values[i2], list));
        }
        return buff.toString();
    }

    private static void filterEquals(String field, StringBuilder values, int count, StringBuilder out) {
        out.append(field);
        if (count == 1) {
            out.append("=");
            out.append((CharSequence)values);
        } else {
            out.append(" IN(");
            out.append((CharSequence)values);
            out.append(")");
        }
    }

    private static String filterInterval(String field, String value1, String value2) {
        value1 = value1 != null && value1.length() == 0 ? null : value1;
        String string = value2 = value2 != null && value2.length() == 0 ? null : value2;
        if (value1 == null && value2 == null) {
            return "";
        }
        if (value1 == null) {
            return field + "<=" + value2;
        }
        if (value2 == null) {
            return field + ">=" + value1;
        }
        if (value1.equals(value2)) {
            return field + "=" + value1;
        }
        return field + " BETWEEN " + value1 + " AND " + value2;
    }

    public static String filterDescription(String label, String value) {
        return label + " " + Nat.x("je") + " " + (value == null ? Nat.x("pr\u00e1zdne") : value);
    }

    public static String filterDescriptionInterval(String label, String value1, String value2) {
        value1 = value1 != null && value1.length() == 0 ? null : value1;
        String string = value2 = value2 != null && value2.length() == 0 ? null : value2;
        if (value1 == null && value2 == null) {
            return "";
        }
        if (value1 == null) {
            return label + " " + Nat.x("do") + " " + value2;
        }
        if (value2 == null) {
            return label + " " + Nat.x("od") + " " + value1;
        }
        if (value1.equals(value2)) {
            return label + ":" + value1;
        }
        return label + " " + Nat.x("od") + " " + value1 + " " + Nat.x("do") + " " + value2;
    }

    private static String filterYstringInsitiveOne(String field, String ystring) {
        if (ystring == null || ystring.length() == 0) {
            return ystring;
        }
        if (ystring.length() == 1 && ystring.charAt(0) == '\u0001') {
            return field + " IS NOT NULL";
        }
        StringBuilder regexp = new StringBuilder(ystring.length() + 30);
        regexp.append("regexp_like(");
        regexp.append(field);
        regexp.append(",'");
        int i2 = 0;
        int l2 = ystring.length();
        if (ystring.charAt(0) == '\u0001') {
            ++i2;
        } else {
            regexp.append('^');
        }
        boolean endExact = false;
        if (ystring.charAt(l2 - 1) == '\u0001') {
            --l2;
        } else {
            endExact = true;
        }
        while (i2 < l2) {
            char c2 = ystring.charAt(i2);
            if (c2 == '\u0001') {
                regexp.append(".*");
            } else if (c2 == '\u0002') {
                regexp.append(".");
            } else if (c2 == '\'') {
                regexp.append("''");
            } else if ("\\?.*+|^&$()[]{}".indexOf(c2) >= 0) {
                regexp.append('\\');
                regexp.append(c2);
            } else {
                regexp.append(c2);
            }
            ++i2;
        }
        if (endExact) {
            regexp.append('$');
        }
        regexp.append("')");
        return regexp.toString();
    }

    private static String filterYstringSensitiveOne(String field, String ystring) {
        if (ystring == null || ystring.length() == 0) {
            return ystring;
        }
        if (ystring.length() == 1 && ystring.charAt(0) == '\u0001') {
            return field + " IS NOT NULL";
        }
        StringBuilder like = new StringBuilder(ystring.length() + 30);
        like.append(field);
        like.append(" LIKE '");
        for (int i2 = 0; i2 < ystring.length(); ++i2) {
            char c2 = ystring.charAt(i2);
            if (c2 == '\u0001') {
                like.append("%");
                continue;
            }
            if (c2 == '\u0002') {
                like.append("_");
                continue;
            }
            if (c2 == '\'') {
                like.append("''");
                continue;
            }
            if ("\\%_".indexOf(c2) >= 0) {
                like.append('\\');
                like.append(c2);
                continue;
            }
            like.append(c2);
        }
        like.append("'");
        return like.toString();
    }

    public static String integerToString(Integer number) {
        if (number == null) {
            return null;
        }
        return number.toString();
    }
}

