/*
 * Decompiled with CFR 0.152.
 */
package tangram.filter.item;

import tangram.filter.TngFilter;
import tangram.filter.item.TngFilterItem;
import tangram.filter.visualizer.TngFilterVisualizer;
import tangram.filter.visualizer.TngFilterVisualizerBoolean;

public class TngFilterItemBoolean
extends TngFilterItem<Boolean> {
    public TngFilterItemBoolean(String name, String label) {
        super(name, label, false, false);
    }

    @Override
    public String valueToString(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "T" : "F";
    }

    @Override
    public Boolean valueFromString(String value) throws Exception {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value.charAt(0) == 'T';
    }

    @Override
    public String createFilterExpression() {
        if (this.value == null) {
            return null;
        }
        return TngFilter.filterBoolean(this.name, (Boolean)this.value);
    }

    @Override
    public String createFilterDescription() {
        if (this.value == null) {
            return null;
        }
        return TngFilter.filterBooleanDescription(this.label, (Boolean)this.value);
    }

    @Override
    public TngFilterVisualizer createFilterVisualizer() {
        return new TngFilterVisualizerBoolean();
    }
}

