/*
 * Decompiled with CFR 0.152.
 */
package tangram.filter.item;

import java.math.BigDecimal;
import tangram.filter.TngFilter;
import tangram.filter.item.TngFilterItem;
import tangram.filter.visualizer.TngFilterVisualizer;
import tangram.filter.visualizer.TngFilterVisualizerNumber;

public class TngFilterItemNumber
extends TngFilterItem<BigDecimal> {
    public TngFilterItemNumber(String name, String label) {
        super(name, label, true, true);
    }

    @Override
    public String valueToString(BigDecimal value) {
        return value == null ? null : value.toString();
    }

    @Override
    public BigDecimal valueFromString(String value) throws Exception {
        if (value == null || value.length() == 0) {
            return null;
        }
        return new BigDecimal(value);
    }

    @Override
    public String createFilterExpression() {
        if (this.interval) {
            return TngFilter.filterNumberInterval(this.name, (BigDecimal)this.valueA, (BigDecimal)this.valueB);
        }
        return TngFilter.filterNumber(this.name, (BigDecimal)this.value);
    }

    @Override
    public String createFilterDescription() {
        if (this.interval) {
            return TngFilter.filterNumberDescriptionInterval(this.label, (BigDecimal)this.valueA, (BigDecimal)this.valueB);
        }
        return TngFilter.filterNumberDescription(this.label, (BigDecimal)this.value);
    }

    @Override
    public TngFilterVisualizer createFilterVisualizer() {
        return new TngFilterVisualizerNumber();
    }
}

