/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.io.File;
import tangram.forms.TngFormDataAccessor;
import tangram.forms.TngFormFiller;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngFileChooser;
import tangram.swing.panel.TngProgressableWorker;

public abstract class TngFormExporter {
    protected final File[] targetFiles = new File[this.getTargetFilesCount()];
    protected TngFormFiller<? extends TngFormDataAccessor> formFiller;
    protected TngProgressableWorker worker;

    protected abstract String getFileExtension();

    protected abstract void exportInner() throws Exception;

    protected int getTargetFilesCount() {
        return 1;
    }

    public void export(TngFormFiller<? extends TngFormDataAccessor> formFiller) throws Exception {
        this.formFiller = formFiller;
        if (!this.createTargetFiles()) {
            return;
        }
        this.exportInWorker();
    }

    private boolean createTargetFiles() {
        TngFileChooser fileChooser = new TngFileChooser();
        fileChooser.setDialogTitle(Nat.x("Umiestnenie s\u00faboru"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setSelectedFile(new File(this.formFiller.getDataAccessor().getDescription()));
        fileChooser.addFileFilterExtension(Nat.x("S\u00fabory %1", this.getFileExtension()), this.getFileExtension());
        if (fileChooser.showDialog(TngSwing.mainWindow, Nat.x("Ulo\u017ei\u0165")) != 0) {
            return false;
        }
        String toSearch = "." + this.getFileExtension();
        String targetFileName = fileChooser.getSelectedFile().getAbsolutePath();
        if (targetFileName.endsWith(toSearch)) {
            targetFileName = TngUtilities.strCutEnd(targetFileName, toSearch.length());
        }
        for (int i2 = 0; i2 < Math.max(1, this.getTargetFilesCount()); ++i2) {
            this.targetFiles[i2] = new File(targetFileName + (i2 == 0 ? "" : "_" + i2) + "." + this.getFileExtension());
        }
        return true;
    }

    private void exportInWorker() throws Exception {
        this.worker = new TngProgressableWorker(Nat.x("Export do %1", this.getFileExtension())){

            @Override
            public void compute() throws Exception {
                TngFormExporter.this.exportInner();
            }
        };
        this.worker.setProgressCancelable(true);
        this.worker.start();
    }
}

