/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import tangram.forms.TngFormExporter;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public abstract class TngFormExporterXml
extends TngFormExporter {
    protected abstract String getContextPath();

    protected abstract Object createJaxbElement() throws Exception;

    protected String getFormUrl() {
        return null;
    }

    protected boolean appendFileToUrl() {
        return false;
    }

    @Override
    protected String getFileExtension() {
        return "xml";
    }

    @Override
    protected void exportInner() throws Exception {
        File targetFile = this.targetFiles[0];
        this.worker.setProgressStatus(Nat.x("Vytv\u00e1ranie s\u00faboru %1", targetFile.getAbsolutePath()));
        this.marshall(this.createJaxbElement(), targetFile);
        this.open(targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshall(Object jaxbElement, File file) throws Exception {
        this.worker.setProgressStatus(Nat.x("Z\u00e1pis \u00fadajov do s\u00faboru %1", file.getAbsolutePath()));
        FileOutputStream fos = null;
        try {
            JAXBContext context = JAXBContext.newInstance((String)this.getContextPath());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            file.getParentFile().mkdirs();
            fos = new FileOutputStream(file);
            marshaller.marshal(jaxbElement, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(fos);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(fos);
    }

    private void open(File file) {
        if (TngUtilities.isEmpty(this.getFormUrl())) {
            TngSwing.msgOK(Nat.x("Export do XML prebehol \u00faspe\u0161ne"));
        } else {
            try {
                Runtime r2 = Runtime.getRuntime();
                String[] commands = new String[]{"c:\\Program Files\\Internet Explorer\\iexplore.exe", this.getFormUrl() + (this.appendFileToUrl() ? file.getAbsolutePath() : "")};
                Process p2 = r2.exec(commands);
            }
            catch (Throwable e2) {
                TngSwing.exceptionShow(e2);
            }
        }
    }

    protected String getString(String key) {
        String valStr = this.formFiller.getDataAccessor().getValue(key);
        return TngUtilities.isEmpty(valStr) ? "" : valStr;
    }

    protected Integer getInteger(String key) {
        Integer valInt = TngUtilities.strToInt(this.getString(key), Integer.MIN_VALUE);
        return valInt == Integer.MIN_VALUE ? null : valInt;
    }

    protected BigDecimal getDecimal(String key) {
        return TngUtilities.stringToNumber(this.getString(key));
    }

    protected BigDecimal getDecimal01(String key) {
        return TngUtilities.isEmpty(this.getString(key)) ? BigDecimal.ZERO : BigDecimal.ONE;
    }

    protected String getDateAsStr(String keyDay, String keyMonth, String keyYear) {
        Integer valDay = this.getInteger(keyDay);
        Integer valMonth = this.getInteger(keyMonth);
        Integer valYear = this.getInteger(keyYear);
        if (valDay == null || valMonth == null || valYear == null) {
            return "";
        }
        return TngUtilities.dateToStr(TngUtilities.dateCreate(2000 + valYear, valMonth, valDay));
    }

    protected <T> T reflectionCreateByClass(Class<T> objectClass) throws Exception {
        Field[] fields;
        T object = objectClass.newInstance();
        for (Field field : fields = objectClass.getDeclaredFields()) {
            field.setAccessible(true);
            XmlAttribute fieldXmlAttribute = field.getAnnotation(XmlAttribute.class);
            String fieldName = fieldXmlAttribute == null || fieldXmlAttribute.name().equals("##default") ? field.getName() : fieldXmlAttribute.name();
            Class<?> fieldType = field.getType();
            if (this.reflectionFieldTypeSkip(fieldType)) continue;
            Object fieldValue = this.reflectionFieldValueGet(fieldType, fieldName);
            field.set(object, fieldValue);
        }
        return object;
    }

    protected boolean reflectionFieldTypeSkip(Class<?> fieldType) {
        return fieldType == List.class || fieldType == Map.class;
    }

    protected Object reflectionFieldValueGet(Class<?> fieldType, String fieldName) throws Exception {
        if (fieldType == BigDecimal.class) {
            return this.getDecimal(fieldName);
        }
        if (fieldType == String.class) {
            return this.getString(fieldName);
        }
        Object customValue = this.reflectionGetFieldValueCustom(fieldType, fieldName);
        if (customValue != null) {
            return customValue;
        }
        return this.reflectionCreateByClass(fieldType);
    }

    protected Object reflectionGetFieldValueCustom(Class<?> fieldType, String fieldName) throws Exception {
        return null;
    }
}

