/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.math.RoundingMode;
import tangram.dm.buffer.TngDmBufferCached;
import tangram.forms.TngFormDataAccessor;
import tangram.forms.struct.TngFormDefaultValue;
import tangram.library.TngJournalFile;
import tangram.swing.panel.TngProgressableWorker;

public abstract class TngFormFiller<E extends TngFormDataAccessor> {
    private E dataAccessor;
    protected TngProgressableWorker worker;
    protected TngJournalFile journalFile;
    protected int roundingScale = 0;
    protected RoundingMode roundingMode = null;

    public void setDataAccessor(E dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    public E getDataAccessor() {
        return this.dataAccessor;
    }

    public void setWorker(TngProgressableWorker worker) {
        this.worker = worker;
    }

    public void setJournalFile(TngJournalFile journalFile) {
        this.journalFile = journalFile;
    }

    public void setRounding(int roundingScale, RoundingMode roundingMode) {
        this.roundingScale = roundingScale;
        this.roundingMode = roundingMode;
    }

    protected void addJournalInfo(String group, String msg) {
        if (this.journalFile != null) {
            this.journalFile.info(msg, null, group);
        }
    }

    protected void addJournalError(String group, String error) {
        if (this.journalFile != null) {
            this.journalFile.error(error, null, group);
        }
    }

    public void setDefaultValue(TngFormDefaultValue defaultValue) throws Exception {
        this.setValueA(defaultValue.getName(), this.getDefaultValue(defaultValue.getExpression()));
    }

    protected String getDefaultValue(String expression) {
        return expression;
    }

    protected void setValueA(String key, String value) {
        this.setValue(key, value, TngDmBufferCached.FCalc.A);
    }

    protected void setValueB(String key, String value) {
        this.setValue(key, value, TngDmBufferCached.FCalc.B);
    }

    protected void setValueC(String key, String value) {
        this.setValue(key, value, TngDmBufferCached.FCalc.C);
    }

    protected void setValue(String key, String value, TngDmBufferCached.FCalc fcalc) {
        this.getDataAccessor().setValue(key, value, fcalc);
    }

    public abstract void fill() throws Exception;

    public void load() throws Exception {
    }

    public void save() throws Exception {
    }

    public void transformDataBeforeFormSave() throws Exception {
    }
}

