/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import tangram.dm.buffer.TngDmBuffer;
import tangram.exception.TngExceptionSql;
import tangram.forms.TngFormDataAccessorSql;
import tangram.forms.TngFormFiller;
import tangram.forms.TngFormSqlScript;
import tangram.library.TngUtilities;

public abstract class TngFormFillerSql<E extends TngFormDataAccessorSql<? extends TngDmBuffer>>
extends TngFormFiller<E> {
    protected TngFormSqlScript sqlScript;

    public void setFormSqlScript(TngFormSqlScript sqlScript) {
        this.sqlScript = sqlScript;
    }

    @Override
    public void save() throws Exception {
        super.save();
        ((TngFormDataAccessorSql)this.getDataAccessor()).saveData(this.worker);
    }

    @Override
    protected String getDefaultValue(String expression) {
        String value = this.getDefaultValueForSimpleSelect(expression);
        if (value == null) {
            value = this.getDefaultValueForSelect(expression);
        }
        if (value == null) {
            value = super.getDefaultValue(expression);
        }
        return value;
    }

    protected String getDefaultValueForSimpleSelect(String simpleSelect) {
        String[] tokens = TngUtilities.strTokenizeNotNull(simpleSelect, ':');
        if (tokens.length < 3) {
            return null;
        }
        String select = "select " + tokens[0] + " from " + tokens[1] + " where " + tokens[2];
        return this.getDefaultValueForSelect(select);
    }

    protected String getDefaultValueForSelect(String select) {
        try {
            Object value = ((TngFormDataAccessorSql)this.getDataAccessor()).getConnection().queryObject(select);
            return value == null ? "" : value.toString();
        }
        catch (TngExceptionSql e2) {
            return null;
        }
    }
}

