/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import tangram.forms.TngFormPdfConverter;
import tangram.forms.TngFormSqlScript;
import tangram.forms.TngFormZipFile;
import tangram.forms.struct.TngForm;
import tangram.library.TngUtilities;

public class TngForms {
    public static final String EXT_PDF = "pdf";
    public static final String EXT_FDF = "fdf";
    public static final String EXT_XML = "xml";
    public static final String EXT_JPG = "jpg";
    public static final String EXT_SQL = "sql";
    public static final String EXT_ORIGINAL = "_Original";
    public static final String EXT_STRUCT = "_Struct";
    public static final String EXT_PAGE = "_Page";
    public static final String EXT_SCRIPT_SQL = "_ScriptSql";

    public static TngForm convertPdf(File pdfFile, String name, String description) throws Exception {
        TngForm form = TngFormPdfConverter.convert(pdfFile, name, description);
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TngForm loadStruct(String formName) throws Exception {
        TngFormZipFile formZipFile = TngForms.openFormZipFile();
        String entryName = TngForms.getZipEntryName(formName, EXT_STRUCT, EXT_XML);
        InputStream zippedInputStream = null;
        try {
            TngForm form;
            zippedInputStream = formZipFile.getZippedInputStream(entryName);
            TngForm tngForm = form = TngForm.unmarshal(zippedInputStream);
            return tngForm;
        }
        finally {
            TngUtilities.streamCloseSafe(zippedInputStream);
            TngForms.closeFormZipFile(formZipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadStructs(List<TngForm> forms) throws Exception {
        TngFormZipFile formZipFile = TngForms.openFormZipFile();
        try {
            TngForms.addStructsFromZip(formZipFile.getZipFile(), forms);
        }
        finally {
            TngForms.closeFormZipFile(formZipFile);
        }
    }

    private static void addStructsFromZip(ZipFile zip, List<TngForm> forms) throws Exception {
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String lowerName = zipEntry.getName().toLowerCase();
            if (!lowerName.endsWith("_Struct.xml".toLowerCase())) continue;
            forms.add(TngForm.unmarshal(zip.getInputStream(zipEntry)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadPage(String formName, int pageIndex) throws Exception {
        TngFormZipFile formZipFile = TngForms.openFormZipFile();
        String entryName = TngForms.getZipEntryName(formName, EXT_PAGE + pageIndex, EXT_JPG);
        InputStream zippedInputStream = null;
        try {
            BufferedImage image;
            zippedInputStream = formZipFile.getZippedInputStream(entryName);
            BufferedImage bufferedImage = image = ImageIO.read(zippedInputStream);
            return bufferedImage;
        }
        finally {
            TngUtilities.streamCloseSafe(zippedInputStream);
            TngForms.closeFormZipFile(formZipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TngFormSqlScript loadSqlScript(String formName) throws Exception {
        block5: {
            TngFormSqlScript tngFormSqlScript;
            TngFormZipFile formZipFile = TngForms.openFormZipFile();
            InputStream zippedInputStream = null;
            try {
                TngFormSqlScript formSqlScript;
                String entryName = TngForms.getZipEntryName(formName, EXT_SCRIPT_SQL, EXT_SQL);
                zippedInputStream = formZipFile.getZippedInputStream(entryName);
                tngFormSqlScript = formSqlScript = TngFormSqlScript.fromInputStream(zippedInputStream);
                TngUtilities.streamCloseSafe(zippedInputStream);
            }
            catch (Exception e2) {
                TngUtilities.exceptionLog(e2);
                break block5;
            }
            finally {
                TngUtilities.streamCloseSafe(zippedInputStream);
                TngForms.closeFormZipFile(formZipFile);
            }
            TngForms.closeFormZipFile(formZipFile);
            return tngFormSqlScript;
        }
        return new TngFormSqlScript();
    }

    public static TngFormZipFile openFormZipFile() throws Exception {
        TngFormZipFile formZipFile = new TngFormZipFile();
        formZipFile.open();
        return formZipFile;
    }

    public static void closeFormZipFile(TngFormZipFile formZipFile) throws Exception {
        if (formZipFile != null) {
            formZipFile.close();
        }
    }

    public static String getZipEntryName(String formName, String formType, String ext) {
        return formName + formType + "." + ext;
    }
}

