/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.script;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tangram.forms.script.TngFormScript;
import tangram.forms.script.TngFormScriptEnabledIf;
import tangram.forms.script.TngFormScriptFilterComboBox;
import tangram.forms.struct.TngForm;
import tangram.forms.visual.TngFormComponent;
import tangram.library.TngUtilities;

public class TngFormScripts {
    private static final Map<String, Class<? extends TngFormScript<? extends TngFormComponent>>> supportedScripts = new HashMap<String, Class<? extends TngFormScript<? extends TngFormComponent>>>();

    private static TngFormScript<? extends TngFormComponent> getScript(String script) {
        for (Map.Entry<String, Class<? extends TngFormScript<? extends TngFormComponent>>> entry : supportedScripts.entrySet()) {
            String key = entry.getKey();
            Class<? extends TngFormScript<? extends TngFormComponent>> value = entry.getValue();
            Pattern pattern = Pattern.compile(key + "\\((.*?)\\)");
            Matcher matcher = pattern.matcher(script);
            while (matcher.find()) {
                if (matcher.groupCount() <= 0) continue;
                try {
                    TngFormScript<? extends TngFormComponent> formScript = value.newInstance();
                    formScript.setParam(matcher.group(1));
                    return formScript;
                }
                catch (Throwable e2) {
                    TngUtilities.exceptionLog(e2);
                }
            }
        }
        return null;
    }

    public static <E extends TngFormComponent> void execute(TngForm form, E formComponent, List<TngFormComponent> formComponents) {
        String[] scripts;
        for (String script : scripts = TngUtilities.strTokenizeNotNull(formComponent.getFormObject().getScript(), ';')) {
            TngFormScript<? extends TngFormComponent> formScript = TngFormScripts.getScript(script);
            if (formScript == null) continue;
            formScript.setData(form, formComponent, formComponents);
            formScript.execute();
        }
    }

    static {
        supportedScripts.put("FilterComboBox", TngFormScriptFilterComboBox.class);
        supportedScripts.put("EnabledIf", TngFormScriptEnabledIf.class);
    }
}

