/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import tangram.forms.script.TngFormScripts;
import tangram.forms.struct.TngForm;
import tangram.forms.struct.TngFormObject;
import tangram.forms.struct.TngFormObjectCheckBox;
import tangram.forms.struct.TngFormObjectComboBox;
import tangram.forms.struct.TngFormObjectField;
import tangram.forms.struct.TngFormObjectFieldType;
import tangram.forms.struct.TngFormObjectLink;
import tangram.forms.struct.TngFormObjectRadioButton;
import tangram.forms.visual.components.TngFormCheckBox;
import tangram.forms.visual.components.TngFormComboBox;
import tangram.forms.visual.components.TngFormFieldArea;
import tangram.forms.visual.components.TngFormFieldDate;
import tangram.forms.visual.components.TngFormFieldDecimal;
import tangram.forms.visual.components.TngFormFieldInteger;
import tangram.forms.visual.components.TngFormFieldString;
import tangram.forms.visual.components.TngFormLink;
import tangram.forms.visual.components.TngFormRadioButton;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public abstract class TngFormComponent {
    protected static final Color HIGHLIGHT = new Color(221, 228, 255);
    protected static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private boolean highlight;
    private boolean transparent;
    private TngForm form;
    private TngFormObject formObject;

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.transparencyChanged();
    }

    protected void transparencyChanged() {
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    protected TngFormComponent() {
    }

    public boolean isNamed(String name) {
        return this.getFormObject().getName().equalsIgnoreCase(name);
    }

    protected void initialize() {
        this.getComponent().setToolTipText(TngUtilities.strExt(this.getFormObject().getDescription(), " ", "(" + this.getFormObject().getName() + ")"));
    }

    public void setForm(TngForm form) {
        this.form = form;
    }

    public TngForm getForm() {
        return this.form;
    }

    public void setFormObject(TngFormObject formObject) {
        this.formObject = formObject;
    }

    public TngFormObject getFormObject() {
        return this.formObject;
    }

    public void translate(int workPlaceX, int workPlaceY, double workPlaceFactor) {
        if (this.translateComponent(workPlaceX, workPlaceY, workPlaceFactor)) {
            this.translateFont(workPlaceFactor);
        }
    }

    protected boolean translateComponent(int workPlaceX, int workPlaceY, double workPlaceFactor) {
        if (this.formObject == null) {
            return false;
        }
        Rectangle newBounds = this.getTranslatedRectangle(workPlaceX, workPlaceY, workPlaceFactor);
        if (newBounds.equals(this.getComponent().getBounds())) {
            return false;
        }
        this.getComponent().setBounds(newBounds);
        return true;
    }

    private Rectangle getTranslatedRectangle(int workPlaceX, int workPlaceY, double workPlaceFactor) {
        double x2 = (double)workPlaceX + (double)this.formObject.getX() * workPlaceFactor;
        double y = (double)workPlaceY + (double)this.formObject.getY() * workPlaceFactor;
        double width = (double)this.formObject.getWidth() * workPlaceFactor;
        double height = (double)this.formObject.getHeight() * workPlaceFactor;
        Rectangle newBounds = new Rectangle((int)x2, (int)y, (int)width, (int)height);
        return newBounds;
    }

    protected void translateFont(double workPlaceFactor) {
        this.getComponent().setFont(TngSwing.createFontRelative(this.getComponent().getFont().getStyle(), (float)workPlaceFactor / 1.5f));
    }

    public abstract JComponent getComponent();

    public boolean isVirtual() {
        return false;
    }

    public abstract void setValue(String var1);

    public abstract String getValue();

    public void script(List<TngFormComponent> formComponents) {
        TngFormScripts.execute(this.getForm(), this, formComponents);
    }

    public void scriptLeft(List<TngFormComponent> formComponents) {
    }

    public void scriptRight(List<TngFormComponent> formComponents) {
    }

    public String afterScriptNormalizeValue(String value) {
        return value;
    }

    public static TngFormComponent createFromFormObject(TngForm form, TngFormObject formObject) {
        TngFormComponent formComponent = null;
        Integer maxLen = null;
        if (formObject instanceof TngFormObjectField) {
            formComponent = TngFormComponent.createFromFormObjectField((TngFormObjectField)formObject);
            maxLen = ((TngFormObjectField)formObject).getPrecision();
        } else if (formObject instanceof TngFormObjectComboBox) {
            formComponent = TngFormComponent.createFromFormObjectComboBox((TngFormObjectComboBox)formObject);
        } else if (formObject instanceof TngFormObjectLink) {
            formComponent = TngFormComponent.createFromFormObjectLink((TngFormObjectLink)formObject);
        } else if (formObject instanceof TngFormObjectCheckBox) {
            formComponent = TngFormComponent.createFromFormObjectCheckBox((TngFormObjectCheckBox)formObject);
        } else if (formObject instanceof TngFormObjectRadioButton) {
            formComponent = TngFormComponent.createFromFormObjectRadioButton((TngFormObjectRadioButton)formObject);
        }
        if (formComponent != null) {
            formComponent.setForm(form);
            formComponent.setFormObject(formObject);
            formComponent.initialize();
            if (maxLen != null) {
                if (formComponent instanceof TngFormFieldArea) {
                    ((TngFormFieldArea)formComponent).getComponent().setValueSize(maxLen);
                } else if (formComponent instanceof TngFormFieldString) {
                    ((TngFormFieldString)formComponent).getComponent().setValueSize(maxLen);
                }
            }
        }
        return formComponent;
    }

    private static TngFormComponent createFromFormObjectField(TngFormObjectField formObject) {
        TngFormComponent formComponent = null;
        if (TngFormObjectFieldType.AREA.equals((Object)formObject.getType())) {
            formComponent = new TngFormFieldArea();
        } else if (TngFormObjectFieldType.DATE.equals((Object)formObject.getType())) {
            formComponent = new TngFormFieldDate();
        } else if (TngFormObjectFieldType.DECIMAL.equals((Object)formObject.getType())) {
            formComponent = new TngFormFieldDecimal();
        } else if (TngFormObjectFieldType.INTEGER.equals((Object)formObject.getType())) {
            formComponent = new TngFormFieldInteger();
        } else if (TngFormObjectFieldType.STRING.equals((Object)formObject.getType())) {
            formComponent = new TngFormFieldString();
        }
        return formComponent;
    }

    private static TngFormComponent createFromFormObjectComboBox(TngFormObjectComboBox formObject) {
        TngFormComboBox formComponent = new TngFormComboBox();
        return formComponent;
    }

    private static TngFormComponent createFromFormObjectLink(TngFormObjectLink formObject) {
        TngFormLink formComponent = new TngFormLink();
        return formComponent;
    }

    private static TngFormComponent createFromFormObjectCheckBox(TngFormObjectCheckBox formObject) {
        TngFormCheckBox formComponent = new TngFormCheckBox();
        return formComponent;
    }

    private static TngFormComponent createFromFormObjectRadioButton(TngFormObjectRadioButton formObject) {
        TngFormRadioButton formComponent = new TngFormRadioButton();
        return formComponent;
    }
}

