/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import tangram.forms.visual.TngFormComponent;

public class TngFormPanelFocusTraversalPolicy
extends FocusTraversalPolicy {
    private final List<TngFormComponent> tabOrder = new ArrayList<TngFormComponent>();

    public void setData(List<TngFormComponent> formComponents) {
        this.tabOrder.clear();
        this.tabOrder.addAll(formComponents);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int idx = this.getComponentIndex(aComponent);
        return this.searchComponent(idx, this.tabOrder.size(), true);
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int idx = this.getComponentIndex(aComponent);
        return this.searchComponent(idx - 2, 0, false);
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        return this.searchComponent(0, this.tabOrder.size(), true);
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        return this.searchComponent(this.tabOrder.size() - 1, 0, false);
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.getFirstComponent(focusCycleRoot);
    }

    private Component getComponent(int idx) {
        if (idx < 0 || idx >= this.tabOrder.size()) {
            return null;
        }
        TngFormComponent formComponent = this.tabOrder.get(idx);
        if (formComponent.getComponent().isEnabled() && formComponent.getComponent().isVisible() && !formComponent.getFormObject().isVirtual()) {
            return formComponent.getComponent();
        }
        return null;
    }

    private int getComponentIndex(Component aComponent) {
        int idx = 0;
        for (int i2 = 0; i2 < this.tabOrder.size(); ++i2) {
            if (this.tabOrder.get(i2).getComponent() != aComponent) continue;
            idx = (i2 + 1) % this.tabOrder.size();
        }
        return idx;
    }

    private Component searchComponent(int indexFrom, int indexTo, boolean moveUp) {
        int i2 = indexFrom;
        while (moveUp ? i2 < indexTo : i2 >= indexTo) {
            Component component = this.getComponent(i2);
            if (component != null) {
                return component;
            }
            i2 += moveUp ? 1 : -1;
        }
        return null;
    }
}

