/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.BorderFactory;
import tangram.forms.struct.TngFormObjectField;
import tangram.forms.struct.TngFormScript;
import tangram.forms.visual.TngFormComponent;
import tangram.swing.component.field.TngField;
import tangram.swing.valuable.TngValueAdapter;
import tangram.swing.valuable.TngValueEvent;
import tangram.swing.valuable.TngValueWizardEvent;

public abstract class TngFormField
extends TngFormComponent {
    protected TngField field;

    @Override
    protected void initialize() {
        this.getComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e2) {
                if (TngFormField.this.isHighlight()) {
                    TngFormField.this.getComponent().setBackgroundEditable(HIGHLIGHT);
                }
            }

            @Override
            public void focusLost(FocusEvent e2) {
                TngFormField.this.getComponent().setBackgroundEditable(TngFormField.this.isTransparent() ? TRANSPARENT : null);
            }
        });
        super.initialize();
    }

    @Override
    protected void transparencyChanged() {
        if (!this.getComponent().isFocusOwner()) {
            this.getComponent().setBackgroundEditable(this.isTransparent() ? TngFormComponent.TRANSPARENT : null);
        }
    }

    @Override
    public TngField getComponent() {
        return this.field;
    }

    @Override
    public TngFormObjectField getFormObject() {
        return (TngFormObjectField)super.getFormObject();
    }

    @Override
    public void scriptLeft(final List<TngFormComponent> formComponents) {
        super.scriptLeft(formComponents);
        this.getComponent().setValueManualEdit(false);
        this.getComponent().setValueWizard(true);
        this.getComponent().setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 24));
        this.getComponent().addValueListener(new TngValueAdapter(){

            @Override
            public void valueWizard(TngValueWizardEvent e2) {
                TngFormField.this.wizard(formComponents);
                e2.consume();
            }
        });
    }

    @Override
    public void scriptRight(final List<TngFormComponent> formComponents) {
        super.scriptRight(formComponents);
        this.getComponent().addValueListener(new TngValueAdapter(){

            @Override
            public void valueChangedUser(TngValueEvent e2) {
                for (TngFormScript formScript : TngFormField.this.getForm().getScripts()) {
                    formScript.getOperator().executeScript(formComponents);
                }
            }
        });
    }

    private void wizard(List<TngFormComponent> formComponents) {
        for (TngFormScript formScript : this.getForm().getScripts()) {
            formScript.getOperator().wizard(this.getForm(), formComponents, this.getFormObject());
        }
    }
}

