/*
 * Decompiled with CFR 0.152.
 */
package tangram.forms.visual.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import tangram.forms.struct.TngFormObjectComboBox;
import tangram.forms.struct.TngFormObjectLink;
import tangram.forms.struct.TngFormScript;
import tangram.forms.visual.TngFormComponent;
import tangram.swing.component.field.TngFieldLinkNonSqlUni;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.valuable.TngValueAdapter;
import tangram.swing.valuable.TngValueEvent;

public class TngFormLink
extends TngFormComponent {
    protected TngFieldLinkNonSqlUni field;
    private final TngFormObjectComboBox.Option option = new TngFormObjectComboBox.Option();

    @Override
    protected void initialize() {
        this.field = new TngFieldLinkNonSqlUni();
        ArrayList<String[]> data = new ArrayList<String[]>();
        List<TngFormObjectComboBox.Option> options = this.getFormObject().getOptions();
        int valueSize = 0;
        if (options != null) {
            for (TngFormObjectComboBox.Option option : options) {
                data.add(new String[]{option.getExport(), option.getDisplay()});
                valueSize = Math.max(valueSize, option.getExport().length());
            }
        }
        this.field.setTablePanelByUniData(data);
        this.getComponent().setValueFormat(3);
        this.getComponent().setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.getComponent().setHorizontalAlignment(2);
        this.getComponent().setValueSize(valueSize);
        this.getComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e2) {
                if (TngFormLink.this.isHighlight()) {
                    TngFormLink.this.getComponent().setBackgroundEditable(HIGHLIGHT);
                }
            }

            @Override
            public void focusLost(FocusEvent e2) {
                TngFormLink.this.getComponent().setBackgroundEditable(TngFormLink.this.isTransparent() ? TRANSPARENT : null);
            }
        });
        super.initialize();
    }

    @Override
    protected void transparencyChanged() {
        if (!this.getComponent().isFocusOwner()) {
            this.getComponent().setBackgroundEditable(this.isTransparent() ? TngFormComponent.TRANSPARENT : null);
        }
    }

    @Override
    public TngFieldString getComponent() {
        return this.field;
    }

    @Override
    public TngFormObjectLink getFormObject() {
        return (TngFormObjectLink)super.getFormObject();
    }

    @Override
    public void scriptRight(final List<TngFormComponent> formComponents) {
        super.scriptRight(formComponents);
        this.getComponent().addValueListener(new TngValueAdapter(){

            @Override
            public void valueChangedUser(TngValueEvent e2) {
                for (TngFormScript formScript : TngFormLink.this.getForm().getScripts()) {
                    formScript.getOperator().executeScript(formComponents);
                }
            }
        });
    }

    @Override
    public void setValue(String value) {
        this.getComponent().setString(value);
    }

    @Override
    public String getValue() {
        return this.getComponent().getStringDef(null);
    }

    private void wizard() {
    }
}

