/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import tangram.library.TngUtilities;

public class Nat {
    private static String lang;
    private static Throwable error;
    private static HashMap<String, String> dictionary;

    private Nat() {
    }

    public static String nox(String phrase) {
        return phrase;
    }

    public static String nox(String phrase, Object ... args) {
        return Nat.format(phrase, args);
    }

    public static String x(String phrase) {
        return Nat.translate(phrase);
    }

    public static String x(String phrase, Object ... args) {
        phrase = Nat.translate(phrase);
        return Nat.format(phrase, args);
    }

    private static String format(String phrase, Object ... args) {
        StringBuilder result = new StringBuilder();
        int p2 = 0;
        while (p2 < phrase.length()) {
            int f2 = phrase.indexOf(37, p2);
            if (f2 < 0) {
                result.append(phrase.substring(p2));
                break;
            }
            if (f2 != 0) {
                result.append(phrase.substring(p2, f2));
            }
            int c2 = 0;
            if (f2 + 1 < phrase.length()) {
                c2 = phrase.charAt(f2 + 1);
            }
            if (c2 < 48 || c2 > 57) {
                result.append('%');
            } else {
                ++f2;
                int index = c2 - 48 - 1;
                if (index < 0 || index >= args.length) {
                    result.append('?');
                } else {
                    result.append(args[index] == null ? "<NULL>" : args[index].toString());
                }
            }
            p2 = f2 + 1;
        }
        return result.toString();
    }

    public static Throwable getError() {
        return error;
    }

    public static String getLang() {
        return lang;
    }

    private static String translate(String phrase) {
        if (dictionary == null) {
            return phrase;
        }
        String h2 = dictionary.get(phrase);
        if (h2 == null) {
            return phrase;
        }
        return h2;
    }

    private static void initialize() {
        try {
            dictionary = null;
            error = null;
            lang = Nat.readOneIniKey(new File("config.ini"), "global", "language", "");
            if (lang.length() == 0) {
                lang = null;
            }
            HashMap<String, String> dict = new HashMap<String, String>();
            if (lang != null) {
                Nat.load(new File("lang", lang + ".nat"), true, dict);
            }
            Nat.load(new File("custom", "custom.nat"), false, dict);
            if (dict.size() > 0) {
                dictionary = dict;
            }
        }
        catch (Throwable e2) {
            error = e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readOneIniKey(File file, String section, String key, String defValue) throws Exception {
        block6: {
            if (!file.exists()) {
                return defValue;
            }
            section = "[" + section.toLowerCase() + "]";
            key = key.toLowerCase() + "=";
            inSection = false;
            reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "windows-1250"));
                while ((h = reader.readLine()) != null) {
                    if ((h = h.trim()).length() == 0 || h.charAt(0) == ';') continue;
                    if (h.charAt(0) == '[') {
                        inSection = h.toLowerCase().equals(section);
                        continue;
                    }
                    if (!inSection || !h.toLowerCase().startsWith(key)) continue;
                    var7_7 = h.substring(key.length()).trim();
                    break block6;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var8_8) {
                Nat.closeReader(reader);
                throw var8_8;
            }
        }
        Nat.closeReader(reader);
        return var7_7;
lbl-1000:
        // 1 sources

        {
            var6_6 = defValue;
        }
        Nat.closeReader(reader);
        return var6_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(File file, boolean mustExists, HashMap<String, String> dic) throws Exception {
        if (!file.exists()) {
            if (mustExists) {
                throw new Exception(Nat.nox("S\u00fabor jazykovej podpory nebol n\u00e1jden\u00fd: %1", file.getAbsolutePath() + ""));
            }
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "windows-1250"));
            int row = 0;
            String[] threeLines = new String[3];
            while (Nat.readThreeLines(reader, threeLines)) {
                if (threeLines[0] == null || threeLines[0].charAt(0) != '#') {
                    throw new Exception(Nat.nox("Na za\u010diatku %1. riadku sa o\u010dak\u00e1val znak '#', s\u00fabor: %2", row + 1, file.getAbsolutePath()));
                }
                if (threeLines[1] == null) {
                    throw new Exception(Nat.nox("Prekladov\u00e1 fr\u00e1za v %1. riadku je pr\u00e1zdna, s\u00fabor: %2", row + 2, file.getAbsolutePath()));
                }
                row += 3;
                if (threeLines[2] == null) continue;
                String phrase = TngUtilities.stringEscapesOff(threeLines[1]);
                String translation = TngUtilities.stringEscapesOff(threeLines[2]);
                dic.put(phrase, translation);
            }
        }
        catch (Throwable throwable) {
            Nat.closeReader(reader);
            throw throwable;
        }
        Nat.closeReader(reader);
    }

    public static void loadExternal(File file, boolean mustExists) throws Exception {
        if (dictionary == null) {
            return;
        }
        Nat.load(file, mustExists, dictionary);
    }

    private static boolean readThreeLines(BufferedReader reader, String[] threeLines) throws Exception {
        threeLines[0] = null;
        threeLines[1] = null;
        threeLines[2] = null;
        for (int i2 = 0; i2 < 3; ++i2) {
            String line = reader.readLine();
            if (line == null) {
                return i2 > 0;
            }
            threeLines[i2] = (line = line.trim()).length() > 0 ? line : null;
        }
        return true;
    }

    private static void closeReader(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        Nat.initialize();
    }
}

