/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import tangram.exception.TngExceptionSql;
import tangram.library.Nat;
import tangram.library.TngConnectionChecker;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public class TngConnection {
    public static String DEF_DRIVER = "oracle.jdbc.OracleDriver";
    public static String DEF_TYPE = "thin";
    public static String DEF_HOST = "localhost";
    public static String DEF_SERVER = "dedicated";
    public static String DEF_SERVICE = "XE";
    public static String DEF_PROTOCOL = "tcp";
    public static String DEF_SCHEMA = null;
    public static String DEF_USER = null;
    public static int DEF_PORT = 1521;
    public static int DEF_LOGIN_TIMEOUT = 0;
    public static boolean DEF_AUTOCOMMIT = false;
    private String driver = DEF_DRIVER;
    private String type = DEF_TYPE;
    private String host = DEF_HOST;
    private String server = DEF_SERVER;
    private String service = DEF_SERVICE;
    private String protocol = DEF_PROTOCOL;
    private int port = DEF_PORT;
    private int loginTimeout = DEF_LOGIN_TIMEOUT;
    private boolean autocommit = DEF_AUTOCOMMIT;
    private String schema = DEF_SCHEMA;
    private String user = DEF_USER;
    private String password;
    private Connection connection;
    private Handle ihandle;
    private Vector<Handle> handles = new Vector();
    public static final String NO_CONNECTION = Nat.x("Pripojenie na SQL server e\u0161te nebolo uroben\u00e9");
    private static long JANUARY2000MILIS = 946681200000L;
    private static final String YMD_FORMAT = "yyyyMMdd";
    private static final SimpleDateFormat fmtYmdDate = new SimpleDateFormat("yyyyMMdd");
    private TngConnectionChecker connectionChecker = new TngConnectionChecker();

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public String getUserConnected() throws TngExceptionSql {
        return (String)this.queryObject("select USER from dual");
    }

    public String getSchemaConnected() throws TngExceptionSql {
        return (String)this.queryObject("select sys_context('userenv','current_schema') from dual");
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setAutoCommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public boolean getAutoCommit() {
        return this.autocommit;
    }

    private String getURL() {
        String url = "jdbc:oracle:" + this.type + ":@\n(DESCRIPTION=\n(ADDRESS=(PROTOCOL=" + this.protocol + ")(HOST=" + this.host + ")" + "(PORT=" + this.port + "))" + "\n(CONNECT_DATA=(SERVICE_NAME=" + this.service + ")" + "(SERVER=" + this.server + "))\n)";
        return url;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static TngConnection copy(TngConnection sourceConn) throws Exception {
        TngConnection targetConn = new TngConnection();
        targetConn.driver = sourceConn.driver;
        targetConn.type = sourceConn.type;
        targetConn.host = sourceConn.host;
        targetConn.server = sourceConn.server;
        targetConn.service = sourceConn.service;
        targetConn.protocol = sourceConn.protocol;
        targetConn.port = sourceConn.port;
        targetConn.loginTimeout = sourceConn.loginTimeout;
        targetConn.autocommit = sourceConn.autocommit;
        return targetConn;
    }

    public boolean equalsDestination(TngConnection other) {
        if (other == null) {
            return false;
        }
        if (!this.host.equalsIgnoreCase(other.host)) {
            return false;
        }
        if (!this.service.equalsIgnoreCase(other.service)) {
            return false;
        }
        return this.schema.equalsIgnoreCase(other.schema);
    }

    public synchronized void connect() throws TngExceptionSql {
        if (this.connection != null) {
            this.close();
        }
        try {
            Class.forName(this.driver);
            String url = this.getURL();
            Driver drv = DriverManager.getDriver(url);
            if (drv.getMajorVersion() < 11 || drv.getMajorVersion() == 11 && drv.getMinorVersion() < 2) {
                throw new TngExceptionSql(Nat.x("Verzia ORACLE JDBC drivera je %1.%2, po\u017eaduje sa verzia minim\u00e1lne %3", drv.getMajorVersion(), drv.getMinorVersion(), "11.2"), "JDBC driver");
            }
            DriverManager.setLoginTimeout(this.loginTimeout);
            Properties prop = new Properties();
            prop.setProperty("oracle.jdbc.mapDateToTimestamp", "true");
            prop.setProperty("oracle.jdbc.J2EE13Compliant", "true");
            prop.setProperty("user", this.user);
            prop.setProperty("password", this.password);
            this.connection = DriverManager.getConnection(url, prop);
            this.connection.setTransactionIsolation(2);
            this.connection.setHoldability(1);
            this.connection.setAutoCommit(this.autocommit);
            Statement st = this.connection.createStatement(1003, 1007);
            st.setFetchSize(1);
            this.ihandle = new Handle(st, "internal");
            this.handles.add(this.ihandle);
            this.alterSession();
            this.connectionCheckerStart();
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, "connect");
        }
    }

    public boolean isConnected() {
        if (this.connection == null) {
            return false;
        }
        try {
            return !this.connection.isClosed();
        }
        catch (Throwable e2) {
            return false;
        }
    }

    public static boolean isUniqueViolation(SQLException e2) {
        return e2.getErrorCode() == 1;
    }

    public static boolean isErrorLogin(Exception e2) {
        String h2 = e2.getMessage();
        if (h2 == null) {
            return false;
        }
        return h2.indexOf("ORA-01017:") >= 0;
    }

    protected void alterSession() throws TngExceptionSql {
        this.exec("alter session set NLS_DATE_FORMAT='dd.mm.yyyy hh24:mi:ss'");
        this.exec("alter session set NLS_TIMESTAMP_FORMAT='dd.mm.yyyy hh24:mi:ss'");
        this.exec("alter session set NLS_SORT='BINARY_AI'");
        this.exec("alter session set NLS_COMP='BINARY'");
        this.exec("alter session set NLS_NUMERIC_CHARACTERS='.,'");
        if (this.schema != null && this.schema.length() > 0) {
            this.exec("alter session set CURRENT_SCHEMA=\"" + this.schema + "\"");
        }
    }

    public void setSessionName(String module, String action) {
        try {
            module = TngUtilities.strLeft(module, 48);
            action = TngUtilities.strLeft(action, 32);
            this.exec("begin dbms_application_info.set_module('" + module + "','" + action + "'); end;");
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    public void setSessionInfo(String info) {
        try {
            info = TngUtilities.strLeft(info, 48);
            this.exec("begin dbms_application_info.set_client_info('" + info + "'); end;");
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    public void changeSchema(String schema) throws TngExceptionSql {
        if (schema == null || schema.length() == 0) {
            schema = this.getUserConnected();
        }
        this.exec("alter session set CURRENT_SCHEMA=" + schema + "");
        this.schema = schema;
    }

    public void readSchemas(TngConnection connection, List<String> names) throws TngExceptionSql {
        names.clear();
        connection.addQueryRows(names, "SELECT owner FROM all_tables WHERE table_name='VERZIE' ORDER BY owner");
    }

    public boolean isSchemaEmpty() throws Exception {
        int count = this.queryInt("SELECT count(*) FROM all_tables WHERE owner=sys_context('userenv','current_schema')");
        return count == 0;
    }

    public boolean hasHandles() {
        return this.handles.size() > 1;
    }

    public synchronized void close() {
        if (this.handles.size() > 1) {
            TngSwing.exceptionShow(new Exception(Nat.x("Neodpojen\u00e9 SQL handly:") + "\n" + this.getHandlesInfo()));
        }
        this.closeSilent();
        this.connectionCheckerStop();
    }

    public synchronized void closeSilent() {
        this.closeHandles();
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
        this.connection = null;
    }

    public synchronized void commit() throws TngExceptionSql {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.commit();
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, "commit");
        }
    }

    public synchronized void rollback() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.rollback();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public boolean execWet(String sql) {
        try {
            this.exec(sql);
            return true;
        }
        catch (Exception e2) {
            this.showErrorWet(e2);
            return false;
        }
    }

    public synchronized void exec(String sql) throws TngExceptionSql {
        if (this.ihandle == null) {
            throw new TngExceptionSql(NO_CONNECTION, sql);
        }
        this.ihandle.sql = sql;
        try {
            this.ihandle.st.execute(sql);
            ResultSet res = this.ihandle.st.getResultSet();
            if (res != null) {
                res.close();
            }
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, sql);
        }
    }

    public Object queryObjectWet(String sql) {
        try {
            return this.queryObject(sql);
        }
        catch (Exception e2) {
            this.showErrorWet(e2);
            return null;
        }
    }

    public int queryInt(String sql) throws TngExceptionSql {
        Object o2 = this.queryObject(sql);
        return TngUtilities.strToInt(o2, 0);
    }

    public synchronized Object queryObject(String sql) throws TngExceptionSql {
        ResultSet rs;
        block6: {
            if (this.ihandle == null) {
                throw new TngExceptionSql(NO_CONNECTION, sql);
            }
            rs = null;
            this.ihandle.sql = sql;
            rs = this.ihandle.st.executeQuery(sql);
            if (!rs.next()) break block6;
            Object object = rs.getObject(1);
            this.close(rs);
            return object;
        }
        try {
            Object var3_4 = null;
            this.close(rs);
            return var3_4;
        }
        catch (Exception e2) {
            try {
                throw new TngExceptionSql(e2, sql);
            }
            catch (Throwable throwable) {
                this.close(rs);
                throw throwable;
            }
        }
    }

    public Object[] queryObjectsWet(String sql) {
        try {
            return this.queryObjects(sql);
        }
        catch (Exception e2) {
            this.showErrorWet(e2);
            return null;
        }
    }

    public synchronized Object[] queryObjects(String sql) throws TngExceptionSql {
        ResultSet rs;
        block7: {
            if (this.ihandle == null) {
                throw new TngExceptionSql(NO_CONNECTION, sql);
            }
            rs = null;
            this.ihandle.sql = sql;
            rs = this.ihandle.st.executeQuery(sql);
            if (!rs.next()) break block7;
            int columns = rs.getMetaData().getColumnCount();
            Object[] o2 = new Object[columns];
            for (int i2 = 0; i2 < columns; ++i2) {
                o2[i2] = rs.getObject(i2 + 1);
            }
            Object[] objectArray = o2;
            this.close(rs);
            return objectArray;
        }
        try {
            Object[] columns = null;
            this.close(rs);
            return columns;
        }
        catch (Exception e2) {
            try {
                throw new TngExceptionSql(e2, sql);
            }
            catch (Throwable throwable) {
                this.close(rs);
                throw throwable;
            }
        }
    }

    public Vector queryRows(String sql) throws TngExceptionSql {
        Vector v2 = new Vector(256);
        this.addQueryRows(v2, sql);
        return v2;
    }

    public synchronized void addQueryRows(List list, String sql) throws TngExceptionSql {
        if (this.ihandle == null) {
            throw new TngExceptionSql(NO_CONNECTION, sql);
        }
        ResultSet rs = null;
        try {
            this.ihandle.sql = sql;
            rs = this.ihandle.st.executeQuery(sql);
            while (rs.next()) {
                Object o2 = rs.getObject(1);
                list.add(o2);
            }
            this.close(rs);
        }
        catch (Exception e2) {
            try {
                throw new TngExceptionSql(e2, sql);
            }
            catch (Throwable throwable) {
                this.close(rs);
                throw throwable;
            }
        }
    }

    public PreparedStatement prepareStatement(String sql) throws TngExceptionSql {
        if (this.connection == null) {
            throw new TngExceptionSql(NO_CONNECTION, sql);
        }
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            this.handles.add(new Handle(ps, "prepared", sql));
            return ps;
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, sql);
        }
    }

    public CallableStatement callableStatement(String sql) throws TngExceptionSql {
        if (this.connection == null) {
            throw new TngExceptionSql(NO_CONNECTION, sql);
        }
        try {
            CallableStatement ps = this.connection.prepareCall(sql);
            this.handles.add(new Handle(ps, "callable", sql));
            return ps;
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, sql);
        }
    }

    public ResultSet executeQuery(PreparedStatement st) throws TngExceptionSql {
        try {
            return st.executeQuery();
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, this.getSql(st));
        }
    }

    public int executeUpdate(PreparedStatement st) throws TngExceptionSql {
        try {
            return st.executeUpdate();
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, this.getSql(st));
        }
    }

    public ResultSet executeQuery(CallableStatement st) throws TngExceptionSql {
        try {
            return st.executeQuery();
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, this.getSql(st));
        }
    }

    public int executeUpdate(CallableStatement st) throws TngExceptionSql {
        try {
            return st.executeUpdate();
        }
        catch (Exception e2) {
            throw new TngExceptionSql(e2, this.getSql(st));
        }
    }

    public Statement execStatement(String sql) throws TngExceptionSql {
        return this.execStatement(null, sql, false);
    }

    public Statement execStatement(Statement st, String sql) throws TngExceptionSql {
        return this.execStatement(st, sql, false);
    }

    public Statement execStatement(Statement st, String sql, boolean scrollable) throws TngExceptionSql {
        if (this.connection == null) {
            throw new TngExceptionSql(NO_CONNECTION, sql);
        }
        boolean disconnect = st == null;
        try {
            int direction;
            Handle h2 = null;
            int n2 = direction = scrollable ? 1004 : 1003;
            if (st == null) {
                st = this.connection.createStatement(direction, 1007);
            } else {
                if (st.getConnection() != this.connection) {
                    throw new Exception(Nat.x("SQL statement z in\u00e9ho pripojenia"));
                }
                h2 = this.findHandle(st);
            }
            if (h2 == null) {
                h2 = new Handle(st, "executed", sql);
                this.handles.add(h2);
            } else {
                h2.sql = sql;
            }
            if (sql != null) {
                st.execute(sql);
            }
            return st;
        }
        catch (Exception e2) {
            if (disconnect) {
                this.close(st);
            }
            throw new TngExceptionSql(e2, sql);
        }
    }

    public synchronized void close(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    public synchronized void close(Statement st) {
        if (st == null) {
            return;
        }
        Handle h2 = this.findHandle(st);
        if (h2 == null) {
            System.out.println(Nat.nox("Odp\u00e1janie nezaregistrovan\u00e9ho SQL handlu"));
        }
        try {
            st.close();
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
        if (h2 != null) {
            this.handles.remove(h2);
        }
    }

    private void closeHandles() {
        while (this.handles.size() > 0) {
            Handle h2 = this.handles.get(this.handles.size() - 1);
            this.close(h2.st);
        }
    }

    private Handle findHandle(Statement st) {
        Handle[] safe = this.handles.toArray(new Handle[0]);
        for (int i2 = 0; i2 < safe.length; ++i2) {
            Handle h2 = safe[i2];
            if (h2.st != st) continue;
            return h2;
        }
        return null;
    }

    public String getSql(Statement st) {
        Handle h2 = this.findHandle(st);
        if (h2 == null) {
            return Nat.x("Nezaregistrovan\u00fd SQL pr\u00edkaz");
        }
        return h2.sql;
    }

    public String toString() {
        String h2 = "Server: " + this.host + "/" + this.service;
        if (this.autocommit) {
            h2 = h2 + " (autocommit)";
        }
        h2 = h2 + " User: " + this.user;
        if (this.schema != null) {
            h2 = h2 + " Schema: " + this.schema;
        }
        return h2;
    }

    public String getHandlesInfo() {
        StringBuilder buff = new StringBuilder(512);
        buff.append(this.toString());
        buff.append("\n\n");
        for (int i2 = 0; i2 < this.handles.size(); ++i2) {
            Handle h2 = this.handles.get(i2);
            if (i2 > 0) {
                buff.append("\n\n");
            }
            buff.append(i2 + 1);
            buff.append(". SQL handle: ");
            buff.append(h2.name);
            int r2 = h2.getResulsetRow();
            if (r2 > 0) {
                buff.append(" (current resultset row: ");
                buff.append(r2);
                buff.append(")");
            } else {
                buff.append(" (no resultset)");
            }
            buff.append("\n");
            buff.append(h2.sql);
        }
        return buff.toString();
    }

    protected void showErrorWet(Throwable e2) {
        TngSwing.exceptionShow(e2);
    }

    public static String getNewXxSqlExpression() {
        return "to_char((sysdate-date'2000-01-01')*100000,'fm000000000')||dbms_random.string('u',7)";
    }

    public static String getNewXx() {
        long t2 = System.currentTimeMillis() - JANUARY2000MILIS;
        String h2 = Long.toString(t2 / 1000L);
        h2 = h2 + TngUtilities.randomString(16 - h2.length());
        return h2;
    }

    public static String simpleRegexp(String column, String find) {
        if (find == null && find.length() == 0) {
            return null;
        }
        return "regexp_like(" + column + ",'" + TngConnection.simpleRegexp(find) + "')";
    }

    public static String simpleLike(String column, String find) {
        if (find == null && find.length() == 0) {
            return null;
        }
        return column + " like '" + TngConnection.simpleLike(find) + "'";
    }

    public static String simpleRegexp(String find) {
        if (find == null || find.length() == 0) {
            return null;
        }
        if ("*".equals(find)) {
            return "*";
        }
        StringBuilder regexp = new StringBuilder();
        int i2 = 0;
        int l2 = find.length();
        if (find.charAt(0) == '*') {
            ++i2;
        } else {
            regexp.append('^');
        }
        boolean endExact = false;
        if (find.charAt(l2 - 1) == '*') {
            --l2;
        } else {
            endExact = true;
        }
        while (i2 < l2) {
            char c2 = find.charAt(i2);
            if (c2 == '*') {
                regexp.append(".*");
            } else if (c2 == '\'') {
                regexp.append("''");
            } else if ("\\?.*+|^&$()[]{}".indexOf(c2) >= 0) {
                regexp.append('\\');
                regexp.append(c2);
            } else {
                regexp.append(c2);
            }
            ++i2;
        }
        if (endExact) {
            regexp.append('$');
        }
        return regexp.toString();
    }

    public static String simpleLike(String find) {
        if (find == null || find.length() == 0) {
            return null;
        }
        if ("*".equals(find)) {
            return "%";
        }
        StringBuilder regexp = new StringBuilder();
        for (int i2 = 0; i2 < find.length(); ++i2) {
            char c2 = find.charAt(i2);
            if (c2 == '*') {
                regexp.append("%");
                continue;
            }
            if (c2 == '\'') {
                regexp.append("''");
                continue;
            }
            if ("\\%_".indexOf(c2) >= 0) {
                regexp.append('\\');
                regexp.append(c2);
                continue;
            }
            regexp.append(c2);
        }
        return regexp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToTngvar(String kluc, String hodnota) throws Exception {
        PreparedStatement st = null;
        try {
            String cmd = "MERGE INTO TNGVAR USING DUAL ON (TNGVAR.kluc=? and TNGVAR.uzivatel is null)";
            cmd = cmd + "\nWHEN MATCHED THEN UPDATE SET hodnota=?";
            cmd = cmd + "\nWHEN NOT MATCHED THEN INSERT (kluc,uzivatel,hodnota) VALUES (?,null,?)";
            st = this.prepareStatement(cmd);
            st.setString(1, kluc);
            st.setString(2, hodnota);
            st.setString(3, kluc);
            st.setString(4, hodnota);
            st.execute();
            this.close(st);
        }
        catch (Throwable throwable) {
            this.close(st);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToTngvarUser(String kluc, String hodnota) throws Exception {
        PreparedStatement st = null;
        try {
            String cmd = "MERGE INTO TNGVAR USING DUAL ON (TNGVAR.kluc=? and TNGVAR.uzivatel=USER)";
            cmd = cmd + "\nWHEN MATCHED THEN UPDATE SET hodnota=?";
            cmd = cmd + "\nWHEN NOT MATCHED THEN INSERT (kluc,uzivatel,hodnota) VALUES (?,USER,?)";
            st = this.prepareStatement(cmd);
            st.setString(1, kluc);
            st.setString(2, hodnota);
            st.setString(3, kluc);
            st.setString(4, hodnota);
            st.execute();
            this.close(st);
        }
        catch (Throwable throwable) {
            this.close(st);
            throw throwable;
        }
    }

    public String loadFromTngvar(String kluc) throws Exception {
        return (String)this.queryObject("SELECT hodnota FROM TNGVAR WHERE kluc='" + kluc + "' and uzivatel IS NULL");
    }

    public String loadFromTngvarUser(String kluc) throws Exception {
        return (String)this.queryObject("SELECT hodnota FROM TNGVAR WHERE kluc='" + kluc + "' and uzivatel=USER");
    }

    public String loadFromTngvarUser(String kluc, String defValue) {
        String value = null;
        try {
            value = this.loadFromTngvarUser(kluc);
            if (value == null) {
                value = defValue;
            }
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
            value = defValue;
        }
        return value;
    }

    public String dateToSql(Date date) {
        if (date == null) {
            return "NULL";
        }
        return "'" + TngUtilities.dateToStr(date) + "'";
    }

    public String createTempTablename() throws Exception {
        return this.getUserConnected() + ".TMP__" + TngUtilities.dateTimeToStr(System.currentTimeMillis(), fmtYmdDate) + TngUtilities.randomString(4);
    }

    public String createTempIndexname() throws Exception {
        return this.getUserConnected() + ".TMPIDX__" + TngUtilities.dateTimeToStr(System.currentTimeMillis(), fmtYmdDate) + TngUtilities.randomString(4);
    }

    public void createTempTable(String tableName, String sqlSelect) throws Exception {
        String createTableSql = "CREATE GLOBAL TEMPORARY TABLE " + tableName + " ON COMMIT PRESERVE ROWS ";
        String createTableSqlWithSelect = TngUtilities.strExt(createTableSql, " ", sqlSelect);
        this.exec(createTableSqlWithSelect);
    }

    public void dropTempTable(String tableName) {
        String truncateTableSql = "TRUNCATE TABLE " + tableName;
        String dropTableSql = "DROP TABLE " + tableName;
        try {
            this.exec(truncateTableSql);
            this.exec(dropTableSql);
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    private void connectionCheckerStart() {
        this.connectionChecker.startCheck(this);
    }

    private void connectionCheckerStop() {
        this.connectionChecker.stopCheck();
    }

    private class Handle {
        public Statement st;
        public String sql;
        public String name;

        public Handle(Statement st, String name) {
            this.st = st;
            this.name = name;
            this.sql = null;
        }

        public Handle(Statement st, String name, String sql) {
            this.st = st;
            this.name = name;
            this.sql = sql;
        }

        public int getResulsetRow() {
            if (this.st == null) {
                return 0;
            }
            try {
                ResultSet res = this.st.getResultSet();
                if (res == null) {
                    return 0;
                }
                return res.getRow();
            }
            catch (Exception e2) {
                TngUtilities.exceptionLog(e2);
                return 0;
            }
        }
    }
}

