/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import tangram.library.Nat;

public final class TngConversion {
    private static final String unicode = Nat.nox("\u00c1\u00c4\u010c\u010e\u00c9\u011a\u00cb\u00cd\u0139\u013d\u0147\u00d3\u00d4\u00d6\u0154\u0158\u0160\u0164\u00da\u016e\u00dc\u00dd\u017d\u00e1\u00e4\u010d\u010f\u00e9\u011b\u00eb\u00ed\u013a\u013e\u0148\u00f3\u00f4\u00f6\u0155\u0159\u0161\u0165\u00fa\u016f\u00fc\u00fd\u017e\u00d7");
    private static final String ascii = Nat.nox("AACDEEEILLNOOORRSTUUUYZaacdeeeillnooorrstuuuyz?");
    private static final String win1250 = new String(new char[]{'\u00c1', '\u00c4', '\u00c8', '\u00cf', '\u00c9', '\u00cc', '\u00cb', '\u00cd', '\u00c5', '\u00bc', '\u00d2', '\u00d3', '\u00d4', '\u00d6', '\u00c0', '\u00d8', '\u008a', '\u008d', '\u00da', '\u00d9', '\u00dc', '\u00dd', '\u008e', '\u00e1', '\u00e4', '\u00e8', '\u00ef', '\u00e9', '\u00ec', '\u00eb', '\u00ed', '\u00e5', '\u00be', '\u00f2', '\u00f3', '\u00f4', '\u00f6', '\u00e0', '\u00f8', '\u009a', '\u009d', '\u00fa', '\u00f9', '\u00fc', '\u00fd', '\u009e', '\u00d7'});
    private static final String latin2 = new String(new char[]{'\u00b5', '\u008e', '\u00ac', '\u00d2', '\u0090', '\u00b7', '\u00d3', '\u00d6', '\u0091', '\u0095', '\u00d5', '\u00e0', '\u00e2', '\u0099', '\u00e8', '\u00fc', '\u00e6', '\u009b', '\u00e9', '\u00de', '\u009a', '\u00ed', '\u00a6', '\u00a0', '\u0084', '\u009f', '\u00d4', '\u0082', '\u00d8', '\u0089', '\u00a1', '\u0092', '\u0096', '\u00e5', '\u00a2', '\u0093', '\u0094', '\u00ea', '\u00fd', '\u00e7', '\u009c', '\u00a3', '\u0085', '\u0081', '\u00ec', '\u00a7', '\u009e'});

    public static String unicodeToAscii(String str) {
        return TngConversion.translateString(str, unicode, ascii, '?');
    }

    public static String unicodeToWin1250(String str) {
        return TngConversion.translateString(str, unicode, win1250, '?');
    }

    public static String unicodeToLatin2(String str) {
        return TngConversion.translateString(str, unicode, latin2, '?');
    }

    public static String latin2ToUnicode(String str) {
        return TngConversion.translateString(str, latin2, unicode, '?');
    }

    public static String win1250ToUnicode(String str) {
        return TngConversion.translateString(str, win1250, unicode, '?');
    }

    public static char unicodeToAscii(char c2) {
        return TngConversion.translateChar(c2, unicode, ascii, '?');
    }

    public static char unicodeToWin1250(char c2) {
        return TngConversion.translateChar(c2, unicode, win1250, '?');
    }

    public static char win1250ToUnicode(char c2) {
        return TngConversion.translateChar(c2, win1250, unicode, '?');
    }

    public static char unicodeToLain2(char c2) {
        return TngConversion.translateChar(c2, unicode, latin2, '?');
    }

    public static char latin2ToUnicode(char c2) {
        return TngConversion.translateChar(c2, latin2, unicode, '?');
    }

    public static String translateString(String str, String tblA, String tblB, char unknown) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] res = new char[str.length()];
        for (int i2 = 0; i2 < str.length(); ++i2) {
            res[i2] = TngConversion.translateChar(str.charAt(i2), tblA, tblB, unknown);
        }
        return new String(res);
    }

    public static char translateChar(char c2, String tblA, String tblB, char unknown) {
        if (c2 <= '~') {
            return c2;
        }
        int f2 = tblA.indexOf(c2);
        if (f2 < 0) {
            return unknown;
        }
        return tblB.charAt(f2);
    }
}

