/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.awt.Color;
import java.awt.Font;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngFont {
    public Font font;
    public Color foreGround;
    public Color backGround;

    public static TngFont createFromString(String str) throws Exception {
        TngFont font = new TngFont();
        font.fromString(str);
        return font;
    }

    public void fromString(String str) throws Exception {
        this.font = null;
        this.foreGround = null;
        this.backGround = null;
        if (str == null || str.length() == 0) {
            return;
        }
        String[] h2 = new String[3];
        if (TngUtilities.strTokenizeTrim(str, ';', h2) < 1) {
            return;
        }
        this.font = this.fontFromString(h2[0]);
        this.foreGround = this.colorFromString(h2[1]);
        this.backGround = this.colorFromString(h2[2]);
        if (h2[0].length() != 0 && this.font == null || h2[1].length() != 0 && this.foreGround == null || h2[2].length() != 0 && this.backGround == null) {
            throw new Exception(Nat.x("Nespr\u00e1vna syntax fontu: %1", str));
        }
    }

    public String toString() {
        String h2 = "";
        if (this.font != null) {
            String style = "";
            if (this.font.getStyle() == 0) {
                style = style + "P";
            }
            if (this.font.getStyle() >= 1) {
                style = style + "B";
            }
            if (this.font.getStyle() >= 2) {
                style = style + "I";
            }
            h2 = this.font.getName() + "/" + style + this.font.getSize();
        }
        if (this.foreGround != null) {
            h2 = h2 + ";" + this.foreGround.getRed() + "," + this.foreGround.getGreen() + "," + this.foreGround.getBlue() + "";
        }
        if (this.backGround != null) {
            h2 = h2 + ";" + this.backGround.getRed() + "," + this.backGround.getGreen() + "," + this.backGround.getBlue() + "";
        }
        return h2;
    }

    public Color colorFromString(String str) {
        String[] h2;
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.charAt(0) == '{') {
            if (str.charAt(str.length() - 1) != '}') {
                return null;
            }
            str = str.substring(1, str.length() - 1);
        }
        if (TngUtilities.strTokenizeTrim(str, ',', h2 = new String[3]) != 3) {
            return null;
        }
        try {
            int r2 = Integer.parseInt(h2[0]);
            int g2 = Integer.parseInt(h2[1]);
            int b2 = Integer.parseInt(h2[2]);
            if (r2 < 0 || r2 > 255 || g2 < 0 || g2 > 255 || b2 < 0 || b2 > 255) {
                return null;
            }
            return new Color(r2, g2, b2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Font fontFromString(String str) {
        char c2;
        int i2;
        if (str == null || str.length() == 0) {
            return null;
        }
        String name = null;
        int style = 0;
        int size = 0;
        int f2 = str.indexOf(47);
        if (f2 >= 0) {
            name = TngUtilities.strLeft(str, f2);
            str = TngUtilities.strCut(str, f2 + 1);
        }
        for (i2 = 0; i2 < str.length() && ((c2 = str.charAt(i2)) < '0' || c2 > '9'); ++i2) {
            if (c2 == 'P') {
                style |= 0;
                continue;
            }
            if (c2 == 'B') {
                style |= 1;
                continue;
            }
            if (c2 == 'I') {
                style |= 2;
                continue;
            }
            return null;
        }
        str = TngUtilities.strCut(str, i2);
        try {
            size = Integer.parseInt(str);
            if (size <= 0) {
                return null;
            }
        }
        catch (Exception e2) {
            return null;
        }
        if (name == null || name.length() == 0) {
            name = "bez nazvu";
        }
        return new Font(name, style, size);
    }
}

