/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.util.Date;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;

public abstract class TngLicence2 {
    private String error;
    private boolean valid;
    public String id;
    public String access;
    public int version;
    public Date date;
    private static final String KEYS_DIV = "-------------\n";

    public abstract String getProject();

    protected abstract void resetCustomData();

    protected abstract void loadCustomData(String var1);

    protected abstract void saveCustomData(StringBuilder var1) throws Exception;

    public TngLicence2() {
        this.reset();
    }

    public void reset() {
        this.error = Nat.x("Nezadan\u00fd licen\u010dn\u00fd k\u013e\u00fa\u010d");
        this.valid = false;
        this.id = null;
        this.access = null;
        this.version = 0;
        this.date = null;
        this.resetCustomData();
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getError() {
        return this.error;
    }

    public int getDaysToExpiration() {
        if (!this.valid) {
            return 0;
        }
        if (this.date == null) {
            return Integer.MAX_VALUE;
        }
        int days = 1 + TngUtilities.dateDifferenceDays(this.date, new Date());
        return days < 0 ? 0 : days;
    }

    public String check(String id, int programMajorVersion) {
        this.valid = false;
        if (!TngUtilities.isEmpty(this.error)) {
            return null;
        }
        if (!this.id.equals(id)) {
            return Nat.x("Licen\u010dn\u00fd k\u013e\u00fa\u010d je ur\u010den\u00fd pre in\u00e9 ID");
        }
        if (this.version > 0 && programMajorVersion > this.version) {
            return Nat.x("Licencia bola platn\u00e1 do verzie %1", this.version);
        }
        this.valid = true;
        int days = this.getDaysToExpiration();
        if (days == 0) {
            return Nat.x("Licencia plat\u00ed pre z\u00e1znamy do %1", TngUtilities.dateToStr(this.date));
        }
        if (days <= 30) {
            return Nat.x("Licencia plat\u00ed pre z\u00e1znamy do %1, zost\u00e1va %2 dn\u00ed", TngUtilities.dateToStr(this.date), days);
        }
        return null;
    }

    public void setKey(String key) {
        this.reset();
        if (TngUtilities.isEmpty(key)) {
            this.error = Nat.x("Nezadan\u00fd licen\u010dn\u00fd k\u013e\u00fa\u010d");
            return;
        }
        try {
            if (!TngLicence2.verifyKey(key)) {
                this.error = Nat.x("Licen\u010dn\u00fd k\u013e\u00fa\u010d je chybn\u00fd");
                return;
            }
        }
        catch (Exception e2) {
            this.error = TngUtilities.exceptionText(e2);
            return;
        }
        String project = TngLicence2.getItemStr(key, "PROJECT");
        if (!project.equals(this.getProject())) {
            this.error = Nat.x("Licen\u010dn\u00fd k\u013e\u00fa\u010d je pre %1 a nie pre %2", project, this.getProject());
            return;
        }
        this.id = TngLicence2.getItemStr(key, "ID");
        this.access = TngLicence2.getItemStr(key, "ACCESS");
        this.date = TngLicence2.getItemDate(key, "DATE");
        this.version = TngLicence2.getItemInt(key, "VERSION");
        this.loadCustomData(key);
        this.error = null;
    }

    public String createKey() throws Exception {
        if (this.id == null) {
            throw new Exception(Nat.x("Licencia nem\u00e1 nastaven\u00e9 ID"));
        }
        if (this.version < 1 && this.date == null) {
            throw new Exception(Nat.x("Licencia nem\u00e1 \u017eiadne obmedzenie"));
        }
        StringBuilder key = new StringBuilder(250);
        TngLicence2.addItemStr(key, "PROJECT", this.getProject());
        TngLicence2.addItemDate(key, "DATE", this.date);
        TngLicence2.addItemInt(key, "VERSION", this.version);
        this.saveCustomData(key);
        TngLicence2.addItemStr(key, "ID", this.id);
        TngLicence2.addItemStr(key, "ACCESS", this.access);
        TngLicence2.addHash(key);
        String h2 = key.toString();
        if (h2.length() > 250) {
            throw new Exception(Nat.x("Licen\u010dn\u00fd k\u013eu\u010d presiahol d\u013a\u017eku 250 znakov, skr\u00e1\u0165te n\u00e1zov firmy"));
        }
        return h2;
    }

    protected static void addItemStr(StringBuilder key, String item, Object value) {
        key.append(item);
        key.append('=');
        key.append(value);
        key.append('\n');
    }

    protected static void addItemInt(StringBuilder key, String item, int value) {
        TngLicence2.addItemStr(key, item, Integer.toString(value));
    }

    protected static void addItemDate(StringBuilder key, String item, Date value) {
        TngLicence2.addItemStr(key, item, TngUtilities.dateToStr(value));
    }

    protected static void addHash(StringBuilder key) throws Exception {
        String hash = TngLicence2.createHash(key.toString(), 0);
        TngLicence2.addItemStr(key, "HASH", hash);
    }

    protected static String getItemStr(String key, String item) {
        String k2 = item + "=";
        int b2 = 0;
        if (!key.startsWith(k2)) {
            k2 = '\n' + k2;
            b2 = key.indexOf(k2);
        }
        if (b2 < 0) {
            return "";
        }
        int e2 = key.indexOf(10, b2 += k2.length());
        if (e2 < 0) {
            return key.substring(b2);
        }
        return key.substring(b2, e2);
    }

    protected static int getItemInt(String key, String item) {
        String h2 = TngLicence2.getItemStr(key, item);
        return TngUtilities.strToInt(h2, 0);
    }

    protected static Date getItemDate(String key, String item) {
        String h2 = TngLicence2.getItemStr(key, item);
        return TngUtilities.strToDate(h2);
    }

    public static String getProjectFromKey(String key) {
        return TngLicence2.getItemStr(key, "PROJECT");
    }

    public static String getIdFromKey(String key) {
        return TngLicence2.getItemStr(key, "ID");
    }

    public static boolean verifyKey(String key) throws Exception {
        String hash1 = TngLicence2.getItemStr(key, "HASH");
        if (hash1.length() != 8) {
            return false;
        }
        String hash2 = TngLicence2.createHash(key, 14);
        return hash1.equals(hash2);
    }

    public static String createDatabaseId(TngConnection connection) throws Exception {
        Object o2 = connection.queryObject("select to_char(created,'DDMMYYHH24MISS') from all_objects where owner='SYS' and object_name='UTL_RECOMP_SEQ'");
        long value = 0L;
        try {
            value = Long.parseLong(o2.toString());
        }
        catch (Exception e2) {
            throw new Exception(Nat.x("Nie je mo\u017en\u00e9 vytvori\u0165 ID"));
        }
        int radix = 26;
        int size = 8;
        char[] r2 = new char[size];
        for (int i2 = size - 1; i2 >= 0; --i2) {
            long h2 = value;
            r2[i2] = (char)(65L + (h2 - (value /= (long)radix) * (long)radix));
        }
        return new String(r2);
    }

    public static String createHash(String data, int ignoreEndsChars) throws Exception {
        byte[] bytes = data.getBytes("windows-1250");
        int count = bytes.length - ignoreEndsChars;
        int crc1 = 13;
        int crc2 = 31;
        for (int i2 = 0; i2 < count; ++i2) {
            int b2 = bytes[i2] & 0xFF;
            crc1 += b2;
            crc2 += b2 * (i2 % 256 + 1);
        }
        char[] hash = new char[8];
        for (int i3 = 0; i3 < 8; ++i3) {
            int r2 = TngLicence2.getBit(crc1, i3) * 8 + TngLicence2.getBit(crc1, 8 + i3) * 4 + TngLicence2.getBit(crc2, i3) * 2 + TngLicence2.getBit(crc2, 8 + i3);
            hash[i3] = (char)(65 + r2);
        }
        return new String(hash);
    }

    private static int getBit(int value, int bit) {
        return value >> bit & 1;
    }

    public static String joinKeys(String[] keys) {
        StringBuilder join = new StringBuilder();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            join.append(keys[i2]);
            if (i2 == keys.length - 1) continue;
            join.append(KEYS_DIV);
        }
        return join.toString();
    }

    public static String[] splitKeys(String keys) {
        return keys.split(KEYS_DIV);
    }
}

