/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.awt.Component;
import java.awt.Container;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.Set;
import tangram.interfaces.TngMnemonicable;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public class TngMnemonicController {
    protected static final char MNEMONIC_CHAR = '&';
    protected static final int INVALID_MNEMONIC_CHAR_INDEX = -1;
    protected static final int INVALID_MNEMONIC_CHAR = 0;

    public static void setText(TngMnemonicable mnemonicable, String text) {
        int mnemonicCharIndex = TngMnemonicController.getMnemonicCharIndex(text);
        if (mnemonicCharIndex == -1) {
            return;
        }
        int displayedMnemonic = mnemonicable.getDisplayedMnemonic();
        if (displayedMnemonic <= 0) {
            int mnemonic = TngMnemonicController.getNormalizedMnemonic(text.charAt(mnemonicCharIndex + 1));
            mnemonicable.setDisplayedMnemonic(mnemonic);
            mnemonicable.setDisplayedMnemonicIndex(mnemonicCharIndex);
        }
    }

    public static String getText(String text) {
        int mnemonicCharIndex = TngMnemonicController.getMnemonicCharIndex(text);
        if (mnemonicCharIndex == -1 || TngSwing.designMode) {
            return text;
        }
        return text.replaceFirst(String.valueOf('&'), "");
    }

    public static void mnemonicContainer(Container container) {
        HashSet<Integer> mnemonicSet = new HashSet<Integer>();
        TngMnemonicController.readContainerMnemonics(container, mnemonicSet);
        TngMnemonicController.setContainerMnemonics(container, mnemonicSet);
    }

    private static void readContainerMnemonics(Container container, Set<Integer> mnemonicSet) {
        TngMnemonicable mnemonicable;
        int displayedMnemonic;
        Component[] components = container.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component c2 = components[i2];
            if (!(c2 instanceof Container)) continue;
            TngMnemonicController.readContainerMnemonics((Container)c2, mnemonicSet);
        }
        if (container instanceof TngMnemonicable && (displayedMnemonic = (mnemonicable = (TngMnemonicable)((Object)container)).getDisplayedMnemonic()) > 0) {
            mnemonicSet.add(displayedMnemonic);
        }
    }

    private static void setContainerMnemonics(Container container, Set<Integer> mnemonicSet) {
        Component[] components = container.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component c2 = components[i2];
            if (!(c2 instanceof Container)) continue;
            TngMnemonicController.setContainerMnemonics((Container)c2, mnemonicSet);
        }
        if (container instanceof TngMnemonicable) {
            TngMnemonicController.setMnemonic((TngMnemonicable)((Object)container), mnemonicSet);
        }
    }

    private static void setMnemonic(TngMnemonicable mnemonicable, Set<Integer> mnemonicSet) {
        String textToResolve = mnemonicable.getTextToResolve();
        if (TngUtilities.isEmpty(textToResolve)) {
            return;
        }
        for (int i2 = 0; i2 < textToResolve.length(); ++i2) {
            int mnemonic = TngMnemonicController.getNormalizedMnemonic(textToResolve.charAt(i2));
            if (mnemonic == 0 || !mnemonicSet.add(mnemonic)) continue;
            mnemonicable.setDisplayedMnemonic(mnemonic);
            mnemonicable.setDisplayedMnemonicIndex(i2);
            return;
        }
    }

    private static int getMnemonicCharIndex(String text) {
        int mnemonicCharIndex;
        int index = -1;
        if (!TngUtilities.isEmpty(text) && (mnemonicCharIndex = text.indexOf(38)) >= 0 && mnemonicCharIndex < text.length() - 1) {
            index = mnemonicCharIndex;
        }
        return index;
    }

    private static int getNormalizedMnemonic(char ch) {
        String nfd = Normalizer.normalize(String.valueOf(ch), Normalizer.Form.NFD);
        if (TngUtilities.isEmpty(nfd)) {
            return 0;
        }
        int vk = nfd.charAt(0);
        if (vk >= 97 && vk <= 122) {
            vk -= 32;
        }
        if (vk < 65 || vk >= 97) {
            return 0;
        }
        return vk;
    }
}

