/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import tangram.library.TngOrder;
import tangram.swing.table.component.TngTableColumn;

public class TngOrderNamed {
    public String name;
    private String order;

    public TngOrderNamed(String name, String order) {
        this.name = name;
        this.order = TngOrder.normalize(order);
    }

    public TngOrderNamed(TngTableColumn[] columns, String order) {
        this.name = TngOrderNamed.createDescription(columns, order);
        this.order = TngOrder.normalize(order);
    }

    public static String createDescription(TngTableColumn[] columns, String order) {
        if (order == null || order.length() == 0) {
            return "";
        }
        if (columns == null) {
            return "?";
        }
        StringBuilder buff = new StringBuilder(64);
        TngOrder[] o2 = TngOrder.analyzeOrder(order);
        for (int i2 = 0; i2 < o2.length; ++i2) {
            int f2;
            if (i2 > 0) {
                buff.append(", ");
            }
            if ((f2 = TngTableColumn.findByName(columns, o2[i2].name)) < 0) {
                buff.append(o2[i2].name);
            } else {
                buff.append(columns[f2].title);
            }
            if (o2[i2].asc) continue;
            buff.append("(-)");
        }
        return buff.toString();
    }

    public String getOrder() {
        return this.order;
    }

    public boolean isOrder(String anyOrder) {
        anyOrder = TngOrder.normalize(anyOrder);
        return this.order.equals(anyOrder);
    }

    public String toString() {
        return this.name;
    }

    public static int find(TngOrderNamed[] names, String anyOrder) {
        if (names == null) {
            return -1;
        }
        anyOrder = TngOrder.normalize(anyOrder);
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (!anyOrder.equals(names[i2].getOrder())) continue;
            return i2;
        }
        return -1;
    }
}

