/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import tangram.dm.buffer.tngsys.Tngdata;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;

public class TngPasswordPolicy {
    private int minLength;
    private String specials;
    private String forbiddens;
    private boolean uppercaseChars;
    private boolean lowercaseChars;
    private boolean digitChars;
    private boolean specialChars;
    private int minCategories;
    public static final String POLICY_KEY = "PasswordPolicy";

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setSpecials(String specials) {
        this.specials = specials;
    }

    public String getSpecials() {
        return this.specials;
    }

    public void setForbiddens(String forbiddens) {
        this.forbiddens = forbiddens;
    }

    public String getForbiddens() {
        return this.forbiddens;
    }

    public void setUppercaseChars(boolean uppercaseChars) {
        this.uppercaseChars = uppercaseChars;
    }

    public boolean isUppercaseChars() {
        return this.uppercaseChars;
    }

    public void setLowercaseChars(boolean lowercaseChars) {
        this.lowercaseChars = lowercaseChars;
    }

    public boolean isLowercaseChars() {
        return this.lowercaseChars;
    }

    public void setDigitChars(boolean digitChars) {
        this.digitChars = digitChars;
    }

    public boolean isDigitChars() {
        return this.digitChars;
    }

    public void setSpecialChars(boolean specialChars) {
        this.specialChars = specialChars;
    }

    public boolean isSpecialChars() {
        return this.specialChars;
    }

    public void setMinCategories(int minCategories) {
        this.minCategories = minCategories;
    }

    public int getMinCategories() {
        return this.minCategories;
    }

    public boolean load(TngConnection conn, String policyName) throws Exception {
        Tngdata tngdata = new Tngdata();
        if (!tngdata.select(conn, " WHERE " + tngdata.key.getFullName() + "='" + POLICY_KEY + "' AND " + tngdata.loginname.getFullName() + "='" + policyName + "'")) {
            return false;
        }
        String value = (String)tngdata.value.getValue();
        if (TngUtilities.isEmpty(value)) {
            return false;
        }
        String[] tokens = TngUtilities.strTokenizeOrNull(value, '\n');
        if (tokens == null || tokens.length < 8) {
            return false;
        }
        this.setMinLength(TngUtilities.strToInt(tokens[0], 0));
        this.setSpecials(tokens[1]);
        this.setForbiddens(tokens[2]);
        this.setUppercaseChars("U".equals(tokens[3]));
        this.setLowercaseChars("L".equals(tokens[4]));
        this.setDigitChars("D".equals(tokens[5]));
        this.setSpecialChars("S".equals(tokens[6]));
        this.setMinCategories(TngUtilities.strToInt(tokens[7], 0));
        return true;
    }

    public void save(TngConnection conn, String policyName) throws Exception {
        StringBuilder value = new StringBuilder();
        value.append(this.getMinLength() + "\n");
        value.append((this.getSpecials() == null ? "" : this.getSpecials()) + "\n");
        value.append((this.getForbiddens() == null ? "" : this.getForbiddens()) + "\n");
        value.append((this.isUppercaseChars() ? "U" : "u") + "\n");
        value.append((this.isLowercaseChars() ? "L" : "l") + "\n");
        value.append((this.isDigitChars() ? "D" : "d") + "\n");
        value.append((this.isSpecialChars() ? "S" : "s") + "\n");
        value.append(this.getMinCategories());
        Tngdata tngdata = new Tngdata();
        tngdata.delete(conn, " WHERE " + tngdata.key.getFullName() + "='" + POLICY_KEY + "' AND " + tngdata.loginname.getFullName() + "='" + policyName + "'");
        tngdata.key.setValue(POLICY_KEY);
        tngdata.loginname.setValue(policyName);
        tngdata.project.setValue("*");
        tngdata.value.setValue(value.toString());
        tngdata.insert(conn);
    }
}

