/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class TngScroll {
    private static FocusListener listenerForScrolling = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e2) {
            Component focusedComponent = e2.getComponent();
            TngScroll.scrollRectToVisible(focusedComponent);
        }

        @Override
        public void focusLost(FocusEvent e2) {
        }
    };

    public static void scrollRegister(JScrollPane scrollPanel) {
        if (scrollPanel == null) {
            return;
        }
        JViewport viewport = scrollPanel.getViewport();
        TngScroll.scrollRegisterRecursive(viewport, viewport);
    }

    private static void scrollRegisterRecursive(JViewport viewport, Container container) {
        if (container == null) {
            return;
        }
        if (viewport != container) {
            container.removeFocusListener(listenerForScrolling);
            container.addFocusListener(listenerForScrolling);
        }
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            Component c2 = component[i2];
            if (c2 instanceof Container) {
                TngScroll.scrollRegisterRecursive(viewport, (Container)c2);
                continue;
            }
            c2.removeFocusListener(listenerForScrolling);
            c2.addFocusListener(listenerForScrolling);
        }
    }

    public static void scrollUnregister(JScrollPane scrollPanel) {
        if (scrollPanel == null) {
            return;
        }
        JViewport viewport = scrollPanel.getViewport();
        TngScroll.scrollUnregisterRecursive(viewport, viewport);
    }

    private static void scrollUnregisterRecursive(JViewport viewport, Container container) {
        if (container == null) {
            return;
        }
        if (viewport != container) {
            container.removeFocusListener(listenerForScrolling);
        }
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            Component c2 = component[i2];
            if (c2 instanceof Container) {
                TngScroll.scrollUnregisterRecursive(viewport, (Container)c2);
                continue;
            }
            c2.removeFocusListener(listenerForScrolling);
        }
    }

    public static boolean scrollRectToVisible(Component component) {
        Rectangle rc = new Rectangle();
        Rectangle r2 = component.getBounds();
        for (Container c2 = component.getParent(); c2 != null; c2 = c2.getParent()) {
            if (c2 instanceof JViewport) {
                JViewport vieport = (JViewport)c2;
                vieport.scrollRectToVisible(r2);
                return true;
            }
            c2.getBounds(rc);
            r2.x += rc.x;
            r2.y += rc.y;
        }
        return false;
    }
}

