/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import javax.swing.SwingUtilities;
import tangram.interfaces.TngTimerable;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngTimer
implements Runnable {
    public boolean LOGGING = false;
    private String name;
    private long period;
    private Thread thread;
    private TngTimerable handler;
    private HandlerRunnable handlerRunnable;

    public TngTimer() {
        this("Timer");
    }

    public TngTimer(String name) {
        this.name = name;
        this.period = 1000L;
        this.thread = new Thread(this);
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setHandler(TngTimerable handler) {
        this.handler = handler;
    }

    public TngTimerable getHandler() {
        return this.handler;
    }

    public synchronized void start() throws Exception {
        if (this.thread.isAlive()) {
            throw new Exception(Nat.x("Vl\u00e1kno %1 e\u0161te nebolo ukon\u010den\u00e9", this.thread.getName()));
        }
        this.thread = new Thread((Runnable)this, this.name);
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread.interrupt();
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }

    @Override
    public void run() {
        this.log(Nat.nox("spusten\u00e9 vl\u00e1kno"));
        try {
            while (true) {
                this.timerTick();
                Thread.sleep(this.period);
            }
        }
        catch (InterruptedException e2) {
        }
        catch (Throwable e3) {
            TngUtilities.exceptionLog(e3);
        }
        this.log(Nat.nox("ukon\u010den\u00e9 vl\u00e1kno"));
    }

    protected void timerTick() {
        try {
            this.log("timer tick");
            TngTimerable h2 = this.handler;
            if (h2 == null) {
                return;
            }
            if (this.handlerRunnable == null || this.handlerRunnable.handler != h2) {
                this.handlerRunnable = new HandlerRunnable(this, h2);
            }
            SwingUtilities.invokeLater(this.handlerRunnable);
        }
        catch (Throwable e2) {
            this.log(e2.toString());
        }
    }

    private void log(String text) {
        if (this.LOGGING) {
            System.out.println(this.name + ": " + text);
        }
    }

    private class HandlerRunnable
    implements Runnable {
        private TngTimer timer;
        private TngTimerable handler;

        private HandlerRunnable(TngTimer timer, TngTimerable handler) {
            this.timer = timer;
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.timerTick(this.timer);
        }
    }
}

