/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.util.Calendar;
import java.util.GregorianCalendar;
import tangram.library.TngUtilities;

public class TngUo {
    private int year;
    private int month;
    private int quartal;
    private Calendar start;
    private Calendar end;

    private TngUo() {
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getQuartal() {
        return this.quartal;
    }

    public Calendar getStart() {
        return this.start;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public boolean isQuartal() {
        return this.getQuartal() != 0;
    }

    public static TngUo fromString(String uoStr) {
        TngUo uo = new TngUo();
        if (TngUtilities.isEmpty(uoStr) || uoStr.length() != 6) {
            return null;
        }
        int year = TngUtilities.strToInt(TngUtilities.strLeft(uoStr, 4), -1);
        if (year == -1) {
            return null;
        }
        uo.year = year;
        String monthStr = TngUtilities.strSubstrOrNull(uoStr, 4, 2);
        if (TngUtilities.isEmpty(monthStr) || monthStr.length() != 2) {
            return null;
        }
        if (monthStr.charAt(0) == 'Q') {
            int quartal = TngUtilities.strToInt(TngUtilities.strSubstrOrNull(monthStr, 1, 1), -1);
            if (quartal < 1 || quartal > 4) {
                return null;
            }
            uo.quartal = quartal;
        } else {
            int month = TngUtilities.strToInt(monthStr, -1);
            if (month < 1 || month > 12) {
                return null;
            }
            uo.month = month;
        }
        int monthStart = uo.isQuartal() ? uo.quartal * 3 - 2 : uo.month;
        int monthEnd = uo.isQuartal() ? uo.quartal * 3 : uo.month;
        uo.start = new GregorianCalendar(year, monthStart - 1, 1);
        uo.end = new GregorianCalendar(year, monthEnd - 1, 1);
        uo.end.setTime(TngUtilities.dateMonthEnd(uo.end.getTime()));
        return uo;
    }
}

