/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import tangram.exception.TngExceptionAbort;
import tangram.interfaces.TngProgressable;
import tangram.library.TngUtilities;

public class TngUrlUtilities {
    public static String normalize(String path) {
        char c2;
        int cut = 0;
        int i2 = path.length() - 1;
        while (i2 >= 0 && ((c2 = path.charAt(i2)) == '/' || c2 == '\\')) {
            --i2;
            ++cut;
        }
        if (cut > 0) {
            path = TngUtilities.strCutEnd(path, cut);
        }
        return path;
    }

    public static File createTmpFile(String fileName) throws Exception {
        String tmpDir = System.getProperty("java.io.tmpdir");
        return new File(tmpDir, fileName);
    }

    public static boolean isHttp(String path) {
        return path.toLowerCase().startsWith("http:");
    }

    public static String[] getFiles(String path) throws Exception {
        if (TngUrlUtilities.isHttp(path)) {
            return TngUrlUtilities.getHttpFiles(new URL(path));
        }
        File[] files = new File(path).listFiles();
        if (files == null) {
            return new String[0];
        }
        String[] x2 = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            x2[i2] = files[i2].getAbsolutePath();
        }
        return x2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getHttpFiles(URL url) throws Exception {
        String[] stringArray;
        BufferedReader in = null;
        ArrayList<String> files = new ArrayList<String>();
        String path = url.toString();
        try {
            String h2;
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            String bMark = "<a href=\"";
            String eMark = "\">";
            while ((h2 = in.readLine()) != null) {
                int p2 = h2.toLowerCase().indexOf(bMark);
                if (p2 < 0 || (p2 = (h2 = h2.substring(p2 + bMark.length())).toLowerCase().indexOf(eMark)) < 0 || (h2 = h2.substring(0, p2 + eMark.length() - eMark.length())).length() == 0 || h2.indexOf(63) >= 0 || h2.indexOf(42) >= 0 || h2.indexOf(47) >= 0 || h2.indexOf(92) >= 0) continue;
                files.add(path + "/" + h2);
            }
            stringArray = files.toArray(new String[files.size()]);
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(in);
            throw throwable;
        }
        TngUtilities.closeSafe(in);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(URL src, File dst, TngProgressable progress) throws Exception {
        URLConnection uc = src.openConnection();
        long origLength = uc.getContentLength();
        long origLastModified = uc.getLastModified();
        if (dst.exists() && origLength == dst.length() && origLastModified == dst.lastModified()) {
            return;
        }
        progress.setProgressMax((int)origLength);
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(dst);
            in = uc.getInputStream();
            TngUrlUtilities.copyStream(in, out, progress);
            out.close();
            out = null;
            in.close();
            in = null;
            dst.setLastModified(origLastModified);
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(out);
            TngUtilities.closeSafe(in);
            throw throwable;
        }
        TngUtilities.closeSafe(out);
        TngUtilities.closeSafe(in);
    }

    public static void copyStream(InputStream in, OutputStream out, TngProgressable progress) throws Exception {
        int n2;
        byte[] buf = new byte[1024];
        while ((n2 = in.read(buf)) >= 0) {
            if (progress.isProgressCanceled()) {
                throw new TngExceptionAbort();
            }
            if (out != null) {
                out.write(buf, 0, n2);
            }
            progress.addProgressValue(n2);
        }
    }
}

