/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class TngWindowsRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int KEY_READ = 131097;
    private static final int NATIVE_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_FILE_NOT_FOUND = 2;

    public static String getKeySz(int hive, String keyName, String valueName) throws BackingStoreException {
        if (hive != -2147483647 && hive != -2147483646) {
            throw new IllegalArgumentException("Invalid hive " + hive);
        }
        Class<?> clazz = Preferences.userRoot().getClass();
        try {
            Method openKeyMethod = clazz.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            openKeyMethod.setAccessible(true);
            Method closeKeyMethod = clazz.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            closeKeyMethod.setAccessible(true);
            Method queryValueMethod = clazz.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            queryValueMethod.setAccessible(true);
            int[] result = (int[])openKeyMethod.invoke(null, hive, TngWindowsRegistry.stringToByteArray(keyName), 131097);
            if (result[1] != 0) {
                if (result[1] == 2) {
                    throw new BackingStoreException("Not Found error opening key " + keyName);
                }
                throw new BackingStoreException("Error " + result[1] + " opening key " + keyName);
            }
            int hKey = result[0];
            byte[] b2 = (byte[])queryValueMethod.invoke(null, hKey, TngWindowsRegistry.stringToByteArray(valueName));
            closeKeyMethod.invoke(null, hKey);
            if (b2 == null) {
                return null;
            }
            return TngWindowsRegistry.byteArrayToString(b2);
        }
        catch (InvocationTargetException e2) {
            throw new BackingStoreException(e2.getCause());
        }
        catch (NoSuchMethodException e3) {
            throw new BackingStoreException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new BackingStoreException(e4);
        }
    }

    private static byte[] stringToByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i2 = 0; i2 < str.length(); ++i2) {
            result[i2] = (byte)str.charAt(i2);
        }
        result[str.length()] = 0;
        return result;
    }

    private static String byteArrayToString(byte[] array) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < array.length - 1; ++i2) {
            result.append((char)array[i2]);
        }
        return result.toString();
    }
}

