/*
 * Decompiled with CFR 0.152.
 */
package tangram.library;

import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import tangram.library.TngXlsWorkbook;

public abstract class TngXlsWorkbookFiller
extends TngXlsWorkbook {
    public void export() throws Exception {
        this.fillData();
        this.autoSizeSheetsColumns();
        this.write();
    }

    protected int getColsCount() {
        return this.columns != null ? this.columns.length : 0;
    }

    protected int getHeaderRowsCount() {
        return 1;
    }

    protected abstract boolean hasRow() throws Exception;

    protected abstract void fillRow(Row var1) throws Exception;

    private void fillData() throws Exception {
        int sheetNumber = 0;
        int rowNumber = 0;
        Sheet sheet = this.createSheetWithHeader(this.workbook, ++sheetNumber);
        Row row = null;
        while (this.hasRow()) {
            if (!this.isSXSSF() && rowNumber == Short.MAX_VALUE - this.getHeaderRowsCount()) {
                sheet = this.createSheetWithHeader(this.workbook, ++sheetNumber);
                rowNumber = 0;
            }
            row = sheet.createRow(rowNumber + this.getHeaderRowsCount());
            this.fillRow(row);
            ++rowNumber;
        }
    }

    private Sheet createSheetWithHeader(Workbook workbook, int sheetNumber) throws Exception {
        Sheet sheet = workbook.createSheet("Data_" + sheetNumber);
        this.createHeaderRows(sheet);
        return sheet;
    }
}

