/*
 * Decompiled with CFR 0.152.
 */
package tangram.qrcode;

import com.bysquare.BysquareException;
import com.bysquare.Header;
import com.bysquare.base32hex.Base32hexEncoder;
import com.bysquare.checksum.CRC32Checksum;
import com.bysquare.checksum.IChecksum;
import com.bysquare.compression.ICompressor;
import com.bysquare.compression.LZMACompressor;
import com.bysquare.document.BysquareDocument;
import com.bysquare.document.invoice.Invoice;
import com.bysquare.document.pay.Pay;
import com.bysquare.sequence.SequenceDecoder;

public class TngBysquareDecoder {
    protected final Base32hexEncoder base32hexEncoder = new Base32hexEncoder();
    protected final IChecksum checksum = new CRC32Checksum();
    protected final ICompressor compressor = new LZMACompressor();

    public static Pay decodePay(String encoded) throws BysquareException {
        BysquareDocument bySquareDocument = new TngBysquareDecoder().decodeDocument(encoded);
        if (!(bySquareDocument instanceof Pay)) {
            return null;
        }
        return (Pay)bySquareDocument;
    }

    public static Invoice decodeInvoice(String encoded) throws BysquareException {
        BysquareDocument bySquareDocument = new TngBysquareDecoder().decodeDocument(encoded);
        if (!(bySquareDocument instanceof Invoice)) {
            return null;
        }
        return (Invoice)bySquareDocument;
    }

    public BysquareDocument decodeDocument(String encoded) throws BysquareException {
        if (encoded == null) {
            return null;
        }
        byte[] dataDocument = this.base32hexEncoder.decode(encoded);
        if (dataDocument.length < 2) {
            return null;
        }
        byte[] dataHeader = new byte[2];
        byte[] dataAfterCompressor = new byte[dataDocument.length - 2];
        System.arraycopy(dataDocument, 0, dataHeader, 0, dataHeader.length);
        System.arraycopy(dataDocument, 2, dataAfterCompressor, 0, dataAfterCompressor.length);
        Header localHeader = Header.find(dataHeader);
        byte[] dateBeforeCompressor = this.compressor.decompress(dataAfterCompressor);
        byte[] dataBeforeCheckSum = this.checksum.remove(dateBeforeCompressor);
        SequenceDecoder sequenceDecoder = SequenceDecoder.getInstance(localHeader.getDocumentClass());
        BysquareDocument doc = sequenceDecoder.decode(new String(dataBeforeCheckSum));
        return doc;
    }
}

