/*
 * Decompiled with CFR 0.152.
 */
package tangram.qrcode;

import com.bysquare.document.pay.BankAccount;
import com.bysquare.document.pay.BankAccounts;
import com.bysquare.document.pay.Pay;
import com.bysquare.document.pay.Payment;
import com.bysquare.document.pay.PaymentOption;
import com.bysquare.document.pay.Payments;
import java.util.ArrayList;
import tangram.exception.TngException;
import tangram.library.Nat;
import tangram.qrcode.TngBysquareParams;
import tangram.qrcode.TngBysquareUtils;
import tangram.qrcode.TngPayBysquareFactory;

public class TngPayBysquare {
    public static Pay createPay(TngBysquareParams bysquareParams) throws Exception {
        PaymentOption paymentOption;
        BankAccounts bankAccounts = new BankAccounts();
        BankAccount bankAccount = TngPayBysquareFactory.createBankAccount(bysquareParams.getString(Items.BANK_IBAN), bysquareParams.getString(Items.BANK_BIC));
        bankAccounts.add(bankAccount);
        ArrayList<PaymentOption> paymentOptions = new ArrayList<PaymentOption>();
        String paymentOptionTng = bysquareParams.getString(Items.PAYMENT_OPTION);
        PaymentOption paymentOption2 = paymentOption = "P".equalsIgnoreCase(paymentOptionTng) ? PaymentOption.paymentorder : PaymentOption.paymentorder;
        if (paymentOption != null) {
            paymentOptions.add(paymentOption);
        }
        Payments payments = new Payments();
        Payment payment = TngPayBysquareFactory.createPayment(paymentOptions, bysquareParams.getBigDecimal(Items.AMOUNT), bysquareParams.getString(Items.CURRENCY_CODE), bysquareParams.getDate(Items.PAYMENT_DUE_DATE), bysquareParams.getString(Items.VARIABLE_SYMBOL), bysquareParams.getString(Items.CONSTANT_SYMBOL), bysquareParams.getString(Items.SPECIFIC_SYMBOL), null, bysquareParams.getString(Items.PAYMENT_NOTE), bankAccounts, null, null);
        payments.add(payment);
        Pay pay = TngPayBysquareFactory.createPay(bysquareParams.getString(Items.INVOICE_ID), payments);
        return pay;
    }

    public static TngBysquareParams createBysquareParams(Pay pay) throws Exception {
        int paymentOptionsCount;
        TngBysquareParams bysquareParams = new TngBysquareParams();
        bysquareParams.setString(Items.INVOICE_ID, pay.getInvoiceID());
        int paymentsCount = pay.getPayments().size();
        if (paymentsCount == 0) {
            return bysquareParams;
        }
        if (paymentsCount > 1) {
            throw new TngException(Nat.x("Aplik\u00e1cia nepodporuje na\u010d\u00edtavanie QR k\u00f3du s viac ako jednou platbou, po\u010det platieb v QR k\u00f3de %1", paymentsCount));
        }
        Payment payment = (Payment)pay.getPayments().get(0);
        int bankAccountsCount = payment.getBankAccounts().size();
        if (bankAccountsCount != 0) {
            BankAccount bankAccount = (BankAccount)payment.getBankAccounts().get(0);
            bysquareParams.setString(Items.BANK_IBAN, bankAccount.getIBAN());
            bysquareParams.setString(Items.BANK_BIC, bankAccount.getBIC());
        }
        if ((paymentOptionsCount = payment.getPaymentOptions().size()) != 0) {
            PaymentOption paymentOption = payment.getPaymentOptions().get(0);
            bysquareParams.setString(Items.PAYMENT_OPTION, PaymentOption.paymentorder == paymentOption ? "P" : "P");
        }
        bysquareParams.setBigDecimal(Items.AMOUNT, TngBysquareUtils.doubleToDecimal(payment.getAmount()));
        bysquareParams.setString(Items.CURRENCY_CODE, payment.getCurrencyCode());
        bysquareParams.setDate(Items.PAYMENT_DUE_DATE, payment.getPaymentDueDate());
        bysquareParams.setString(Items.VARIABLE_SYMBOL, payment.getVariableSymbol());
        bysquareParams.setString(Items.CONSTANT_SYMBOL, payment.getConstantSymbol());
        bysquareParams.setString(Items.SPECIFIC_SYMBOL, payment.getSpecificSymbol());
        bysquareParams.setString(Items.PAYMENT_NOTE, payment.getPaymentNote());
        return bysquareParams;
    }

    public static enum Items {
        INVOICE_ID,
        BANK_IBAN,
        BANK_BIC,
        PAYMENT_OPTION,
        AMOUNT,
        CURRENCY_CODE,
        PAYMENT_DUE_DATE,
        VARIABLE_SYMBOL,
        CONSTANT_SYMBOL,
        SPECIFIC_SYMBOL,
        PAYMENT_NOTE;

    }
}

