/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import tangram.library.Nat;

public class TngReportBind {
    public boolean field;
    public String name;
    public int type;
    public Object value;
    public boolean changed;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_BIG_DECIMAL = 2;
    public static final int TYPE_DATE = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static SimpleDateFormat sdfYYYYMMDD = new SimpleDateFormat("yyyyMMdd");
    public static SimpleDateFormat sdfYYYYMMDDHHMMSS = new SimpleDateFormat("yyyyMMddHHmmss");

    public TngReportBind(boolean field, String name, int type) {
        this.field = field;
        this.name = name;
        this.value = null;
        this.changed = false;
        this.type = type;
    }

    public TngReportBind(boolean field, String name, String className) throws Exception {
        this.field = field;
        this.name = name;
        this.value = null;
        this.changed = false;
        if ("java.lang.String".equals(className)) {
            this.type = 0;
        } else if ("java.lang.Integer".equals(className)) {
            this.type = 1;
        } else if ("java.math.BigDecimal".equals(className)) {
            this.type = 2;
        } else if ("java.util.Date".equals(className)) {
            this.type = 3;
        } else if ("java.lang.Boolean".equals(className)) {
            this.type = 4;
        } else {
            throw new Exception(Nat.x("%1 m\u00e1 nepodporovan\u00fd d\u00e1tov\u00fd typ %2", this.getFullName(), className));
        }
    }

    public void setValueString(String data) throws Exception {
        if (this.type != 0) {
            throw new Exception(Nat.x("%1 m\u00e1 d\u00e1tov\u00fd typ in\u00fd ako STRING", this.getFullName()));
        }
        if (data != null && data.length() == 0) {
            data = null;
        }
        this.value = data;
    }

    public void setValueInteger(int data) throws Exception {
        if (this.type != 1) {
            throw new Exception(Nat.x("%1 m\u00e1 d\u00e1tov\u00fd typ in\u00fd ako INTEGER", this.getFullName()));
        }
        this.value = data;
    }

    public void setValueBigDecimal(BigDecimal data) throws Exception {
        if (this.type != 2) {
            throw new Exception(Nat.x("%1 m\u00e1 d\u00e1tov\u00fd typ in\u00fd ako BIG INTEGER", this.getFullName()));
        }
        this.value = data;
    }

    public void setValueDate(Date data) throws Exception {
        if (this.type != 3) {
            throw new Exception(Nat.x("%1 m\u00e1 d\u00e1tov\u00fd typ in\u00fd ako DATE", this.getFullName()));
        }
        this.value = data;
    }

    public void setValueBoolean(boolean data) throws Exception {
        if (this.type != 4) {
            throw new Exception(Nat.x("%1 m\u00e1 d\u00e1tov\u00fd typ in\u00fd ako BOOLEAN", this.getFullName()));
        }
        this.value = data;
    }

    public void setValue(String data) throws Exception {
        if (this.type == 0) {
            this.value = data.length() == 0 ? null : data;
        } else if (this.type == 1) {
            this.setValueInteger(data);
        } else if (this.type == 2) {
            this.setValueBigDecimal(data);
        } else if (this.type == 3) {
            this.setValueDate(data);
        } else if (this.type == 4) {
            this.setValueBoolean(data);
        } else {
            throw new Exception(Nat.x("%1 nem\u00e1 zn\u00e1my d\u00e1tov\u00fd typ", this.getFullName()));
        }
        this.changed = true;
    }

    private void setValueInteger(String data) throws Exception {
        if (data.length() == 0) {
            this.value = null;
            return;
        }
        try {
            this.value = Integer.parseInt(data);
        }
        catch (Exception e2) {
            throw new Exception(Nat.x("%1 o\u010dak\u00e1valo sa cel\u00e9 \u010d\u00edslo miesto %2", this.getFullName(), this.getDataInfo(data)));
        }
    }

    private void setValueBigDecimal(String data) throws Exception {
        if (data.length() == 0) {
            this.value = null;
            return;
        }
        try {
            this.value = new BigDecimal(data);
        }
        catch (Exception e2) {
            throw new Exception(Nat.x("%1 o\u010dak\u00e1valo sa \u010d\u00edslo miesto %2", this.getFullName(), this.getDataInfo(data)));
        }
    }

    private void setValueDate(String data) throws Exception {
        if (data.length() == 0) {
            this.value = null;
            return;
        }
        try {
            SimpleDateFormat sdf = null;
            if (data.length() == 8) {
                sdf = sdfYYYYMMDD;
            } else if (data.length() == 14) {
                sdf = sdfYYYYMMDDHHMMSS;
            } else {
                throw new Exception(Nat.x("%1 o\u010dak\u00e1val sa d\u00e1tum miesto %2", this.getFullName(), this.getDataInfo(data)));
            }
            sdf.setLenient(false);
            this.value = sdf.parse(data);
        }
        catch (Exception e2) {
            throw new Exception(Nat.x("%1 o\u010dak\u00e1val sa d\u00e1tum miesto %2", this.getFullName(), this.getDataInfo(data)));
        }
    }

    private void setValueBoolean(String data) {
        this.value = "1".equals(data);
    }

    private String getDataInfo(String data) {
        if (data.length() > 30) {
            data = data.substring(0, 30) + "...";
        }
        return "'" + data + "'";
    }

    public String getFullName() {
        if (this.field) {
            return "$F{" + this.name + "}";
        }
        return "$P{" + this.name + "}";
    }
}

