/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.io.File;
import java.io.FilenameFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import tangram.swing.TngSwing;

public class TngReportFileOld {
    private File file;
    private JasperReport jasper;

    public TngReportFileOld(File file) {
        this(file, TngReportFileOld.resolveJasper(file));
    }

    public TngReportFileOld(File file, JasperReport jasper) {
        this.file = file;
        this.jasper = jasper;
    }

    public File getFile() {
        return this.file;
    }

    public static TngReportFileOld[] getFiles(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return null;
        }
        final String lowerPrefix = prefix.toLowerCase();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).startsWith(lowerPrefix) && name.endsWith(".jasper");
            }
        };
        File[] files = new File("reports").listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        TngReportFileOld[] res = new TngReportFileOld[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            res[i2] = new TngReportFileOld(files[i2], TngReportFileOld.resolveJasper(files[i2]));
        }
        return res;
    }

    public static JasperReport resolveJasper(File file) {
        try {
            JasperReport jasReport = (JasperReport)JRLoader.loadObject(file);
            return jasReport;
        }
        catch (JRException e2) {
            TngSwing.exceptionShow(e2);
            return null;
        }
    }

    public String toString() {
        return this.jasper == null ? this.file.getAbsolutePath() : this.jasper.getName();
    }

    public boolean equals(Object o2) {
        if (o2 instanceof TngReportFileOld) {
            return ((TngReportFileOld)o2).getFileName().equals(this.getFileName());
        }
        if (o2 instanceof String) {
            return ((String)o2).equals(this.getFileName());
        }
        return false;
    }

    public String getFileName() {
        if (this.file == null) {
            return "";
        }
        return this.file.getName();
    }

    public static int getReportIndexByName(TngReportFileOld[] reportFiles, String reportFileName) {
        for (int i2 = 0; i2 < reportFiles.length; ++i2) {
            TngReportFileOld r2 = reportFiles[i2];
            if (!r2.getFileName().equals(reportFileName)) continue;
            return i2;
        }
        if (reportFiles.length == 0) {
            return -1;
        }
        return 0;
    }

    public static TngReportFileOld getReportByName(TngReportFileOld[] reportFiles, String reportFileName) {
        if (reportFiles == null || reportFiles.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < reportFiles.length; ++i2) {
            TngReportFileOld r2 = reportFiles[i2];
            if (!r2.getFileName().equals(reportFileName)) continue;
            return r2;
        }
        return reportFiles[0];
    }
}

