/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.alternative;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.alternative.field.TngReportAlternativeRow;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="alternative")
@XmlType(propOrder={"title", "rows"})
public class TngReportAlternative {
    @XmlAttribute
    private String title;
    @XmlElementWrapper
    @XmlElement(name="row")
    private List<TngReportAlternativeRow> rows;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public List<TngReportAlternativeRow> getRows() {
        if (this.rows == null) {
            this.rows = new ArrayList<TngReportAlternativeRow>();
        }
        return this.rows;
    }

    public void setRows(List<TngReportAlternativeRow> rows) {
        this.rows = rows;
    }

    public int getRowsCount() {
        return this.getRows().size();
    }

    public TngReportAlternativeRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public static TngReportAlternative load(String file) throws Exception {
        if (file == null || file.length() == 0) {
            throw new Exception(Nat.x("Nezadan\u00fd n\u00e1zov ALTER s\u00faboru"));
        }
        int p2 = (file = file.replace('/', '\\')).indexOf(".zip\\");
        if (p2 < 0) {
            return TngReportAlternative.load(new File(file));
        }
        String zip = file.substring(0, p2 += 4);
        String alter = file.substring(p2 + 1);
        return TngReportAlternative.load(zip, alter);
    }

    public static TngReportAlternative load(File file) throws Exception {
        return TngReportAlternative.load(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TngReportAlternative load(String zip, String alter) throws Exception {
        TngReportAlternative tngReportAlternative;
        File fileZip = new File(zip);
        if (!fileZip.isFile()) {
            throw new Exception(Nat.x("ZIP s\u00fabor %1 neexistuje", fileZip.getAbsolutePath()));
        }
        InputStream stream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileZip);
            ZipEntry zipEntry = zipFile.getEntry(alter);
            if (zipEntry == null) {
                throw new Exception(Nat.x("ALTER s\u00fabor %1 neexistuje v ZIP s\u00fabore %2", alter, fileZip.getAbsolutePath()));
            }
            stream = zipFile.getInputStream(zipEntry);
            tngReportAlternative = TngReportAlternative.load(stream);
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(stream);
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(stream);
        TngUtilities.closeSafe(zipFile);
        return tngReportAlternative;
    }

    public static TngReportAlternative load(InputStream stream) throws Exception {
        return TngReportAlternative.unmarshal(stream);
    }

    private static TngReportAlternative unmarshal(InputStream stream) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TngReportAlternative.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (TngReportAlternative)unmarshaller.unmarshal(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(File file) throws Exception {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            this.marshal(outputStream);
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(outputStream);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(outputStream);
    }

    public void marshal(OutputStream outputStream) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TngReportAlternative.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)this, outputStream);
    }
}

