/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.alternative;

import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.alternative.TngReportAlternative;
import tangram.report.alternative.field.TngReportAlternativeFieldAlign;
import tangram.report.alternative.field.TngReportAlternativeRow;
import tangram.report.alternative.field.TngReportAlternativeRowField;

public class TngReportAlternativeExecutor {
    private static final int FONT_HEIGHT = 11;

    public static void modifyReport(JasperDesign jasperDesign, TngReportAlternative alter) throws Exception {
        TngReportAlternativeExecutor.validateReport(jasperDesign);
        TngReportAlternativeExecutor.validateAlter(alter);
        JRBand[] details = jasperDesign.getDetailSection().getBands();
        TngReportAlternativeExecutor.addReportHeader((JRDesignBand)details[0], alter);
        TngReportAlternativeExecutor.addReportDetail((JRDesignBand)details[1], alter);
    }

    private static int calcHeaderY(TngReportAlternative alter, int rowIndex) {
        List<TngReportAlternativeRow> rows = alter.getRows();
        int height = 0;
        for (int i2 = 0; i2 < rowIndex; ++i2) {
            height += rows.get(i2).getHeaderHeight();
        }
        return height * 11;
    }

    private static int calcDetailY(TngReportAlternative alter, int rowIndex) {
        List<TngReportAlternativeRow> rows = alter.getRows();
        int height = 0;
        for (int i2 = 0; i2 < rowIndex; ++i2) {
            height += rows.get(i2).getDataHeight();
        }
        return height * 11;
    }

    private static void addReportHeader(JRDesignBand band, TngReportAlternative alter) {
        int rows = alter.getRowsCount();
        int bandHeight = TngReportAlternativeExecutor.calcHeaderY(alter, rows);
        band.setHeight(bandHeight);
        TngReportAlternativeExecutor.clearReportBand(band, "tFrameHeader", bandHeight);
        for (int i2 = 0; i2 < rows; ++i2) {
            TngReportAlternativeExecutor.addReportHeaderRow(band, alter, i2);
        }
    }

    private static void addReportDetail(JRDesignBand band, TngReportAlternative alter) {
        int rows = alter.getRowsCount();
        int bandHeight = TngReportAlternativeExecutor.calcDetailY(alter, rows);
        band.setHeight(bandHeight);
        TngReportAlternativeExecutor.clearReportBand(band, "tFrameDetail", bandHeight);
        for (int i2 = 0; i2 < rows; ++i2) {
            TngReportAlternativeExecutor.addReportDetailRow(band, alter, i2, i2 == rows - 1);
        }
    }

    private static void addReportHeaderRow(JRDesignBand band, TngReportAlternative alter, int r2) {
        int x2 = 0;
        int y = TngReportAlternativeExecutor.calcHeaderY(alter, r2);
        TngReportAlternativeRow row = alter.getRow(r2);
        List<TngReportAlternativeRowField> fields = row.getFields();
        List<JRChild> children = band.getChildren();
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            TngReportAlternativeRowField a2 = fields.get(i2);
            if (a2.getSpanWidth() == 0) continue;
            JRDesignStaticText child = new JRDesignStaticText();
            child.setX(x2);
            child.setY(y);
            child.setWidth(a2.getSpanWidth());
            child.setHeight(row.getHeaderHeight() * 11);
            child.setStyleNameReference("tColumnTitleNoLine");
            if (!TngUtilities.isEmpty(a2.getTitle())) {
                child.setText(a2.getTitle().replace("\\n", "\n"));
            }
            if (a2.getAlign() == TngReportAlternativeFieldAlign.RIGHT) {
                child.setHorizontalTextAlign(HorizontalTextAlignEnum.RIGHT);
            } else if (a2.getAlign() == TngReportAlternativeFieldAlign.CENTER) {
                child.setHorizontalTextAlign(HorizontalTextAlignEnum.CENTER);
            } else {
                child.setHorizontalTextAlign(HorizontalTextAlignEnum.LEFT);
            }
            children.add(child);
            x2 += a2.getSpanWidth();
        }
    }

    private static void addReportDetailRow(JRDesignBand band, TngReportAlternative alter, int r2, boolean isLastRow) {
        int x2 = 0;
        int y = TngReportAlternativeExecutor.calcDetailY(alter, r2);
        TngReportAlternativeRow row = alter.getRow(r2);
        List<TngReportAlternativeRowField> fields = row.getFields();
        List<JRChild> children = band.getChildren();
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            TngReportAlternativeRowField a2 = fields.get(i2);
            if (a2.getSpanWidth() == 0) continue;
            JRDesignTextField child = new JRDesignTextField();
            child.setX(x2);
            child.setY(y);
            child.setWidth(a2.getSpanWidth());
            child.setHeight(row.getDataHeight() * 11);
            if (isLastRow) {
                child.setStretchWithOverflow(true);
            }
            child.setStyleNameReference("tTextNoLine");
            String name = a2.getName();
            if (!TngUtilities.isEmpty(name)) {
                if (name.startsWith("#")) {
                    if (name.length() > 1) {
                        child.setExpression(new JRDesignExpression(name.substring(1)));
                    }
                } else {
                    child.setExpression(new JRDesignExpression("$F{" + a2.getName() + "}"));
                }
                child.setPattern(a2.getFormat());
                if (a2.getAlign() == TngReportAlternativeFieldAlign.RIGHT) {
                    child.setHorizontalTextAlign(HorizontalTextAlignEnum.RIGHT);
                } else if (a2.getAlign() == TngReportAlternativeFieldAlign.CENTER) {
                    child.setHorizontalTextAlign(HorizontalTextAlignEnum.CENTER);
                } else {
                    child.setHorizontalTextAlign(HorizontalTextAlignEnum.LEFT);
                }
            }
            children.add(child);
            x2 += a2.getSpanWidth();
        }
    }

    private static void clearReportBand(JRDesignBand band, String undeleteStyle, int bandHeight) {
        List<JRChild> children = band.getChildren();
        for (int i2 = children.size() - 1; i2 >= 0; --i2) {
            JRChild child = children.get(i2);
            if (!(child instanceof JRElement)) continue;
            JRElement e2 = (JRElement)child;
            String style = e2.getStyleNameReference();
            if (undeleteStyle != null && undeleteStyle.equals(style) && e2 instanceof JRDesignStaticText) {
                JRDesignStaticText t2 = (JRDesignStaticText)e2;
                t2.setHeight(bandHeight);
                continue;
            }
            children.remove(child);
        }
    }

    public static void validateReport(JasperDesign jasperDesign) throws Exception {
        JRSection details = jasperDesign.getDetailSection();
        if (details.getBands().length < 2) {
            throw new Exception(Nat.x("JRXML s\u00fabor nem\u00e1 band Detail 1 alebo Detail 2"));
        }
    }

    public static void validateAlter(TngReportAlternative alter) throws Exception {
        if (TngUtilities.isEmpty(alter.getTitle())) {
            throw new Exception(Nat.x("Alternat\u00edva nem\u00e1 titulok"));
        }
        int rows = alter.getRowsCount();
        if (rows == 0) {
            throw new Exception(Nat.x("Alternat\u00edva nem\u00e1 \u017eiaden riadok"));
        }
        for (int i2 = 0; i2 < rows; ++i2) {
            TngReportAlternativeExecutor.validateAlterRow(alter, i2);
        }
    }

    private static void validateAlterRow(TngReportAlternative alter, int r2) throws Exception {
        List<TngReportAlternativeRowField> fields = alter.getRow(r2).getFields();
        if (fields.size() == 0) {
            throw new Exception(Nat.x("%1. riadok alternat\u00edvy nem\u00e1 \u017eiadne pole", r2 + 1));
        }
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            TngReportAlternativeRowField a2 = fields.get(i2);
            if (TngUtilities.isEmpty(a2.getName()) || a2.getSpanWidth() >= 1) continue;
            throw new Exception(Nat.x("%1. riadok alternat\u00edvy nem\u00e1 v %2. poli \u0161\u00edrku po\u013ea", r2 + 1, i2 + 1));
        }
    }
}

