/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.variant;

import java.sql.PreparedStatement;
import java.util.List;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngParams;
import tangram.library.TngParamsAccessorSqlTngvar;
import tangram.report.variant.TngReportVariant;
import tangram.report.variant.TngReportVariantOperator;
import tangram.swing.TngSwing;

public class TngReportVariantOperatorParams
implements TngReportVariantOperator {
    public static final String KEY_PREFIX = "Report_Variant_";
    public static final String KEY_PREFIX_USER = "Report_Variant_Default_";
    private TngConnection conn;

    public TngReportVariantOperatorParams(TngConnection conn) {
        this.conn = conn;
    }

    private TngParams createParams(String prefix) {
        TngParamsAccessorSqlTngvar accessor = new TngParamsAccessorSqlTngvar();
        accessor.setConnection(this.conn);
        TngParams params = new TngParams(KEY_PREFIX + prefix);
        params.setAccessor(accessor);
        return params;
    }

    @Override
    public boolean load(String prefix, List<TngReportVariant> variants) {
        try {
            variants.clear();
            TngParams params = this.createParams(prefix);
            params.load();
            int count = params.getInt("count", 0);
            for (int i2 = 0; i2 < count; ++i2) {
                TngParams variantParams = params.getSubParams("vars/" + (i2 + 1));
                TngReportVariant variant = new TngReportVariant();
                variant.name = variantParams.getString("name");
                variant.reportFileName = variantParams.getString("report");
                variant.copies = variantParams.getInt("copies", 1);
                variant.orderBy = variantParams.getString("orderBy");
                variant.orderByReversed = variantParams.getBoolean("orderByRev", false);
                variant.groupBy = variantParams.getString("groupBy");
                variant.where = variantParams.getSubParamsAsNew("where");
                variant.note = variantParams.getString("note");
                variants.add(variant);
            }
            return true;
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed ulo\u017een\u00fdch parametrov"), e2);
            return false;
        }
    }

    @Override
    public boolean save(String prefix, List<TngReportVariant> variants) {
        if (variants == null) {
            return false;
        }
        try {
            TngParams params = this.createParams(prefix);
            for (int i2 = 0; i2 < variants.size(); ++i2) {
                TngReportVariant variant = variants.get(i2);
                TngParams variantParams = params.getSubParams("vars/" + (i2 + 1));
                variantParams.setString("name", variant.name);
                variantParams.setString("report", variant.reportFileName);
                variantParams.setInt("copies", variant.copies);
                variantParams.setString("orderBy", variant.orderBy);
                variantParams.setBoolean("orderByRev", variant.orderByReversed);
                variantParams.setString("groupBy", variant.groupBy);
                variantParams.setSubParams("where", variant.where);
                variantParams.setString("note", variant.note);
            }
            params.setInt("count", variants.size());
            params.save();
            return true;
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri ukladan\u00ed ulo\u017een\u00fdch parametrov"), e2);
            return false;
        }
    }

    @Override
    public String loadUserDefault(String prefix) {
        try {
            Object hodnota = this.conn.queryObject("SELECT hodnota FROM tngvar WHERE uzivatel=user AND kluc='" + KEY_PREFIX_USER + prefix + "'");
            return hodnota == null ? null : hodnota.toString();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed ulo\u017een\u00fdch parametrov pou\u017e\u00edvate\u013ea"), e2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserDefault(String prefix, String variantName) {
        if (variantName == null) {
            return;
        }
        PreparedStatement st = null;
        boolean rollback = false;
        try {
            this.conn.exec("DELETE tngvar WHERE uzivatel=user AND kluc='Report_Variant_Default_" + prefix + "'");
            rollback = true;
            st = this.conn.prepareStatement("INSERT INTO tngvar(kluc,hodnota,uzivatel) VALUES(?,?,user)");
            st.setString(1, KEY_PREFIX_USER + prefix);
            st.setString(2, variantName);
            st.execute();
            this.conn.commit();
            rollback = false;
            if (rollback) {
                this.conn.rollback();
            }
            this.conn.close(st);
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri ukladan\u00ed ulo\u017een\u00fdch parametrov pou\u017e\u00edvate\u013ea"), e2);
        }
        finally {
            if (rollback) {
                this.conn.rollback();
            }
            this.conn.close(st);
        }
    }
}

