/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import tangram.filter.TngFilterSet;
import tangram.library.TngParams;
import tangram.library.TngSqlOrder;
import tangram.library.TngUtilities;
import tangram.report.TngReportFile;
import tangram.report.variant.TngReportVariant;
import tangram.report.variant.TngReportVariantOperator;

public class TngReportParams {
    public String prefix;
    public TngReportVariantOperator variantOperator;
    public final TngReportVariant predefinedVariant = new TngReportVariant();
    public TngReportVariant variant;
    public TngReportFile reportFile;
    public int copies;
    public String orderBy;
    public boolean orderByReversed;
    public String groupBy;
    public TngParams where;
    public String note;
    public String whereExpression;
    public String whereDescription;
    public String orderByExpression;

    public boolean isVariantEnabled() {
        return this.variantOperator != null;
    }

    public void createWhereExpression(TngFilterSet definitionFilterSet) {
        this.whereExpression = definitionFilterSet.createFilterExpression();
    }

    public void createWhereDescription(TngFilterSet definitionFilterSet) {
        this.whereDescription = definitionFilterSet.createFilterDescription();
    }

    public void createOrderByExpression() {
        String orderByExpression = "";
        if (!TngUtilities.isEmpty(this.orderBy)) {
            if (!this.orderByReversed) {
                orderByExpression = this.orderBy;
            } else {
                TngSqlOrder[] sqlOrders;
                for (TngSqlOrder sqlOrder : sqlOrders = TngSqlOrder.analyzeOrder(this.orderBy)) {
                    sqlOrder.asc = !sqlOrder.asc;
                }
                orderByExpression = TngSqlOrder.syntetizeOrder(sqlOrders);
            }
        }
        this.orderByExpression = orderByExpression;
    }

    public String loadUserVariantName() {
        if (this.variantOperator == null) {
            return null;
        }
        String variantName = this.variantOperator.loadUserDefault(this.prefix);
        if (variantName == null || variantName.length() == 0) {
            return null;
        }
        return variantName;
    }
}

