/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import tangram.library.Nat;
import tangram.report.TngReport;
import tangram.report.TngReportPrinter;
import tangram.report.visual.TngReportComponent;
import tangram.report.visual.TngReportPanelPageJumpTo;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButtonToolbar;
import tangram.swing.container.TngScrollPane;
import tangram.swing.icon.TngIcon;
import tangram.swing.mdi.TngMdiMain;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngProgressableWorker;

public abstract class TngReportViewer
extends TngPanel {
    protected JPanel jPanelToolbar = new JPanel();
    protected TngButtonToolbar jPagePrevious = new TngButtonToolbar();
    protected TngButtonToolbar jPageNext = new TngButtonToolbar();
    protected TngButtonToolbar jPageFirst = new TngButtonToolbar();
    protected TngButtonToolbar jPageLast = new TngButtonToolbar();
    protected TngButtonToolbar jPageJumpTo = new TngButtonToolbar();
    protected TngButtonToolbar jZoomOut = new TngButtonToolbar();
    protected TngButtonToolbar jZoomIn = new TngButtonToolbar();
    protected TngButtonToolbar jFitPage = new TngButtonToolbar();
    protected TngButtonToolbar jFitWidth = new TngButtonToolbar();
    protected TngButtonToolbar jRefresh = new TngButtonToolbar();
    protected TngButtonToolbar jConfig = new TngButtonToolbar();
    protected TngButtonToolbar jPrintDefault = new TngButtonToolbar();
    protected TngButtonToolbar jPrint = new TngButtonToolbar();
    protected TngButtonToolbar jExportPdf = new TngButtonToolbar();
    protected TngButtonToolbar jExportXls = new TngButtonToolbar();
    protected TngButtonToolbar jExit = new TngButtonToolbar();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanelTop = new JPanel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private TngLabel jPosition = new TngLabel();
    private TngScrollPane jScrollPane1 = new TngScrollPane();
    protected TngReportComponent viewerComp = new TngReportComponent();
    protected TngReport report;
    private static final int SCROLL = 48;
    private final Rectangle topLeftRect = new Rectangle(0, 0);

    public TngReportViewer() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(1024, 600));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (TngReportViewer.this.viewerComp != null) {
                    TngReportViewer.this.viewerComp.componentResized();
                    TngReportViewer.this.viewerComp.refreshPage();
                }
            }
        });
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.scrollLeftRight(-1);
            }
        }, KeyStroke.getKeyStroke(37, 0), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.scrollLeftRight(1);
            }
        }, KeyStroke.getKeyStroke(39, 0), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.scrollUpDown(-1);
            }
        }, KeyStroke.getKeyStroke(38, 0), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.scrollUpDown(1);
            }
        }, KeyStroke.getKeyStroke(40, 0), 2);
        this.jPanelToolbar.setLayout(this.gridBagLayout4);
        this.jPagePrevious.setIcon(TngIcon.getIcon("report/page_previous.png"));
        this.jPagePrevious.setToolTipText(Nat.x("Predch\u00e1dzaj\u00faca str\u00e1nka") + " <Page Up>");
        this.jPagePrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperPreviousPage();
            }
        });
        this.jPagePrevious.setHitKey(33, 0);
        this.jPageNext.setIcon(TngIcon.getIcon("report/page_next.png"));
        this.jPageNext.setToolTipText(Nat.x("Nasleduj\u00faca str\u00e1nka") + " <Page Down>");
        this.jPageNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperNextPage();
            }
        });
        this.jPageNext.setHitKey(34, 0);
        this.jPageFirst.setIcon(TngIcon.getIcon("report/page_first.png"));
        this.jPageFirst.setToolTipText(Nat.x("Prv\u00e1 str\u00e1nka") + " <Home>");
        this.jPageFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperFirstPage();
            }
        });
        this.jPageFirst.setHitKey(36, 0);
        this.jPageLast.setIcon(TngIcon.getIcon("report/page_last.png"));
        this.jPageLast.setToolTipText(Nat.x("Posledn\u00e1 str\u00e1nka") + " <End>");
        this.jPageLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jsaperLastPage();
            }
        });
        this.jPageLast.setHitKey(35, 0);
        this.jPageJumpTo.setIcon(TngIcon.getIcon("report/page_jump_to.png"));
        this.jPageJumpTo.setToolTipText(Nat.x("Skok na str\u00e1nku") + " <F6>");
        this.jPageJumpTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperToPage();
            }
        });
        this.jPageJumpTo.setHitKey(117, 0);
        this.jFitPage.setIcon(TngIcon.getIcon("report/fit_page.png"));
        this.jFitPage.setToolTipText(Nat.x("Prisp\u00f4sobi\u0165 na cel\u00fa stranu") + " </>");
        this.jFitPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperFitPage();
            }
        });
        this.jFitPage.setHitKey(111, 0);
        this.jFitWidth.setIcon(TngIcon.getIcon("report/fit_width.png"));
        this.jFitWidth.setToolTipText(Nat.x("Prisp\u00f4sobi\u0165 na \u0161\u00edrku strany") + " <*>");
        this.jFitWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperFitWidth();
            }
        });
        this.jFitWidth.setHitKey(106, 0);
        this.jZoomOut.setIcon(TngIcon.getIcon("report/zoom_out.png"));
        this.jZoomOut.setToolTipText(Nat.x("Zmen\u0161i\u0165") + " <->");
        this.jZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperZoomOut();
            }
        });
        this.jZoomOut.setHitKey(109, 0);
        this.jZoomIn.setIcon(TngIcon.getIcon("report/zoom_in.png"));
        this.jZoomIn.setToolTipText(Nat.x("Zv\u00e4\u010d\u0161i\u0165") + " <+>");
        this.jZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperZoomIn();
            }
        });
        this.jZoomIn.setHitKey(107, 0);
        this.jRefresh.setIcon(TngIcon.getIcon("report/refresh.png"));
        this.jRefresh.setToolTipText(Nat.x("Obnovi\u0165 tla\u010dov\u00fa zostavu") + " <F9>");
        this.jRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.onRefresh();
            }
        });
        this.jRefresh.setHitKey(120, 0);
        this.jConfig.setIcon(TngIcon.getIcon("report/filter.png"));
        this.jConfig.setToolTipText(Nat.x("V\u00fdberov\u00e1 podmienka a \u010fal\u0161ie parametre") + " <F5>");
        this.jConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperConfig();
            }
        });
        this.jConfig.setHitKey(116, 0);
        this.jPrintDefault.setIcon(TngIcon.getIcon("report/print_default.png"));
        this.jPrintDefault.setToolTipText(Nat.x("Tla\u010d") + " <F7>");
        this.jPrintDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperPrintDefault();
            }
        });
        this.jPrintDefault.setHitKey(118, 0);
        this.jPrint.setIcon(TngIcon.getIcon("report/print.png"));
        this.jPrint.setToolTipText(Nat.x("Tla\u010d s nastaven\u00edm") + " <Ctrl+F7>");
        this.jPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperPrint();
            }
        });
        this.jPrint.setHitKey(118, 2);
        this.jExportPdf.setIcon(TngIcon.getIcon("report/export_pdf.png"));
        this.jExportPdf.setToolTipText(Nat.x("Export do PDF") + " <F10>");
        this.jExportPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperExportPdf();
            }
        });
        this.jExportPdf.setHitKey(121, 0);
        this.jExportXls.setIcon(TngIcon.getIcon("report/export_xls.png"));
        this.jExportXls.setToolTipText(Nat.x("Export do XLS") + " <F11>");
        this.jExportXls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperExportXls();
            }
        });
        this.jExportXls.setHitKey(122, 0);
        this.jExit.setIcon(TngIcon.getIcon("report/exit.png"));
        this.jExit.setToolTipText(Nat.x("Ukon\u010denie") + " <Esc>");
        this.jExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngReportViewer.this.jasperExit();
            }
        });
        this.jExit.setHitKey(27, 0);
        this.jPanelTop.setLayout(this.gridBagLayout3);
        this.jPosition.setText(Nat.nox("0/0"));
        this.jPosition.setHorizontalAlignment(2);
        this.jPanelToolbar.add((Component)this.jPagePrevious, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPageNext, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPageFirst, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPageLast, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPageJumpTo, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jZoomOut, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jZoomIn, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jFitPage, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jFitWidth, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jRefresh, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jConfig, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPrintDefault, new GridBagConstraints(11, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPrint, new GridBagConstraints(12, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jExportPdf, new GridBagConstraints(13, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jExportXls, new GridBagConstraints(14, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jExit, new GridBagConstraints(15, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanelToolbar.add((Component)this.jPosition, new GridBagConstraints(16, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanelTop.add((Component)this.jPanelToolbar, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanelTop, "North");
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanelTop.setBackground(null);
        this.jPanelTop.setPreferredSize(new Dimension(0, 36));
        this.jPanelToolbar.setBackground(null);
        this.jScrollPane1.setOpaque(false);
        this.jScrollPane1.setHorizontalScrollBarPolicy(30);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.jScrollPane1.setViewportView(this.viewerComp);
    }

    protected void onRefresh() {
    }

    protected void refreshReport() {
        this.viewerComp.loadReport(this.report.getJasperPrint(), null);
        this.jasperRefresh();
    }

    protected void setReportError(String error) {
        this.report = null;
        this.viewerComp.loadReport(null, error);
        this.jasperRefresh();
    }

    protected boolean isJasperEmpty() {
        if (this.report == null || !this.viewerComp.hasPages()) {
            TngSwing.msgWarning(Nat.x("Tla\u010dov\u00e1 zostava je pr\u00e1zdna"));
            return true;
        }
        return false;
    }

    private void scrollLeftRight(int i2) {
        int val = this.jScrollPane1.getHorizontalScrollBar().getModel().getValue();
        this.jScrollPane1.getHorizontalScrollBar().getModel().setValue(val += i2 * 48);
    }

    private void scrollUpDown(int i2) {
        int val = this.jScrollPane1.getVerticalScrollBar().getModel().getValue();
        this.jScrollPane1.getVerticalScrollBar().getModel().setValue(val += i2 * 48);
    }

    private void refreshViewer() {
        this.viewerComp.refreshPage();
    }

    private void scrollAndRefreshViewer() {
        this.resolvePaginator();
        this.jPosition.setText(this.viewerComp.getPageIndex() + 1 + "/" + this.viewerComp.getPageCount());
        this.viewerComp.scrollRectToVisible(this.topLeftRect);
        this.refreshViewer();
    }

    private void resolvePaginator() {
        this.jPagePrevious.setEnabled(!this.viewerComp.hasPages() || this.viewerComp.getPageIndex() != 0);
        this.jPageFirst.setEnabled(!this.viewerComp.hasPages() || this.viewerComp.getPageIndex() != 0);
        this.jPageNext.setEnabled(!this.viewerComp.hasPages() || this.viewerComp.getPageIndex() != this.viewerComp.getPageCount() - 1);
        this.jPageLast.setEnabled(!this.viewerComp.hasPages() || this.viewerComp.getPageIndex() != this.viewerComp.getPageCount() - 1);
        this.jPageJumpTo.setEnabled(this.viewerComp.hasPages());
    }

    private void jasperPreviousPage() {
        this.viewerComp.setPageIndex(this.viewerComp.getPageIndex() - 1);
        this.scrollAndRefreshViewer();
    }

    private void jasperNextPage() {
        this.viewerComp.setPageIndex(this.viewerComp.getPageIndex() + 1);
        this.scrollAndRefreshViewer();
    }

    private void jasperFirstPage() {
        this.viewerComp.setPageIndex(0);
        this.scrollAndRefreshViewer();
    }

    private void jsaperLastPage() {
        this.viewerComp.setPageIndex(this.viewerComp.getPageCount() - 1);
        this.scrollAndRefreshViewer();
    }

    private void jasperToPage() {
        TngReportPanelPageJumpTo p2 = new TngReportPanelPageJumpTo();
        p2.setRestriction(1, this.viewerComp.getPageCount());
        if (!TngDlg.runModal(p2)) {
            return;
        }
        int page = p2.getPage() - 1;
        if (page < 0 || page > this.viewerComp.getPageCount() - 1) {
            return;
        }
        this.viewerComp.setPageIndex(page);
        this.scrollAndRefreshViewer();
    }

    private void jasperZoomOut() {
        if (!this.canZoom()) {
            return;
        }
        this.viewerComp.addZoomRatio(-0.15f);
        this.refreshViewer();
    }

    private void jasperZoomIn() {
        if (!this.canZoom()) {
            return;
        }
        this.viewerComp.addZoomRatio(0.15f);
        this.refreshViewer();
    }

    private void jasperFitClear() {
        if (!this.canZoom()) {
            return;
        }
        this.viewerComp.setZoomRatio(1.0f);
        this.refreshViewer();
    }

    private void jasperFitPage() {
        if (!this.canZoom()) {
            return;
        }
        this.viewerComp.fitPage();
        this.refreshViewer();
    }

    private void jasperFitWidth() {
        if (!this.canZoom()) {
            return;
        }
        this.viewerComp.fitWidth();
        this.refreshViewer();
    }

    private boolean canZoom() {
        return this.viewerComp.hasPages();
    }

    private void jasperRefresh() {
        this.jScrollPane1.validate();
        if (this.viewerComp.hasPages()) {
            this.viewerComp.fitWidth();
        } else {
            this.viewerComp.fitPage();
        }
        this.scrollAndRefreshViewer();
    }

    protected boolean jasperConfig() {
        return false;
    }

    private void jasperPrintDefault() {
        if (this.isJasperEmpty()) {
            return;
        }
        this.jasperPrintInner(this.getJasperPrintCopies(), false);
    }

    protected abstract int getJasperPrintCopies();

    private void jasperPrint() {
        if (this.isJasperEmpty()) {
            return;
        }
        this.jasperPrintInner(1, true);
    }

    private void jasperPrintInner(final int copies, final boolean displayDialog) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TngReportViewer.this.jPrint.setEnabled(false);
                    TngReportViewer.this.jPrintDefault.setEnabled(false);
                    TngReportPrinter reportPrinter = new TngReportPrinter(TngReportViewer.this.report.getJasperPrint());
                    reportPrinter.setData(null, 0, 0, copies, displayDialog);
                    reportPrinter.printPages();
                }
                catch (Exception ex) {
                    TngSwing.exceptionShow(Nat.x("Chyba pri vytla\u010den\u00ed tla\u010dovej zostavy"), ex);
                }
                finally {
                    TngReportViewer.this.jPrint.setEnabled(true);
                    TngReportViewer.this.jPrintDefault.setEnabled(true);
                }
            }
        });
        thread.start();
    }

    private void jasperExportPdf() {
        if (this.isJasperEmpty()) {
            return;
        }
        try {
            final File pdfFile = File.createTempFile("reports_export", ".pdf");
            TngProgressableWorker w2 = new TngProgressableWorker(Nat.x("Prebieha export tla\u010dovej zostavy, \u010dakajte, pros\u00edm...")){

                @Override
                public void compute() throws Exception {
                    this.setProgressStatus(Nat.x("Export tla\u010dovej zostavy do PDF s\u00faboru"));
                    TngReportViewer.this.report.exportToPdf(pdfFile.getAbsolutePath(), -1, -1);
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().open(pdfFile);
                    }
                }
            };
            w2.start();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri exporte tla\u010dovej zostavy do PDF s\u00faboru"), e2);
        }
    }

    private void jasperExportXls() {
        if (this.isJasperEmpty()) {
            return;
        }
        try {
            final File xlsFile = File.createTempFile("reports_export", ".xls");
            TngProgressableWorker w2 = new TngProgressableWorker(Nat.x("Prebieha export tla\u010dovej zostavy, \u010dakajte, pros\u00edm...")){

                @Override
                public void compute() throws Exception {
                    this.setProgressStatus(Nat.x("Export tla\u010dovej zostavy do XLS s\u00faboru"));
                    TngReportViewer.this.report.exportToXls(xlsFile.getAbsolutePath());
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().open(xlsFile);
                    }
                }
            };
            w2.start();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri exporte tla\u010dovej zostavy do PDF s\u00faboru"), e2);
        }
    }

    private void jasperExit() {
        Container topLevel = this.getTopLevelAncestor();
        if (topLevel instanceof TngMdiMain) {
            ((TngMdiMain)topLevel).closeChild(((TngMdiMain)topLevel).getActiveChild());
        }
    }
}

