/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.util.List;
import java.util.Map;
import tangram.filter.TngFilterSet;
import tangram.filter.item.TngFilterItemString;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngOrderNamed;
import tangram.library.TngUtilities;
import tangram.report.TngReportBindWriter;
import tangram.report.variant.TngReportVariantOperatorParams;
import tangram.report.visual.TngReportParams;
import tangram.report.visual.TngReportViewerBind;
import tangram.swing.panel.TngProgressableWorker;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableColumnSql;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.model.TngTableModelSql;

public abstract class TngReportViewerBindCis
extends TngReportViewerBind {
    private TngTableModelSql tableModel;

    protected abstract TngConnection getConnection();

    public abstract String getTableName();

    public abstract String getTableDesc();

    private void generateTableModel() {
        if (this.tableModel != null) {
            return;
        }
        this.tableModel = new TngTableModelSql();
        this.tableModel.setConnection(this.getConnection());
        TngTableColumn[] c2 = new TngTableColumn[]{new TngTableColumnSql(Nat.x("K\u00f3d"), this.getTableName() + ".xx"), new TngTableColumnSql(Nat.x("N\u00e1zov"), this.getTableName() + ".nazov")};
        this.tableModel.setColumns(c2);
        this.tableModel.setSqlTables(this.getTableName());
        this.tableModel.setSqlFilterMain("");
        this.tableModel.setSqlOrder(this.getTableName() + ".xx");
    }

    private void closeTableModel() {
        if (this.tableModel != null) {
            this.tableModel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getData(TngProgressableWorker worker, TngReportBindWriter bindWriter) throws Exception {
        this.generateTableModel();
        try {
            this.tableModel.setSqlFilterMain(this.getReportParams().whereExpression);
            this.tableModel.setSqlOrder(this.getReportParams().orderByExpression);
            if (!this.tableModel.refreshSafe()) {
                return;
            }
            worker.setProgressMax(this.tableModel.getRowCount());
            for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
                worker.addProgressValue(1);
                TngTableRow row = this.tableModel.getRow(i2);
                bindWriter.setValueString("sValue1", String.valueOf(row.values[0]));
                bindWriter.setValueString("sValue2", String.valueOf(row.values[1]));
                bindWriter.write();
            }
        }
        finally {
            this.closeTableModel();
        }
    }

    @Override
    protected void initReportParams(TngReportParams reportParams) {
        reportParams.variantOperator = new TngReportVariantOperatorParams(this.getConnection());
        reportParams.prefix = "cis_";
    }

    @Override
    protected void initDefinitionOrderBy(List<TngOrderNamed> definitionOrderBy) {
        definitionOrderBy.add(new TngOrderNamed("A) " + Nat.x("K\u00f3d"), this.getTableName() + ".xx"));
        definitionOrderBy.add(new TngOrderNamed("B) " + Nat.x("N\u00e1zov"), this.getTableName() + ".nazov"));
    }

    @Override
    protected void initDefinitionFilterSet(TngFilterSet definitionFilterSet) {
        definitionFilterSet.setLabel(this.getTableDesc() + " - " + Nat.x("filter"));
        definitionFilterSet.add(new TngFilterItemString("XX", Nat.x("K\u00f3d"), false));
        definitionFilterSet.add(new TngFilterItemString("NAZOV", Nat.x("N\u00e1zov"), false));
    }

    @Override
    protected void extendParamsMap(Map<String, Object> paramsMap) {
        paramsMap.put("sCaption1", Nat.x("K\u00f3d"));
        paramsMap.put("sCaption2", Nat.x("N\u00e1zov"));
        paramsMap.put("gsReportTitle", this.getTableDesc());
        paramsMap.put("gsReportCommentAndFilter", TngUtilities.strExt(this.getReportParams().note, ", ", this.getReportParams().whereDescription));
    }

    @Override
    public String getDebugInfo() {
        return super.getDebugInfo() + this.tableModel.getInfo();
    }
}

