/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import tangram.interfaces.TngMnemonicable;
import tangram.interfaces.TngParamable;
import tangram.library.TngMnemonicController;
import tangram.swing.TngSwing;

public class TngCheckBox
extends JCheckBox
implements TngMnemonicable,
TngParamable {
    protected boolean enterFocusTransfer = TngSwing.enterFocusTransfer;
    private String paramName;

    public TngCheckBox() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        TngSwing.setVariantSize(this);
        this.setOpaque(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                int keyCode = e2.getKeyCode();
                if (TngCheckBox.this.enterFocusTransfer && keyCode == 10) {
                    e2.consume();
                    if (e2.isShiftDown()) {
                        TngCheckBox.this.transferFocusBackward();
                    } else {
                        TngCheckBox.this.transferFocus();
                    }
                }
            }
        });
    }

    public boolean getEnterFocusTransfer() {
        return this.enterFocusTransfer;
    }

    public void setEnterFocusTransfer(boolean enterFocusTransfer) {
        this.enterFocusTransfer = enterFocusTransfer;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setMnemonicText(text);
    }

    @Override
    public String getText() {
        return this.getMnemonicText();
    }

    @Override
    public void setMnemonicText(String text) {
        TngMnemonicController.setText(this, text);
    }

    @Override
    public String getMnemonicText() {
        return TngMnemonicController.getText(super.getText());
    }

    @Override
    public void setDisplayedMnemonic(int mnemonic) {
        this.setMnemonic(mnemonic);
    }

    @Override
    public int getDisplayedMnemonic() {
        return this.getMnemonic();
    }

    @Override
    public String getTextToResolve() {
        if (this.getDisplayedMnemonic() > 0) {
            return null;
        }
        return this.getText();
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    @Override
    public void setParamName(String paramName) {
        this.paramName = paramName;
    }
}

