/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import tangram.interfaces.TngCheckable;
import tangram.interfaces.TngMnemonicable;
import tangram.library.TngMnemonicController;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public class TngLabel
extends JLabel
implements TngMnemonicable {
    public TngLabel() {
        this("");
    }

    public TngLabel(String text) {
        this(text, 4);
    }

    public TngLabel(String text, int horizontalAlign) {
        super(text, horizontalAlign);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        TngSwing.setVariantFontSize(this);
    }

    @Override
    public void setLabelFor(Component component) {
        String toolTipText;
        super.setLabelFor(component);
        if (component instanceof TngCheckable) {
            ((TngCheckable)((Object)component)).setValueLabel(this);
        }
        if (component instanceof JComponent && !(component instanceof JLabel) && TngUtilities.isEmpty(toolTipText = ((JComponent)component).getToolTipText())) {
            ((JComponent)component).setToolTipText(this.getText());
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setMnemonicText(text);
    }

    @Override
    public String getText() {
        return this.getMnemonicText();
    }

    @Override
    public void setMnemonicText(String text) {
        TngMnemonicController.setText(this, text);
    }

    @Override
    public String getMnemonicText() {
        return TngMnemonicController.getText(super.getText());
    }

    @Override
    public String getTextToResolve() {
        if (this.getDisplayedMnemonic() != 0 || this.getLabelFor() == null) {
            return null;
        }
        return this.getText();
    }

    public void changeFontAbsolute(int style, int size) {
        Font font = TngSwing.createFontAbsolute(this.getFont(), style, size);
        this.setFont(font);
    }

    public void changeFontRelative(int style, float factor) {
        Font font = TngSwing.createFontRelative(this.getFont(), style, factor);
        this.setFont(font);
    }
}

