/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import tangram.exception.TngExceptionNovalid;
import tangram.interfaces.TngCheckable;
import tangram.interfaces.TngContextable;
import tangram.interfaces.TngParamable;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.library.TngValueController;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.container.TngContextMenu;
import tangram.swing.icon.TngIcon;
import tangram.swing.valuable.TngValueCheckEvent;
import tangram.swing.valuable.TngValueErrorShower;
import tangram.swing.valuable.TngValueEvent;
import tangram.swing.valuable.TngValueListener;
import tangram.swing.valuable.TngValueUndoManager;
import tangram.swing.valuable.TngValueWizardEvent;

public class TngFieldArea
extends JTextArea
implements TngCheckable,
TngValuable,
TngContextable,
TngParamable {
    public static Cursor cursorWizard = Cursor.getDefaultCursor();
    public static Icon iconEnabledDefault = TngIcon.getIcon("wizard.png");
    public static Icon iconDisabledDefault = TngSwing.iconToGrayscale(iconEnabledDefault);
    protected boolean editing;
    protected boolean enterFocusTransfer = TngSwing.enterFocusTransfer;
    protected boolean valueCanNull = true;
    protected int valueSize = 0;
    protected int valueMaxCols = 0;
    protected int valueMaxRows = 0;
    protected String valueName;
    protected String valueError;
    protected boolean valueWizard;
    protected String lastCheckedText = null;
    protected Cursor cursorOrig;
    protected int columnWidth;
    protected Color backgroundEditable = null;
    protected Color backgroundNotEditable = TngSwing.colorNotEditable;
    protected Color backgroundNotCanNull = TngSwing.colorNotCanNull;
    protected Icon iconEnabled = iconEnabledDefault;
    protected Icon iconDisabled = iconDisabledDefault;
    protected TngValueErrorShower showerError = new TngValueErrorShower(this);
    protected TngContextMenu popupMenu = new TngContextMenu(this);
    protected TngValueUndoManager undoManager = new TngValueUndoManager(this);
    protected TngLabel valueLabel;
    private String paramName;
    protected boolean inCheckForRecursive;
    protected boolean wizardHighlight;
    private static int[] errorMarkX = new int[]{3, 9, 3};
    private static int[] errorMarkY = new int[]{4, 4, 10};

    public TngFieldArea() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public Class<String> getValueClass() {
        return String.class;
    }

    @Override
    public Object getValue() throws Exception {
        return this.getString();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            this.setString((String)value);
        } else {
            this.setTextAndCheck(value == null ? null : value.toString());
        }
    }

    private void jbInit() throws Exception {
        TngSwing.setVariantSize(this);
        this.cursorOrig = this.getCursor();
        this.backgroundEditable = super.getBackground();
    }

    @Override
    protected void processFocusEvent(FocusEvent e2) {
        if (e2.getID() == 1004) {
            this.focusGained(e2);
        } else if (e2.getID() == 1005) {
            this.focusLost(e2);
        }
        super.processFocusEvent(e2);
    }

    public void focusGained(FocusEvent e2) {
        if (!this.editing) {
            this.editing = true;
            this.showerError.show();
        }
    }

    public void focusLost(FocusEvent e2) {
        this.showerError.hide();
        if (!e2.isTemporary()) {
            this.editing = false;
        }
        if (!this.getText().equals(this.lastCheckedText)) {
            this.check();
            if (this.valueError == null && !e2.isTemporary()) {
                this.reformat();
            }
            this.fireValueChangedUser();
        }
        if (!e2.isTemporary()) {
            this.setCaretPosition(0);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e2) {
        if (e2.getID() == 505) {
            this.wizardHighlight(false);
            super.processMouseEvent(e2);
            return;
        }
        if (this.isEnabled() && this.isEditable() && this.positionOnWizard(e2.getX(), e2.getY())) {
            if (e2.getID() == 500) {
                this.openWizard();
            }
        } else if (e2.getID() == 500 && e2.getClickCount() == 2 && e2.getButton() == 1) {
            this.openWizard();
        } else if (e2.getID() == 500 && e2.getButton() == 3) {
            this.popupMenu.show(this, e2.getX(), e2.getY());
        } else {
            super.processMouseEvent(e2);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e2) {
        if (this.isEnabled() && this.isEditable() && this.positionOnWizard(e2.getX(), e2.getY())) {
            if (e2.getID() == 503) {
                this.superSetCursor(cursorWizard);
                this.wizardHighlight(true);
            }
        } else if (this.positionOnErrorMark(e2.getX(), e2.getY())) {
            this.showerError.show();
        } else {
            this.superSetCursor(this.cursorOrig);
            this.wizardHighlight(false);
            super.processMouseMotionEvent(e2);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e2) {
        int keyCode = e2.getKeyCode();
        if (e2.getID() == 401) {
            if (keyCode == 10) {
                e2.consume();
                if (e2.isControlDown()) {
                    this.replaceSelection("\n");
                } else if (this.enterFocusTransfer) {
                    if (e2.isShiftDown()) {
                        this.transferFocusBackward();
                    } else {
                        this.transferFocus();
                    }
                }
            } else if (keyCode == 9) {
                e2.consume();
                if (e2.isShiftDown()) {
                    this.transferFocusBackward();
                } else {
                    this.transferFocus();
                }
            } else if (keyCode == 155) {
                e2.consume();
                this.openWizard();
            }
        }
        super.processKeyEvent(e2);
    }

    public boolean isEditing() {
        return this.editing;
    }

    public boolean getEnterFocusTransfer() {
        return this.enterFocusTransfer;
    }

    public void setEnterFocusTransfer(boolean enterFocusTransfer) {
        this.enterFocusTransfer = enterFocusTransfer;
    }

    public void clear() {
        this.setTextAndCheck("");
    }

    public String getString() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.getText();
    }

    public String getStringDef(String def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.getText();
    }

    public void setString(String value) {
        this.setTextAndCheck(value);
    }

    public void setStringWithCut(String value) {
        if (this.valueSize > 0 && value != null && value.length() > this.valueSize) {
            value = value.substring(0, this.valueSize);
        }
        this.setTextAndCheck(value);
    }

    @Override
    @Deprecated
    public void setText(String text) {
        this.setTextAndCheck(text);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    protected void setTextAndCheck(String text) {
        super.setText(text);
        this.check();
    }

    protected void setTextWithoutCheck(String text) {
        super.setText(text);
    }

    public boolean isEmpty() {
        return this.getText().length() == 0;
    }

    @Override
    public String getValueName() {
        return this.valueName;
    }

    @Override
    public void setValueName(String name) {
        this.valueName = name;
    }

    public boolean getValueCanNull() {
        return this.valueCanNull;
    }

    public void setValueCanNull(boolean canNull) {
        if (this.valueCanNull != canNull) {
            this.lastCheckedText = null;
            this.valueCanNull = canNull;
            this.repaint();
        }
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size is bad.");
        }
        if (this.valueSize != size) {
            this.lastCheckedText = null;
            this.valueSize = size;
            this.setColumns(size);
        }
    }

    public int getValueMaxCols() {
        return this.valueMaxCols;
    }

    public void setValueMaxCols(int rows) {
        if (rows < 0) {
            throw new IllegalArgumentException("MinRows is bad.");
        }
        if (this.valueMaxCols != rows) {
            this.lastCheckedText = null;
            this.valueMaxCols = rows;
        }
    }

    public int getValueMaxRows() {
        return this.valueMaxRows;
    }

    public void setValueMaxRows(int rows) {
        if (rows < 0) {
            throw new IllegalArgumentException("MaxRows is bad.");
        }
        if (this.valueMaxRows != rows) {
            this.lastCheckedText = null;
            this.valueMaxRows = rows;
        }
    }

    @Override
    public boolean isFocusable() {
        if (!this.isEditable()) {
            return false;
        }
        return super.isFocusable();
    }

    @Override
    @Deprecated
    public void setDragEnabled(boolean drag) {
    }

    @Override
    public Color getBackground() {
        if (!this.isEnabled()) {
            return super.getBackground();
        }
        if (!this.isEditable()) {
            return this.backgroundNotEditable;
        }
        if (!this.getValueCanNull()) {
            return this.backgroundNotCanNull;
        }
        return this.backgroundEditable;
    }

    public Color getBackgroundEditable() {
        return this.backgroundEditable;
    }

    public void setBackgroundEditable(Color color) {
        this.backgroundEditable = color;
        this.repaint();
    }

    public Color getBackgroundNotEditable() {
        return this.backgroundNotEditable;
    }

    public void setBackgroundNotEditable(Color color) {
        this.backgroundNotEditable = color;
        this.repaint();
    }

    public Color getBackgroundNotCanNull() {
        return this.backgroundNotCanNull;
    }

    public void setBackgroundNotCanNull(Color color) {
        this.backgroundNotCanNull = color;
        this.repaint();
    }

    @Override
    @Deprecated
    public void setBackground(Color background) {
        super.setBackground(background);
        this.backgroundEditable = background;
    }

    public String getValueError() {
        return this.valueError;
    }

    @Override
    public String check() {
        String text = this.getText();
        if (text.equals(this.lastCheckedText)) {
            return this.valueError;
        }
        if (this.inCheckForRecursive) {
            TngSwing.exceptionShow(new Exception(Nat.x("Rekurz\u00edvne volanie kontroly fieldu.")));
            return this.valueError;
        }
        this.inCheckForRecursive = true;
        boolean wasError = this.valueError != null;
        try {
            this.valueError = this.valueCheck(text);
            this.lastCheckedText = text;
            if (this.valueError == null) {
                this.valueError = this.fireValueCheck(text);
            }
            this.fireValueChangedEvery();
        }
        catch (Throwable e2) {
            this.valueError = e2.toString();
        }
        this.inCheckForRecursive = false;
        if (wasError != (this.valueError != null)) {
            this.repaint();
        }
        this.showerError.changeValueError(this.valueError);
        return this.valueError;
    }

    protected String valueCheck(String text) throws Exception {
        if (!this.valueCanNull && text.length() == 0) {
            return Nat.x("Polo\u017eka %1nesmie by\u0165 pr\u00e1zdna", this.getValueLabelCheckText());
        }
        if (this.valueSize > 0 && text.length() > this.valueSize) {
            return Nat.x("Text presiahol maxim\u00e1lny po\u010det znakov <%1>", this.valueSize);
        }
        if (this.valueMaxRows > 0 && this.getLineCount() > this.valueMaxRows) {
            return Nat.x("Text presiahol maxim\u00e1lny po\u010det riadkov <%1>", this.valueMaxRows);
        }
        if (this.valueMaxCols > 0) {
            for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
                int c2 = this.getLineEndOffset(i2) - this.getLineStartOffset(i2);
                if (c2 <= this.valueMaxCols) continue;
                return Nat.x("D\u013a\u017eka %1. riadka presiahla maxim\u00e1lny po\u010det znakov <%2>", i2 + 1, this.valueMaxCols);
            }
        }
        return null;
    }

    @Override
    public void setValueLabel(TngLabel label) {
        this.valueLabel = label;
    }

    @Override
    public TngLabel getValueLabel() {
        if (this.valueLabel == null) {
            TngValueController.valueLabelForComponent(this);
        }
        return this.valueLabel;
    }

    protected String getValueLabelCheckText() {
        if (this.getValueLabel() == null) {
            return "";
        }
        return "'" + this.valueLabel.getText() + "' ";
    }

    protected void reformat() {
    }

    public synchronized void addValueListener(TngValueListener l2) {
        this.listenerList.add(TngValueListener.class, l2);
    }

    public synchronized void removeValueListener(TngValueListener l2) {
        this.listenerList.remove(TngValueListener.class, l2);
    }

    public void openWizard() {
        if (!this.isWizardEnabled()) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocusInWindow();
        }
        this.fireValueWizard(this.getText());
        this.wizardHighlight(false);
    }

    protected void openWizardDef(String text) {
        try {
            Runtime.getRuntime().exec("charmap");
        }
        catch (Exception e2) {
            this.beep();
        }
    }

    protected void fireValueWizard(String text) {
        boolean consumed = false;
        try {
            Object[] listeners = this.listenerList.getListenerList();
            TngValueWizardEvent ev = new TngValueWizardEvent(this, TngValueEvent.VALUE_WIZARD_EVENT_ID, text);
            for (int i2 = listeners.length - 2; i2 >= 0 && !consumed; i2 -= 2) {
                if (listeners[i2] != TngValueListener.class) continue;
                ((TngValueListener)listeners[i2 + 1]).valueWizard(ev);
                consumed = ev.isConsumed();
            }
            if (!consumed) {
                this.openWizardDef(text);
            }
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    protected String fireValueCheck(String text) {
        String error = null;
        Object[] listeners = this.listenerList.getListenerList();
        TngValueCheckEvent ev = new TngValueCheckEvent(this, TngValueEvent.VALUE_CHECK_EVENT_ID, text);
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TngValueListener.class) continue;
            try {
                ((TngValueListener)listeners[i2 + 1]).valueCheck(ev);
                error = ev.getValueError();
                if (error == null) continue;
                break;
            }
            catch (Exception e2) {
                TngSwing.exceptionShow(e2);
            }
        }
        if (error != null && error.length() == 0) {
            error = null;
        }
        return error;
    }

    protected void fireValueChangedEvery() {
        Object[] listeners = this.listenerList.getListenerList();
        TngValueEvent ev = new TngValueEvent(this, TngValueEvent.VALUE_CHANGE_EVERY_ID);
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TngValueListener.class) continue;
            try {
                ((TngValueListener)listeners[i2 + 1]).valueChangedEvery(ev);
                continue;
            }
            catch (Exception e2) {
                TngSwing.exceptionShow(e2);
            }
        }
    }

    protected void fireValueChangedUser() {
        this.undoManager.addValueEdit();
        Object[] listeners = this.listenerList.getListenerList();
        TngValueEvent ev = new TngValueEvent(this, TngValueEvent.VALUE_CHANGE_USER_ID);
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TngValueListener.class) continue;
            try {
                ((TngValueListener)listeners[i2 + 1]).valueChangedUser(ev);
                continue;
            }
            catch (Exception e2) {
                TngSwing.exceptionShow(e2);
            }
        }
    }

    public TngValueErrorShower getValueErrorShower() {
        return this.showerError;
    }

    protected boolean isWizardEnabled() {
        return super.isFocusable() && this.isEnabled() && this.isEditable() && this.isVisible();
    }

    protected int getWizardWidth() {
        return this.valueWizard && this.iconEnabled != null ? this.iconEnabled.getIconWidth() + 2 : 0;
    }

    public boolean getValueWizard() {
        return this.valueWizard;
    }

    public void setValueWizard(boolean wizard) {
        if (this.valueWizard != wizard) {
            this.valueWizard = wizard;
            Insets o2 = this.getMargin();
            int r2 = this.getWizardWidth();
            r2 = r2 == 0 ? o2.left : r2;
            this.setMargin(new Insets(o2.top, o2.left, o2.bottom, r2));
            this.repaint();
        }
    }

    public Icon getValueWizardIcon() {
        return this.iconEnabled;
    }

    public void setValueWizardIcon(Icon icon) {
        if (icon == null) {
            this.iconEnabled = iconEnabledDefault;
            this.iconDisabled = iconDisabledDefault;
        } else {
            this.iconEnabled = icon;
            this.iconDisabled = null;
        }
        this.setValueWizard(this.valueWizard);
    }

    public Icon getValueWizardIconDisabled() {
        if (this.iconDisabled == null) {
            this.iconDisabled = TngSwing.iconToGrayscale(this.iconDisabled);
            if (this.iconDisabled == null) {
                this.iconDisabled = iconDisabledDefault;
            }
        }
        return this.iconDisabled;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.cursorOrig = cursor;
    }

    private void superSetCursor(Cursor cursor) {
        Cursor c2 = super.getCursor();
        if (c2 != cursor) {
            super.setCursor(cursor);
        }
    }

    protected String getDesignInfo() {
        String h2 = this.getValueName();
        h2 = h2 == null ? "" : h2;
        h2 = h2 + " text(" + this.valueSize + ")";
        if (this.valueMaxRows > 0) {
            h2 = h2 + " max rows " + this.valueMaxRows;
        }
        if (this.valueMaxCols > 0) {
            h2 = h2 + " max cols " + this.valueMaxCols;
        }
        return h2;
    }

    protected void wizardHighlight(boolean highlight) {
        if (this.wizardHighlight != highlight) {
            this.wizardHighlight = highlight;
            if (this.valueWizard) {
                this.repaint();
            }
        }
    }

    @Override
    public void paintChildren(Graphics g2) {
        String info;
        block7: {
            info = null;
            try {
                super.paintChildren(g2);
                Graphics2D g22 = (Graphics2D)g2;
                if (this.valueWizard) {
                    this.paintWizard(g22);
                }
                if (this.valueError != null) {
                    this.paintErrorMark(g22);
                }
                if (TngSwing.designMode) {
                    info = this.getDesignInfo();
                }
            }
            catch (Throwable e2) {
                if (!TngSwing.designMode) break block7;
                info = e2.toString();
            }
        }
        if (TngSwing.designMode && this.isEmpty()) {
            g2.setColor(TngSwing.colorDesignInfo);
            Insets m2 = this.getMargin();
            if (m2 != null) {
                g2.setClip(0, 0, this.getWidth() - m2.right, this.getHeight());
                g2.drawString(info == null ? "" : info, 4, this.getHeight() - 4);
            }
        }
    }

    protected boolean positionOnWizard(int x2, int y) {
        return x2 > this.getWidth() - this.getWizardWidth() - 3;
    }

    protected void paintWizard(Graphics2D g2) {
        Icon icon = this.isWizardEnabled() ? this.getValueWizardIcon() : this.getValueWizardIconDisabled();
        int x2 = this.getWidth() - icon.getIconWidth() - 3;
        int y = (this.getHeight() - icon.getIconHeight()) / 2;
        if (icon instanceof ImageIcon) {
            if (this.wizardHighlight && TngSwing.colorWizardHighlight != null) {
                g2.setColor(TngSwing.colorWizardHighlight);
                g2.fillRect(x2 - 1, 4, icon.getIconWidth() + 1, this.getHeight() - 7);
            }
            Image image = ((ImageIcon)icon).getImage();
            g2.drawImage(image, x2, y, null);
        }
    }

    protected boolean positionOnErrorMark(int x2, int y) {
        return x2 >= 3 && x2 <= 9 && y >= 4 && y <= 10;
    }

    protected void paintErrorMark(Graphics2D g2) {
        g2.setColor(TngSwing.colorErrorMark);
        g2.fillPolygon(errorMarkX, errorMarkY, errorMarkX.length);
    }

    @Override
    @Deprecated
    public synchronized void replaceSelection(String content) {
        content = content == null ? "" : content;
        StringBuilder text = new StringBuilder(this.getText());
        int position = this.getSelectionStart();
        if (position != this.getSelectionEnd()) {
            text.delete(position, this.getSelectionEnd());
        }
        for (int i2 = 0; i2 < content.length(); ++i2) {
            int p2 = this.inputCheck(content.charAt(i2), text, position);
            if (p2 < 0) {
                this.beep();
                break;
            }
            if (p2 > text.length()) {
                p2 = text.length();
            }
            position = p2;
        }
        this.setTextWithoutCheck(text.toString());
        this.setCaretPosition(position);
    }

    protected int inputCheck(char c2, StringBuilder text, int position) {
        text.insert(position, c2);
        return position + 1;
    }

    protected void beep() {
        System.out.println("BEEP");
    }

    protected String getTextRemoveSelected() {
        String text = this.getText();
        if (text.length() == 0) {
            return text;
        }
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        if (selStart == 0 && selEnd == text.length()) {
            return "";
        }
        if (selStart != selEnd) {
            text = text.substring(0, selStart) + text.substring(selEnd);
        }
        return text;
    }

    @Override
    public void cut() {
        if (!this.isEditable() || !this.isEnabled()) {
            return;
        }
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            this.selectAll();
        }
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        super.cut();
        if (!this.isEditing()) {
            this.check();
        }
    }

    @Override
    public void copy() {
        String text = this.getSelectedText();
        if (text == null) {
            text = this.getText();
        }
        TngUtilities.setClipboard(text);
    }

    @Override
    public void paste() {
        if (!this.isEditable() || !this.isEnabled()) {
            return;
        }
        super.paste();
        if (!this.isEditing()) {
            this.check();
        }
    }

    protected void undo() {
        if (this.canUndo()) {
            this.undoManager.undo();
            this.check();
        }
    }

    protected void redo() {
        if (this.canRedo()) {
            this.undoManager.redo();
            this.check();
        }
    }

    @Override
    public boolean isContextActionEnabled(int actionId) {
        if (actionId == 6) {
            return this.canWizard();
        }
        if (actionId == 3) {
            return this.canCut();
        }
        if (actionId == 4) {
            return this.canCopy();
        }
        if (actionId == 5) {
            return this.canPaste();
        }
        if (actionId == 1) {
            return this.canUndo();
        }
        if (actionId == 2) {
            return this.canRedo();
        }
        return true;
    }

    protected boolean canWizard() {
        return this.isEditable() && this.isEnabled();
    }

    protected boolean canCut() {
        if (!this.isEditable() || !this.isEnabled()) {
            return false;
        }
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            this.selectAll();
        }
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    protected boolean canCopy() {
        String text = this.getSelectedText();
        if (text == null) {
            text = this.getText();
        }
        return text != null && text.length() != 0;
    }

    protected boolean canPaste() {
        return this.isEditable() && this.isEnabled();
    }

    protected boolean canUndo() {
        if (!this.isEditable() || !this.isEnabled()) {
            return false;
        }
        return this.undoManager.canUndo();
    }

    protected boolean canRedo() {
        if (!this.isEditable() || !this.isEnabled()) {
            return false;
        }
        return this.undoManager.canRedo();
    }

    @Override
    public void doContextAction(int actionId) {
        if (actionId == 4) {
            this.copy();
        } else if (actionId == 3) {
            this.cut();
        } else if (actionId == 5) {
            this.paste();
        } else if (actionId == 6) {
            this.openWizard();
        } else if (actionId == 1) {
            this.undo();
        } else if (actionId == 2) {
            this.redo();
        }
    }

    @Override
    public void setColumns(int columns) {
        this.columnWidth = 0;
        super.setColumns(columns);
    }

    @Override
    public void setFont(Font f2) {
        this.columnWidth = 0;
        super.setFont(f2);
    }

    @Override
    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('W');
        }
        return this.columnWidth;
    }

    public void changeFontAbsolute(int style, int size) {
        Font font = TngSwing.createFontAbsolute(this.getFont(), style, size);
        this.setFont(font);
    }

    public void changeFontRelative(int style, float factor) {
        Font font = TngSwing.createFontRelative(this.getFont(), style, factor);
        this.setFont(font);
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    @Override
    public void setParamName(String paramName) {
        this.paramName = paramName;
    }
}

