/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import tangram.exception.TngExceptionNovalid;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.swing.TngSwing;
import tangram.swing.component.TngFileChooser;
import tangram.swing.component.field.TngField;

public abstract class TngFieldFile
extends TngField
implements TngValuable {
    private TngFileChooser fileChooser;
    protected File valueFile;
    protected File defaultDirectory = new File("");

    public TngFieldFile() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setValueWizard(true);
    }

    public Class<File> getValueClass() {
        return File.class;
    }

    @Override
    public Object getValue() throws Exception {
        return this.getFile();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof File) {
            this.setFile((File)value);
        } else {
            this.setTextAndCheck(value == null ? null : value.toString());
        }
    }

    public File getFile() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.valueFile;
    }

    public File getFileDef(File def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.valueFile;
    }

    public void setFile(File value) {
        this.setTextAndCheck(value == null ? null : value.getAbsolutePath());
    }

    protected TngFileChooser createFileChooser() {
        TngFileChooser fileChooser = new TngFileChooser();
        fileChooser.setDialogTitle(Nat.x("Umiestnenie s\u00faboru"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileSelectionMode(0);
        return fileChooser;
    }

    public TngFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = this.createFileChooser();
        }
        return this.fileChooser;
    }

    public void setDefaultDirectory(File defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
    }

    public File getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void fileFilterSet(FileFilter filter) {
        this.fileFilterReset();
        this.getFileChooser().setFileFilter(filter);
    }

    public void fileFilterReset() {
        this.getFileChooser().resetFileFilter();
    }

    public void fileFilterAddExtension(String description, String ... extensions) {
        this.getFileChooser().addFileFilterExtension(description, extensions);
    }

    public boolean fileFilterExtensionCheck(File file) {
        return this.getFileChooser().isFileExtensionAllowed(file);
    }

    public String fileFilterExtensionToString() {
        return this.getFileChooser().getFileFilterToString();
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " file";
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        this.valueFile = null;
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        this.valueFile = new File(this.getTextTrimed());
        return null;
    }

    protected void fileChooserSet() {
        File actualFile = this.getFileDef(null);
        if (actualFile == null) {
            this.getFileChooser().setCurrentDirectory(this.defaultDirectory);
        } else {
            this.getFileChooser().setSelectedFile(actualFile);
        }
    }
}

