/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngFieldDirectory;
import tangram.swing.component.field.TngFieldFile;
import tangram.swing.valuable.TngValueAdapter;
import tangram.swing.valuable.TngValueEvent;

public class TngFieldFileSave
extends TngFieldFile {
    private TngFieldDirectory fieldDirectory;

    public TngFieldFileSave() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
    }

    public void setFieldDirectory(final TngFieldDirectory fieldDirectory) {
        this.fieldDirectory = fieldDirectory;
        this.addValueListener(new TngValueAdapter(){

            @Override
            public void valueChangedEvery(TngValueEvent e2) {
                File dir;
                File file = new File(TngFieldFileSave.this.getTextTrimed());
                File file2 = dir = file.isDirectory() ? file : file.getParentFile();
                if (dir != null) {
                    fieldDirectory.setFile(dir);
                    TngFieldFileSave.this.setFileNameOnly(file);
                }
            }
        });
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " <save>";
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (this.valueFile.exists() && !this.valueFile.isFile()) {
            return Nat.x("Zadan\u00e1 cesta neukazuje na s\u00fabor, ale na adres\u00e1r");
        }
        if (!this.isEmpty() && !this.fileFilterExtensionCheck(this.valueFile)) {
            return Nat.x("S\u00fabor nie je po\u017eadovan\u00e9ho typu <%1>", this.fileFilterExtensionToString());
        }
        return null;
    }

    @Override
    protected void openWizardDef(String text) {
        this.selectFile();
    }

    @Override
    protected void fileChooserSet() {
        File dir;
        File file = dir = this.fieldDirectory == null ? null : new File(this.fieldDirectory.getTextTrimed());
        if (dir == null || !dir.isDirectory()) {
            super.fileChooserSet();
        } else {
            this.getFileChooser().setCurrentDirectory(dir);
            this.getFileChooser().setSelectedFile(this.getFileDef(null));
        }
    }

    protected void selectFile() {
        this.fileChooserSet();
        if (this.getFileChooser().showDialog(this, Nat.x("Ulo\u017ei\u0165")) == 0) {
            File selectedFile = this.getFileChooser().getSelectedFile();
            String selectedFileName = selectedFile.getName();
            String suffixAdd = null;
            FileFilter fileFilter = this.getFileChooser().getFileFilter();
            if (fileFilter instanceof FileNameExtensionFilter) {
                String[] exts = ((FileNameExtensionFilter)fileFilter).getExtensions();
                int extsCount = exts == null || exts.length == 0 ? 0 : exts.length;
                for (int i2 = 0; i2 < extsCount; ++i2) {
                    String ext = exts[i2];
                    suffixAdd = selectedFileName.toUpperCase().endsWith(ext.toUpperCase()) ? null : ext;
                }
            }
            if (!TngUtilities.isEmpty(suffixAdd)) {
                selectedFile = new File(selectedFile.getAbsolutePath() + "." + suffixAdd);
            }
            this.setFile(selectedFile);
            this.fireValueChangedUser();
        }
    }

    public void setFileNameOnly(File file) {
        this.setTextWithoutCheck(file == null ? null : file.getName());
    }
}

