/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import tangram.exception.TngExceptionNovalid;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngField;

public class TngFieldTime
extends TngField
implements TngValuable {
    protected Integer valueTime;
    protected boolean valueCanZero = true;
    protected int valueMin = 0;
    protected int valueMax = 1439;
    protected int valueSize;
    protected int restrictionMin;
    protected int restrictionMax;

    public TngFieldTime() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setHorizontalAlignment(2);
        this.calcRestrictionMax();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                boolean consumed = true;
                switch (e2.getKeyCode()) {
                    case 38: {
                        TngFieldTime.this.changeTime(1);
                        break;
                    }
                    case 40: {
                        TngFieldTime.this.changeTime(-1);
                        break;
                    }
                    case 33: {
                        TngFieldTime.this.changeTime(60);
                        break;
                    }
                    case 34: {
                        TngFieldTime.this.changeTime(-60);
                        break;
                    }
                    default: {
                        consumed = false;
                    }
                }
                if (consumed) {
                    e2.consume();
                }
            }
        });
    }

    private void changeTime(int amount) {
        int minutes = TngUtilities.strToMinuty(this.getText());
        if ((minutes += amount) < this.getValueMin()) {
            minutes = this.getValueMin();
        } else if (minutes > this.getValueMax()) {
            minutes = this.getValueMax();
        }
        this.setTime(minutes);
        this.setCaretPosition(0);
    }

    public Class getValueClass() {
        return Integer.class;
    }

    @Override
    public Object getValue() throws Exception {
        return this.getTime();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Integer) {
            this.setTime((Integer)value);
        } else {
            this.setTextAndCheck(value == null ? null : value.toString());
        }
    }

    public Integer getTime() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.valueTime;
    }

    public Integer getTimeDef(int def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.valueTime;
    }

    public void setTime(Integer value) {
        this.setTextAndCheck(value == null ? null : TngUtilities.minutyToStr(value));
    }

    public void setValueCanZero(boolean canZero) {
        if (this.valueCanZero != canZero) {
            this.valueCanZero = canZero;
            this.lastCheckedText = null;
        }
    }

    public boolean getValueCanZero() {
        return this.valueCanZero;
    }

    public void setValueMin(int min) {
        if (min >= 0 && this.valueMin != min) {
            this.valueMin = min;
            this.calcRestrictionMax();
        }
    }

    public int getValueMin() {
        return this.valueMin;
    }

    public void setValueMax(int max) {
        if (this.valueMax != max) {
            this.valueSize = 0;
            this.valueMax = max;
            this.calcRestrictionMax();
        }
    }

    public int getValueMax() {
        return this.valueMax;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size is bad.");
        }
        if (this.valueSize != size) {
            this.valueMax = Integer.MAX_VALUE;
            this.valueSize = size;
            this.calcRestrictionMax();
        }
    }

    protected void calcRestrictionMax() {
        int newMax;
        int sizeMax = TngFieldTime.calcMaxValueForSize(this.valueSize);
        int newMin = this.valueMin;
        int n2 = newMax = this.valueMax < sizeMax ? this.valueMax : sizeMax;
        if (this.restrictionMax != newMax || this.restrictionMin != newMin) {
            this.restrictionMax = newMax;
            this.restrictionMin = newMin;
            this.lastCheckedText = null;
            this.setColumns(this.calcColumnsMax());
        }
    }

    protected int calcColumnsMax() {
        String maxTimeStr = TngUtilities.minutyToStr(this.restrictionMax);
        int maxTimeStrLength = TngUtilities.isEmpty(maxTimeStr) ? 0 : maxTimeStr.length();
        return Math.max(maxTimeStrLength, 5);
    }

    public static final int calcMaxValueForSize(int size) {
        if (size <= 0) {
            return Integer.MAX_VALUE;
        }
        int v2 = Integer.MAX_VALUE;
        if (size > 0 && size < 10) {
            v2 = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                v2 = v2 * 10 + 9;
            }
        }
        return v2;
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " time(" + this.valueSize + ")";
        h2 = this.restrictionMin > this.restrictionMax ? h2 + " <EMPTY>" : h2 + " <" + TngUtilities.minutyToStr(this.restrictionMin) + "," + TngUtilities.minutyToStr(this.restrictionMax) + ">";
        if (!this.valueCanZero) {
            h2 = h2 + " except 00:00";
        }
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        this.valueTime = null;
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (text.length() == 0) {
            return null;
        }
        int v2 = TngUtilities.strToMinuty(text);
        if (v2 < this.restrictionMin) {
            return Nat.x("Hodnota je men\u0161ia ako %1", TngUtilities.minutyToStr(this.restrictionMin));
        }
        if (v2 > this.restrictionMax) {
            return Nat.x("Hodnota je v\u00e4\u010d\u0161ia ako %1", TngUtilities.minutyToStr(this.restrictionMax));
        }
        if (!this.valueCanZero && v2 == 0) {
            return Nat.x("Hodnota nesmie by\u0165 00:00");
        }
        this.valueTime = new Integer(v2);
        return null;
    }

    @Override
    protected int inputCheck(char c2, StringBuilder text, int position) {
        if (text.length() >= this.calcColumnsMax()) {
            return -1;
        }
        if (c2 == ':') {
            if (TngUtilities.countOccurrences(text.toString(), ':') >= 1) {
                return -1;
            }
            text.insert(position, c2);
            return position + 1;
        }
        if (c2 < '0' || c2 > '9') {
            return -1;
        }
        text.insert(position, c2);
        return position + 1;
    }

    @Override
    @Deprecated
    public synchronized void replaceSelection(String content) {
        super.replaceSelection(content);
        int textLength = this.getText().length();
        int columnsMaxLength = this.calcColumnsMax();
        if (textLength == columnsMaxLength - 3 && !this.getText().contains(":") || textLength == columnsMaxLength - 2 && content.equals(":")) {
            this.completeMinutes(textLength == columnsMaxLength - 3);
        }
    }

    private void completeMinutes(boolean appendDot) {
        int columnsMaxLength = this.calcColumnsMax();
        String minutes = "00";
        this.setTextWithoutCheck(this.getText() + (appendDot ? ":" : "") + minutes);
        this.select(columnsMaxLength - 2, this.getText().length());
    }

    @Override
    protected void reformat() {
        if (this.valueTime != null) {
            this.setTextWithoutCheck(TngUtilities.strPadRight(TngUtilities.minutyToStr(this.valueTime), this.calcColumnsMax(), '0'));
        }
    }

    @Override
    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('8') + 1;
        }
        return this.columnWidth;
    }
}

