/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.icon;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class TngImageFilterMonochrome
extends RGBImageFilter {
    private int baseRed;
    private int baseGreen;
    private int baseBlue;

    public TngImageFilterMonochrome(Color base) {
        this.baseRed = base.getRed();
        this.baseGreen = base.getGreen();
        this.baseBlue = base.getBlue();
    }

    @Override
    public final int filterRGB(int x2, int y, int rgb) {
        int b2 = rgb & 0xFF;
        int g2 = rgb >> 8 & 0xFF;
        int r2 = rgb >> 16 & 0xFF;
        float factor = (0.5f * (float)r2 + 0.3f * (float)g2 + 0.2f * (float)b2) / 255.0f;
        r2 = this.baseRed + (int)((float)(255 - this.baseRed) * factor);
        g2 = this.baseGreen + (int)((float)(255 - this.baseGreen) * factor);
        b2 = this.baseBlue + (int)((float)(255 - this.baseBlue) * factor);
        return (rgb & 0xFF000000) + (r2 << 16) + (g2 << 8) + b2;
    }
}

