/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.mdi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.visual.TngReportViewerBase;
import tangram.swing.TngSwing;
import tangram.swing.container.TngCheckBoxMenuItem;
import tangram.swing.container.TngMenu;
import tangram.swing.container.TngMenuBar;
import tangram.swing.container.TngMenuItem;
import tangram.swing.icon.TngIcon;
import tangram.swing.mdi.TngMdiChild;
import tangram.swing.mdi.TngOptionPanel;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanelMdiChildActivation;
import tangram.swing.panel.TngPanelWindowsSetting;
import tangram.swing.table.component.TngTablePanel;

public class TngMdiMain
extends JFrame {
    public static final int CHILD_CASCADE_OFFSET_X = 20;
    public static final int CHILD_CASCADE_OFFSET_Y = 28;
    public static final int ARRANGE_MODE_MAXIMIZED = 0;
    public static final int ARRANGE_MODE_HORIZONTAL = 1;
    public static final int ARRANGE_MODE_VERTICAL = 2;
    public static final int ARRANGE_MODE_GRID = 3;
    public static final int ARRANGE_MODE_CASCADE = 4;
    public static final int ARRANGE_MODE_CHAOS = 5;
    private int arrangeMode = -1;
    private Vector<JInternalFrame> children = new Vector();
    private boolean showExitAsk;
    private JDesktopPane desktop = new JDesktopPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private TngMenuBar menuMdi = new TngMenuBar();
    protected TngMenu menuWindows = new TngMenu();
    private TngMenuItem menuWindowsCloseAll = new TngMenuItem();
    private TngCheckBoxMenuItem menuWindowsMaximized = new TngCheckBoxMenuItem();
    private TngCheckBoxMenuItem menuWindowsVertical = new TngCheckBoxMenuItem();
    private TngCheckBoxMenuItem menuWindowsHorizontal = new TngCheckBoxMenuItem();
    private TngCheckBoxMenuItem menuWindowsGrid = new TngCheckBoxMenuItem();
    private TngCheckBoxMenuItem menuWindowsCascade = new TngCheckBoxMenuItem();
    private TngCheckBoxMenuItem menuWindowsChaos = new TngCheckBoxMenuItem();
    private TngMenuItem menuWindowsClose = new TngMenuItem();
    private TngMenuItem menuWindowsClone = new TngMenuItem();
    private TngMenuItem menuWindowsOptions = new TngMenuItem();
    protected TngMenu menuReports = new TngMenu();
    protected JPanel toolbarPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TabWindow tabWindows = new TabWindow();
    private InternalFrameAdapter childListener = new InternalFrameAdapter(){

        @Override
        public void internalFrameActivated(InternalFrameEvent e2) {
            TngMdiMain.this.tabWindows.setSelectedOption(TngMdiMain.this.getActiveChild());
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e2) {
            Object source = e2.getSource();
            if (source instanceof TngMdiChild) {
                TngMdiChild child = (TngMdiChild)source;
                child.close();
            } else if (source instanceof JInternalFrame) {
                TngMdiMain.this.closeChild((JInternalFrame)source);
            }
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e2) {
            TngMdiMain.this.removedChild();
        }
    };
    protected ActionListener menuWindowsActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                int a2 = Integer.parseInt(e2.getActionCommand());
                if (a2 >= 0 || a2 <= TngMdiMain.this.children.size()) {
                    TngMdiMain.this.setActiveChild((JInternalFrame)TngMdiMain.this.children.get(a2));
                }
            }
            catch (Exception er) {
                TngSwing.exceptionShow(er);
            }
        }
    };

    public TngMdiMain() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        ImageIcon tangramIcon = TngIcon.getIconNoCached("tangram16.gif");
        if (tangramIcon != null) {
            this.setIconImage(tangramIcon.getImage());
        }
        this.desktop.setDragMode(1);
        this.desktop.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                TngMdiMain.this.desktop_componentResized(e2);
            }
        });
        this.menuWindows.setText(Nat.x("&Okn\u00e1"));
        this.menuWindows.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e2) {
                TngMdiMain.this.menuWindows_menuSelected(e2);
            }

            @Override
            public void menuDeselected(MenuEvent e2) {
            }

            @Override
            public void menuCanceled(MenuEvent e2) {
            }
        });
        this.menuWindowsMaximized.setText(Nat.x("Ma&ximalizovan\u00e9"));
        this.menuWindowsMaximized.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsMaximized_actionPerformed(e2);
            }
        });
        this.menuWindowsVertical.setText(Nat.x("Aran\u017eova\u0165 do &st\u013apcov"));
        this.menuWindowsVertical.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsVertical_actionPerformed(e2);
            }
        });
        this.menuWindowsHorizontal.setText(Nat.x("Aran\u017eova\u0165 do &riadkov"));
        this.menuWindowsHorizontal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsHorizontal_actionPerformed(e2);
            }
        });
        this.menuWindowsGrid.setText(Nat.x("Aran\u017eova\u0165 do &mrie\u017eky"));
        this.menuWindowsGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsGrid_actionPerformed(e2);
            }
        });
        this.menuWindowsCloseAll.setText(Nat.x("&Zavrie\u0165 v\u0161etky okn\u00e1"));
        this.menuWindowsCloseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsCloseAll_actionPerformed(e2);
            }
        });
        this.menuWindowsCascade.setText(Nat.x("Aran\u017eova\u0165 do &kask\u00e1dy"));
        this.menuWindowsCascade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsCascade_actionPerformed(e2);
            }
        });
        this.menuWindowsChaos.setText(Nat.x("&Nearan\u017eova\u0165"));
        this.menuWindowsChaos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsChaos_actionPerformed(e2);
            }
        });
        this.menuWindowsClose.setText(Nat.x("Zavrie\u0165 &akt\u00edvne okno"));
        this.menuWindowsClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsClose_actionPerformed(e2);
            }
        });
        this.menuWindowsClone.setText(Nat.x("K&lonova\u0165 akt\u00edvne okno"));
        this.menuWindowsClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsClone_actionPerformed(e2);
            }
        });
        this.menuWindowsOptions.setText(Nat.x("Mo\u017enos&ti..."));
        this.menuWindowsOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngMdiMain.this.menuWindowsOptions_actionPerformed(e2);
            }
        });
        this.menuReports.setText(Nat.x("&Tla\u010d"));
        this.getContentPane().setLayout(this.borderLayout1);
        this.setExtendedState(6);
        this.setSize(800, 600);
        this.add((Component)this.desktop, "Center");
        this.menuMdi.add(this.menuReports);
        this.menuWindows.add(this.menuWindowsChaos);
        this.menuWindows.add(this.menuWindowsMaximized);
        this.menuWindows.add(this.menuWindowsVertical);
        this.menuWindows.add(this.menuWindowsHorizontal);
        this.menuWindows.add(this.menuWindowsGrid);
        this.menuWindows.add(this.menuWindowsCascade);
        this.menuWindows.addSeparator();
        this.menuWindows.add(this.menuWindowsCloseAll);
        this.menuWindows.add(this.menuWindowsClose);
        this.menuWindows.add(this.menuWindowsClone);
        this.menuWindows.add(this.menuWindowsOptions);
        this.menuMdi.add(this.menuWindows);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                TngMdiMain.this.this_windowClosing(e2);
            }
        });
        this.toolbarPanel.setLayout(this.gridBagLayout1);
        this.toolbarPanel.add((Component)this.tabWindows, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toolbarPanel, "North");
        this.setArrangeMode(0);
        this.tabWindows.setMaxButtonWidth(200);
    }

    public boolean canClose() {
        if (!this.canCloseChildren()) {
            return false;
        }
        if (!this.getShowExitAsk()) {
            return true;
        }
        return TngSwing.msgAsk(Nat.x("Naozaj si \u017eel\u00e1te ukon\u010di\u0165 program?"));
    }

    public boolean canCloseChildren() {
        JInternalFrame[] child = this.getChildren();
        for (int i2 = child.length - 1; i2 >= 0; --i2) {
            if (!(child[i2] instanceof TngMdiChild) || ((TngMdiChild)child[i2]).canClose()) continue;
            return false;
        }
        return true;
    }

    public boolean close() {
        if (!this.canClose()) {
            return false;
        }
        this.closeAllChildren();
        this.dispose();
        return true;
    }

    public void exit() {
        if (this.close()) {
            System.exit(0);
        }
    }

    public JInternalFrame[] getChildren() {
        JInternalFrame[] child = new JInternalFrame[this.children.size()];
        for (int i2 = 0; i2 < child.length; ++i2) {
            child[i2] = this.children.get(i2);
        }
        return child;
    }

    public void closeAllChildren() {
        JInternalFrame[] child = this.getChildren();
        for (int i2 = child.length - 1; i2 >= 0; --i2) {
            this.closeChild(child[i2]);
        }
    }

    public void closeChild(JInternalFrame child) {
        if (child == null) {
            return;
        }
        try {
            child.dispose();
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    public JInternalFrame getActiveChild() {
        if (this.desktop.getComponentCount() < 1) {
            return null;
        }
        Component c2 = this.desktop.getComponent(0);
        if (c2 instanceof JInternalFrame) {
            return (JInternalFrame)c2;
        }
        return null;
    }

    public boolean setActiveChild(String name) {
        JInternalFrame child = this.findChild(name);
        if (child == null) {
            return false;
        }
        TngPanelMdiChildActivation p2 = new TngPanelMdiChildActivation();
        p2.setData(name);
        if (!TngDlg.runModal(p2, 7)) {
            return true;
        }
        if (p2.isActivationSet()) {
            return this.setActiveChild(child);
        }
        return false;
    }

    public boolean setActiveChild(JInternalFrame child) {
        if (child == null) {
            return false;
        }
        try {
            child.setSelected(true);
            this.revisibleChild(child);
            return true;
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
            return false;
        }
    }

    protected void revisibleChild(JInternalFrame child) {
        if (child == null) {
            return;
        }
        if (child.isMaximum()) {
            return;
        }
        Rectangle r2 = child.getBounds();
        Dimension d2 = this.desktop.getSize();
        if (r2.width > d2.width) {
            r2.x = 0;
            r2.width = d2.width - 10;
        } else if (r2.x < 0) {
            r2.x = 0;
        } else if (r2.x + r2.width > d2.width) {
            r2.x = d2.width - r2.width;
        }
        if (r2.height > d2.height) {
            r2.y = 0;
            r2.height = d2.height - 10;
        } else if (r2.y < 0) {
            r2.y = 0;
        } else if (r2.y + r2.height > d2.height) {
            r2.y = d2.height - r2.height;
        }
        if (!r2.equals(child.getBounds())) {
            this.reshapeChild(child, r2);
        }
    }

    public void setArrangeMode(int mode) {
        try {
            this.arrangeMode = mode;
            this.menuWindowsChaos.setState(mode == 5);
            this.menuWindowsMaximized.setState(mode == 0);
            this.menuWindowsVertical.setState(mode == 2);
            this.menuWindowsHorizontal.setState(mode == 1);
            this.menuWindowsGrid.setState(mode == 3);
            this.menuWindowsCascade.setState(mode == 4);
            if (this.arrangeMode == 0 && this.getActiveChild() != null) {
                this.getActiveChild().setMaximum(true);
            }
            this.arrange();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public int getArrangeMode() {
        return this.arrangeMode;
    }

    public JInternalFrame findChild(String name) {
        if (name == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (!name.equals(this.children.get(i2).getName())) continue;
            return this.children.get(i2);
        }
        return null;
    }

    public int getCloneMax(String name) {
        if (name == null) {
            return 0;
        }
        int clone = 0;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            TngMdiChild child;
            if (!(this.children.get(i2) instanceof TngMdiChild) || !name.equals((child = (TngMdiChild)this.children.get(i2)).getName()) || child.getCloneId() <= clone) continue;
            clone = child.getCloneId();
        }
        return clone;
    }

    public TngMdiChild cloneChild(JInternalFrame child) {
        if (child == null) {
            return null;
        }
        if (!(child instanceof TngMdiChild)) {
            return null;
        }
        try {
            TngMdiChild orig = (TngMdiChild)child;
            TngMdiChild clone = orig.createClone();
            if (clone == null) {
                return null;
            }
            int clones = this.getCloneMax(child.getName()) + 1;
            clone.setCloneId(clones);
            clone.setTitle(clone.getTitle() + " [" + clones + "]");
            this.addChild(clone);
            return clone;
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
            TngSwing.msgError(Nat.x("Zvolen\u00e9 okno nie je mo\u017en\u00e9 klonova\u0165"));
            return null;
        }
    }

    public void addChild(JInternalFrame child) {
        if (child == null) {
            return;
        }
        try {
            child.setMaximizable(true);
            child.setIconifiable(false);
            child.setClosable(true);
            child.setResizable(true);
            child.setDefaultCloseOperation(0);
            Rectangle r2 = this.calcCascadeRect(this.getActiveChild());
            child.setLocation(r2.x, r2.y);
            child.setSize(r2.width, r2.height);
            child.addInternalFrameListener(this.childListener);
            this.children.add(child);
            this.tabWindows.addOption(child.getTitle(), child);
            this.desktop.add(child);
            child.setVisible(true);
            if (this.arrangeMode == 0) {
                child.setMaximum(true);
            }
            this.arrange();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public void addChildTable(final TngTablePanel tablePanel) {
        String tablePanelTitle = tablePanel.getTitle();
        if (this.setActiveChild(tablePanelTitle)) {
            return;
        }
        TngMdiChild child = new TngMdiChild();
        child.getContentPane().add((Component)tablePanel, "Center");
        child.setTitle(tablePanelTitle);
        child.setName(tablePanelTitle);
        this.addChild(child);
        tablePanel.explode();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tablePanel.tableRefresh();
            }
        });
    }

    public void addChildReport(TngReportViewerBase reportPanel) {
        String reportPanelTitle = reportPanel.getTitle();
        if (this.setActiveChild(reportPanelTitle)) {
            return;
        }
        TngMdiChild child = new TngMdiChild();
        child.getContentPane().add((Component)reportPanel, "Center");
        child.setTitle(reportPanelTitle);
        child.setName(reportPanelTitle);
        this.addChild(child);
        if (!reportPanel.init()) {
            this.closeChild(child);
        }
    }

    protected void removedChild() {
        try {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                JInternalFrame child = this.children.get(i2);
                if (!child.isClosed()) continue;
                this.children.remove(child);
                this.tabWindows.removeOption(child);
            }
            this.arrange();
            this.setActiveChild(this.getActiveChild());
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    public void arrange() {
        block9: {
            try {
                if (this.arrangeMode == 0) {
                    return;
                }
                if (this.arrangeMode == 5) {
                    JInternalFrame child = this.getActiveChild();
                    if (child != null) {
                        child.setMaximum(false);
                    }
                    break block9;
                }
                if (this.arrangeMode == 2) {
                    this.arrangeVertical();
                    break block9;
                }
                if (this.arrangeMode == 1) {
                    this.arrangeHorizontal();
                    break block9;
                }
                if (this.arrangeMode == 3) {
                    this.arrangeGrid();
                    break block9;
                }
                if (this.arrangeMode == 4) {
                    this.arrangeCascade();
                    break block9;
                }
                throw new Exception(Nat.x("Nezn\u00e1my arrange m\u00f3d: %1", this.arrangeMode));
            }
            catch (Exception e2) {
                TngUtilities.exceptionLog(e2);
            }
        }
    }

    protected void arrangeVertical() {
        if (this.arrangeOne()) {
            return;
        }
        Rectangle r2 = new Rectangle();
        r2.x = 0;
        r2.y = 0;
        r2.width = this.desktop.getWidth() / this.children.size();
        r2.height = this.desktop.getHeight();
        this.arrangeAdjustSize(r2);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            this.reshapeChild(this.children.get(i2), r2);
            r2.x += r2.width;
        }
    }

    protected void arrangeHorizontal() {
        if (this.arrangeOne()) {
            return;
        }
        Rectangle r2 = new Rectangle();
        r2.x = 0;
        r2.y = 0;
        r2.width = this.desktop.getWidth();
        r2.height = this.desktop.getHeight() / this.children.size();
        this.arrangeAdjustSize(r2);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            this.reshapeChild(this.children.get(i2), r2);
            r2.y += r2.height;
        }
    }

    protected void arrangeGrid() {
        if (this.arrangeOne()) {
            return;
        }
        int cols = 3;
        if (this.children.size() == 1) {
            cols = 1;
        } else if (this.children.size() <= 4) {
            cols = 2;
        }
        int rows = this.children.size() / cols;
        if (rows * cols < this.children.size()) {
            ++rows;
        }
        Rectangle r2 = new Rectangle();
        r2.x = 0;
        r2.y = 0;
        r2.width = this.desktop.getWidth() / cols;
        r2.height = this.desktop.getHeight() / rows;
        this.arrangeAdjustSize(r2);
        int cc = 0;
        boolean rr = false;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            this.reshapeChild(this.children.get(i2), r2);
            if (++cc >= cols) {
                cc = 0;
                r2.x = 0;
                r2.y += r2.height;
                continue;
            }
            r2.x += r2.width;
        }
    }

    protected void arrangeCascade() {
        JInternalFrame[] child = this.desktop.getAllFrames();
        JInternalFrame byChild = null;
        for (int i2 = child.length - 1; i2 >= 0; --i2) {
            Rectangle r2 = this.calcCascadeRect(byChild);
            this.reshapeChild(child[i2], r2);
            byChild = child[i2];
        }
    }

    protected boolean arrangeOne() {
        if (this.children.size() <= 0) {
            return true;
        }
        if (this.children.size() > 1) {
            return false;
        }
        try {
            this.children.get(0).setMaximum(true);
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
        return true;
    }

    protected void reshapeChild(JInternalFrame child, Rectangle r2) {
        if (child == null) {
            return;
        }
        try {
            child.setMaximum(false);
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
        if (r2.x == child.getX() && r2.y == child.getY() && r2.width == child.getWidth() && r2.height == child.getHeight()) {
            return;
        }
        child.reshape(r2.x, r2.y, r2.width, r2.height);
    }

    protected void arrangeAdjustSize(Rectangle r2) {
        if (r2 == null) {
            return;
        }
        if (r2.width < 150) {
            r2.width = 150;
        }
        if (r2.height < 100) {
            r2.height = 100;
        }
    }

    protected Rectangle calcCascadeRect(JInternalFrame byChild) {
        Rectangle r2 = new Rectangle();
        r2.x = 0;
        r2.y = 0;
        r2.width = this.desktop.getWidth() / 3 * 2;
        r2.height = this.desktop.getHeight() / 3 * 2;
        if (byChild == null) {
            this.arrangeAdjustSize(r2);
            return r2;
        }
        Rectangle by = byChild.getNormalBounds();
        r2.x = by.x + 20;
        r2.y = by.y + 28;
        if (r2.x + r2.width > this.desktop.getWidth()) {
            r2.x = 0;
        }
        if (r2.y + r2.height > this.desktop.getHeight()) {
            r2.y = 0;
        }
        this.arrangeAdjustSize(r2);
        return r2;
    }

    protected void actualizeMenuWindows() {
        JMenuItem item;
        int i2;
        JInternalFrame active = this.getActiveChild();
        this.menuWindowsClone.setEnabled(active != null);
        this.menuWindowsClose.setEnabled(active != null);
        this.menuWindowsCloseAll.setEnabled(this.children.size() > 0);
        boolean deleted = false;
        for (i2 = this.menuWindows.getItemCount() - 1; i2 >= 0 && (item = this.menuWindows.getItem(i2)) != null && item.getName() != null && item.getName().startsWith("menu_windows_"); --i2) {
            this.menuWindows.remove(i2);
            deleted = true;
        }
        if (deleted && this.menuWindows.getItemCount() > 0) {
            this.menuWindows.remove(this.menuWindows.getItemCount() - 1);
        }
        if (this.children.size() > 0) {
            this.menuWindows.addSeparator();
        }
        for (i2 = 0; i2 < this.children.size(); ++i2) {
            JInternalFrame child;
            JMenuItem item2 = this.createMenuItemWindow(child, i2, (child = this.children.get(i2)) == active);
            item2.setName("menu_windows_" + i2);
            this.menuWindows.add(item2);
        }
    }

    protected JMenuItem createMenuItemWindow(JInternalFrame child, int pos, boolean active) {
        TngCheckBoxMenuItem item = new TngCheckBoxMenuItem();
        item.setText(Integer.toString(pos + 1) + ". " + child.getTitle());
        item.setActionCommand(Integer.toString(pos));
        item.setSelected(active);
        item.addActionListener(this.menuWindowsActionListener);
        return item;
    }

    public boolean dlgOptions() {
        TngPanelWindowsSetting p2 = new TngPanelWindowsSetting();
        p2.setData(this.getShowToolbar(), this.getShowExitAsk());
        if (!TngDlg.runModal(p2)) {
            return false;
        }
        this.setShowToolbar(p2.getShowToolbar());
        this.setShowExitAsk(p2.getShowExitAsk());
        return true;
    }

    public void setShowToolbar(boolean show) {
        this.toolbarPanel.setVisible(show);
    }

    public boolean getShowToolbar() {
        return this.toolbarPanel.isVisible();
    }

    public void setShowExitAsk(boolean show) {
        this.showExitAsk = show;
    }

    public boolean getShowExitAsk() {
        return this.showExitAsk;
    }

    private void this_windowClosing(WindowEvent e2) {
        this.close();
    }

    private void desktop_componentResized(ComponentEvent e2) {
        this.arrange();
    }

    private void menuWindows_menuSelected(MenuEvent e2) {
        this.actualizeMenuWindows();
    }

    private void menuWindowsChaos_actionPerformed(ActionEvent e2) {
        this.setArrangeMode(5);
    }

    private void menuWindowsMaximized_actionPerformed(ActionEvent e2) {
        this.setArrangeMode(0);
    }

    private void menuWindowsVertical_actionPerformed(ActionEvent e2) {
        this.setArrangeMode(2);
    }

    private void menuWindowsHorizontal_actionPerformed(ActionEvent e2) {
        this.setArrangeMode(1);
    }

    private void menuWindowsGrid_actionPerformed(ActionEvent e2) {
        this.setArrangeMode(3);
    }

    private void menuWindowsCascade_actionPerformed(ActionEvent e2) {
        this.setArrangeMode(4);
    }

    private void menuWindowsCloseAll_actionPerformed(ActionEvent e2) {
        JInternalFrame[] child = this.getChildren();
        for (int i2 = child.length - 1; i2 >= 0; --i2) {
            JInternalFrame ch = child[i2];
            if (ch instanceof TngMdiChild) {
                if (((TngMdiChild)ch).close()) continue;
                return;
            }
            this.closeChild(ch);
        }
    }

    private void menuWindowsClose_actionPerformed(ActionEvent e2) {
        JInternalFrame child = this.getActiveChild();
        if (child instanceof TngMdiChild) {
            ((TngMdiChild)child).close();
        } else {
            this.closeChild(child);
        }
    }

    private void menuWindowsClone_actionPerformed(ActionEvent e2) {
        this.cloneChild(this.getActiveChild());
    }

    private void menuWindowsOptions_actionPerformed(ActionEvent e2) {
        this.dlgOptions();
    }

    private class TabWindow
    extends TngOptionPanel {
        private TabWindow() {
        }

        @Override
        public void doSelect(String title, Object o2) {
            TngMdiMain.this.setActiveChild((JInternalFrame)o2);
        }

        @Override
        public void doSwap(String title, Object o2, String title2, Object o22) {
            for (int i2 = 0; i2 < TngMdiMain.this.children.size(); ++i2) {
                if (TngMdiMain.this.children.get(i2) == o2) {
                    TngMdiMain.this.children.set(i2, (JInternalFrame)o22);
                    continue;
                }
                if (TngMdiMain.this.children.get(i2) != o22) continue;
                TngMdiMain.this.children.set(i2, (JInternalFrame)o2);
            }
            TngMdiMain.this.arrange();
        }
    }
}

