/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import tangram.dm.buffer.TngDmBuffer;
import tangram.dm.buffer.TngDmField;
import tangram.dm.buffer.TngDmFieldDate;
import tangram.dm.buffer.TngDmFieldDecimal;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngConversion;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.field.TngFieldDate;
import tangram.swing.component.field.TngFieldDecimal;
import tangram.swing.component.field.TngFieldInteger;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;

public class TngPanelBulkUpdate
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jLabelField = new TngLabel();
    private TngLabel jLabelValue = new TngLabel();
    private TngLabel jLabelCount = new TngLabel();
    private TngComboBox jField = new TngComboBox();
    private TngFieldString jValueString = new TngFieldString();
    private TngFieldDecimal jValueDecimal = new TngFieldDecimal();
    private TngFieldDate jValueDate = new TngFieldDate();
    private TngFieldInteger jCount = new TngFieldInteger();
    private TngConnection connection;
    private TngDmBuffer dmBuffer;
    private String where;
    private boolean updated;

    public TngPanelBulkUpdate() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(348, 139));
        this.setLayout(this.gridBagLayout1);
        this.setTitle(Nat.x("Hromadn\u00e1 zmena \u00fadajov"));
        this.jLabelField.setText(Nat.x("St\u013apec"));
        this.jLabelValue.setText(Nat.x("Hodnota"));
        this.jLabelCount.setText(Nat.x("Po\u010det z\u00e1znamov"));
        this.jField.setMaximumRowCount(30);
        this.jCount.setColumns(8);
        this.jCount.setEditable(false);
        this.jField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                TngPanelBulkUpdate.this.field_itemStateChanged(e2);
            }
        });
        this.add((Component)this.jLabelField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabelValue, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jValueString, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jValueDecimal, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jValueDate, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabelCount, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.add((Component)this.jCount, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        TngSwing.setOptimalHeight(this);
    }

    @Override
    public boolean doBeforeShow() {
        TngDlg dlg = this.getPanelDlgParent();
        dlg.getOkButton().setText("Zmeni\u0165");
        dlg.getCancelButton().setText("Koniec");
        String select = "SELECT COUNT(*) FROM " + this.dmBuffer.getTableName() + " " + this.where;
        try {
            this.jCount.setValue(this.connection.queryInt(select));
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
        }
        this.jField.setSelectedIndex(-1);
        this.jField.setSelectedIndex(0);
        return true;
    }

    public void setData(TngConnection connection, TngDmBuffer dmBuffer, String where) {
        this.updated = false;
        this.connection = connection;
        this.dmBuffer = dmBuffer;
        this.where = where;
        this.setFields();
    }

    private void setFields() {
        try {
            List<TngDmField> dmFields = this.dmBuffer.getLoader().getDmFieldsAll();
            Vector<CmbField> cmbFields = new Vector<CmbField>(dmFields.size());
            List<TngDmField> primaryFields = this.dmBuffer.getPrimaryFields();
            TngDmField primaryField = primaryFields.size() == 0 ? null : primaryFields.get(0);
            List<String> except = Arrays.asList("xh", "xc", "xio", "xid", "xuo", "xud");
            for (TngDmField dmField : dmFields) {
                dmField.setValueChanged(false);
                if (primaryField == dmField || except.contains(dmField.getName())) continue;
                cmbFields.add(new CmbField(dmField));
            }
            Collections.sort(cmbFields);
            this.jField.setModel(new DefaultComboBoxModel(cmbFields));
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }

    private void field_itemStateChanged(ItemEvent e2) {
        if (e2.getStateChange() != 1) {
            return;
        }
        CmbField field = (CmbField)this.jField.getSelectedItem();
        this.activateValueType(field.dmField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doSave() throws Exception {
        CmbField field = (CmbField)this.jField.getSelectedItem();
        TngDmField dmField = field.dmField;
        try {
            Object v2 = this.getValuable(dmField).getValue();
            if (!(v2 != null && v2.toString().length() != 0 || TngSwing.msgAsk(Nat.x("Naozaj si \u017eel\u00e1te nastavi\u0165 pr\u00e1zdnu hodnotu do st\u013apca %1?", field.toString())))) {
                boolean bl = false;
                return bl;
            }
            dmField.setValue(v2);
            dmField.setValueChanged(true);
            this.dmBuffer.update(this.connection, this.where);
        }
        finally {
            dmField.setValueChanged(false);
        }
        this.updated = true;
        TngSwing.msgOK(Nat.x("Z\u00e1znamy boli \u00faspe\u0161ne zmenen\u00e9"));
        return false;
    }

    private TngValuable getValuable(TngDmField dmField) {
        if (dmField instanceof TngDmFieldDate) {
            return this.jValueDate;
        }
        if (dmField instanceof TngDmFieldDecimal) {
            return this.jValueDecimal;
        }
        return this.jValueString;
    }

    private void activateValueType(TngDmField dmField) {
        if (dmField instanceof TngDmFieldDate) {
            this.jValueDate.setValueCanNull(!dmField.isNotNull());
            this.jValueDate.setVisible(true);
            this.jValueDecimal.setVisible(false);
            this.jValueString.setVisible(false);
        } else if (dmField instanceof TngDmFieldDecimal) {
            this.jValueDecimal.setValueCanNull(!dmField.isNotNull());
            this.jValueDecimal.setValueSize(dmField.getPrecision(), dmField.getScale());
            this.jValueDecimal.setColumns(dmField.getPrecision() + 2);
            this.jValueDate.setVisible(false);
            this.jValueDecimal.setVisible(true);
            this.jValueString.setVisible(false);
        } else {
            this.jValueString.setValueCanNull(!dmField.isNotNull());
            this.jValueString.setValueSize(dmField.getPrecision());
            this.jValueDate.setVisible(false);
            this.jValueDecimal.setVisible(false);
            this.jValueString.setVisible(true);
        }
        this.getValuable(dmField).setValue(null);
        this.getPanelDlgParent().pack();
    }

    private class CmbField
    implements Comparable<CmbField> {
        private final TngDmField dmField;

        private CmbField(TngDmField dmField) {
            this.dmField = dmField;
        }

        public String toString() {
            if (!TngUtilities.isEmpty(this.dmField.getLabel())) {
                return this.dmField.getLabel();
            }
            if (!TngUtilities.isEmpty(this.dmField.getLabelShort())) {
                return this.dmField.getLabelShort();
            }
            return this.dmField.getName();
        }

        @Override
        public int compareTo(CmbField o2) {
            String a2 = TngConversion.unicodeToAscii(this.toString());
            String b2 = TngConversion.unicodeToAscii(o2.toString());
            return a2.compareTo(b2);
        }
    }
}

