/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import tangram.filter.TngFilterSet;
import tangram.filter.item.TngFilterItem;
import tangram.filter.visualizer.TngFilterVisualizer;
import tangram.library.Nat;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButtonInterval;
import tangram.swing.component.field.TngFieldDate;
import tangram.swing.panel.TngPanel;

public class TngPanelFilter
extends TngPanel {
    public static final int colsCountDefault = 2;
    public static final int colsGutterHalf = 7;
    public VisualizerTag[] visualizers;
    private TngFilterSet filterSet;
    private int colsCount = 2;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public TngPanelFilter() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public void setFilterSet(TngFilterSet filterSet) {
        this.filterSet = filterSet;
    }

    public TngFilterSet getFilterSet() {
        return this.filterSet;
    }

    public void setColsCount(int colsCount) {
        this.colsCount = colsCount;
    }

    public void populate() {
        if (this.filterSet == null) {
            this.filterSet = new TngFilterSet();
        }
        this.visualizers = new VisualizerTag[this.filterSet.size()];
        this.setTitle(this.filterSet.getLabel());
        this.createVisualizers();
        TngSwing.setOptimalSize(this);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
    }

    private void createVisualizers() {
        if (this.colsCount <= 1) {
            this.createVisualizersOneColumn(this, 0, this.filterSet.size());
            return;
        }
        int colsItems = this.filterSet.size() / this.colsCount;
        if (colsItems * this.colsCount < this.filterSet.size()) {
            ++colsItems;
        }
        for (int i2 = 0; i2 < this.colsCount; ++i2) {
            TngPanel columnPanel = new TngPanel();
            columnPanel.setLayout(new GridBagLayout());
            this.createVisualizersOneColumn(columnPanel, i2 * colsItems, (i2 + 1) * colsItems);
            if (i2 != 0) {
                JSeparator separator = new JSeparator(1);
                this.add((Component)separator, new GridBagConstraints(i2 * 2 - 1, 0, 1, 1, 0.0, 1.0, 11, 3, new Insets(0, 7, 0, 7), 0, 0));
            }
            this.add((Component)columnPanel, new GridBagConstraints(i2 * 2, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void createVisualizersOneColumn(TngPanel panel, int fromIndex, int toIndex) {
        int row = 0;
        int min = Math.min(toIndex, this.filterSet.size());
        for (int i2 = fromIndex; i2 < min; ++i2) {
            this.visualizers[i2] = this.createVisualizer(panel, this.filterSet.get(i2), row++);
        }
    }

    private VisualizerTag createVisualizer(TngPanel panel, TngFilterItem filterItem, int row) {
        VisualizerTag tag = new VisualizerTag(filterItem);
        TngLabel label = new TngLabel();
        label.setText(filterItem.getLabel());
        panel.add((Component)label, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        IntervalButton btn = new IntervalButton(tag);
        btn.setEnabled(filterItem.intervalable() && filterItem.isEditable());
        panel.add((Component)btn, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 3, 0), 0, 0));
        Component single = this.createFilterSinglePanel(btn);
        panel.add(single, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        label.setLabelFor(single);
        Component interval = null;
        if (filterItem.intervalable()) {
            interval = this.createFilterIntervalPanel(btn);
            panel.add(interval, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        tag.loadValues();
        btn.setIntervalIcon(tag.isInterval);
        if (interval != null && tag.isInterval) {
            label.setLabelFor(interval);
        }
        return tag;
    }

    private Component createFilterSinglePanel(IntervalButton btn) {
        TngFilterVisualizer visualizer = btn.visualizer.getFilterItem().createFilterVisualizer();
        this.addIntervalButtonShortcut(btn, visualizer);
        boolean restrictFill = this.isFillRestricted(visualizer.getComponent());
        JPanel single = new JPanel();
        single.setLayout(new GridBagLayout());
        single.add((Component)visualizer.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, restrictFill ? 0 : 2, new Insets(0, 0, 3, 0), 0, 0));
        btn.visualizer.addSingle(visualizer, single);
        return single;
    }

    private Component createFilterIntervalPanel(IntervalButton btn) {
        TngLabel labelA = new TngLabel();
        TngLabel labelB = new TngLabel();
        labelA.setText(Nat.x("od"));
        labelB.setText(Nat.x("do"));
        TngFilterVisualizer visualizerA = btn.visualizer.getFilterItem().createFilterVisualizer();
        this.addIntervalButtonShortcut(btn, visualizerA);
        TngFilterVisualizer visualizerB = btn.visualizer.getFilterItem().createFilterVisualizer();
        this.addIntervalButtonShortcut(btn, visualizerB);
        boolean restrictFill = this.isFillRestricted(visualizerA.getComponent());
        JPanel interval = new JPanel();
        interval.setLayout(new GridBagLayout());
        interval.add((Component)labelA, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 2, 3), 0, 0));
        interval.add((Component)visualizerA.getComponent(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, restrictFill ? 0 : 2, new Insets(0, 0, 3, 0), 0, 0));
        interval.add((Component)labelB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 2, 3), 0, 0));
        interval.add((Component)visualizerB.getComponent(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, restrictFill ? 0 : 2, new Insets(0, 0, 3, 0), 0, 0));
        btn.visualizer.addInterval(visualizerA, visualizerB, interval);
        return interval;
    }

    private boolean isFillRestricted(Component c2) {
        return c2 instanceof TngFieldDate;
    }

    private void addIntervalButtonShortcut(final IntervalButton btn, TngFilterVisualizer visualizer) {
        visualizer.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                btn.doClick();
            }
        }, KeyStroke.getKeyStroke(120, 0), 0);
    }

    public void refreshVizualizers() {
        for (VisualizerTag tag : this.visualizers) {
            tag.reloadValues();
        }
    }

    public void refreshVizualizer(String name) {
        for (VisualizerTag tag : this.visualizers) {
            if (!tag.filterItem.getName().equals(name)) continue;
            tag.reloadValues();
        }
    }

    @Override
    public boolean doSave() throws Exception {
        this.save();
        return true;
    }

    public void save() {
        for (int i2 = 0; i2 < this.filterSet.size(); ++i2) {
            VisualizerTag v2 = this.visualizers[i2];
            if (!v2.getFilterItem().isEditable()) continue;
            v2.saveValues();
        }
    }

    private class IntervalButton
    extends TngButtonInterval {
        private VisualizerTag visualizer;

        public IntervalButton(VisualizerTag visualizer) {
            this.visualizer = visualizer;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    IntervalButton btn = (IntervalButton)e2.getSource();
                    btn.changeInterval();
                }
            });
        }

        public void changeInterval() {
            this.visualizer.changeInterval();
            this.setIntervalIcon(this.visualizer.isInterval);
        }
    }

    private class VisualizerTag {
        private TngFilterItem filterItem;
        private TngFilterVisualizer value;
        private TngFilterVisualizer valueA;
        private TngFilterVisualizer valueB;
        private Component singlePanel;
        private Component intervalPanel;
        private boolean isInterval;

        public VisualizerTag(TngFilterItem filterItem) {
            this.filterItem = filterItem;
        }

        public void addSingle(TngFilterVisualizer value, Component singlePanel) {
            this.value = value;
            this.singlePanel = singlePanel;
        }

        public void addInterval(TngFilterVisualizer valueA, TngFilterVisualizer valueB, Component intervalPanel) {
            this.valueA = valueA;
            this.valueB = valueB;
            this.intervalPanel = intervalPanel;
        }

        public TngFilterItem getFilterItem() {
            return this.filterItem;
        }

        public void changeInterval() {
            this.isInterval = !this.isInterval;
            this.showComponent();
            if (this.isInterval) {
                this.valueA.getComponent().requestFocusInWindow();
            } else {
                this.value.getComponent().requestFocusInWindow();
            }
        }

        public void showComponent() {
            this.singlePanel.setVisible(!this.isInterval);
            if (this.intervalPanel != null) {
                this.intervalPanel.setVisible(this.isInterval);
            }
        }

        public void loadValues() {
            this.setValues();
            this.isInterval = this.filterItem.isInterval();
            this.showComponent();
        }

        public void reloadValues() {
            this.setValues();
        }

        private void setValues() {
            this.value.setValue(this.filterItem.getValue());
            if (this.valueA != null) {
                this.valueA.setValue(this.filterItem.getValueA());
            }
            if (this.valueB != null) {
                this.valueB.setValue(this.filterItem.getValueB());
            }
            this.value.setEditable(this.filterItem.isEditable());
            if (this.valueA != null) {
                this.valueA.setEditable(this.filterItem.isEditable());
            }
            if (this.valueB != null) {
                this.valueB.setEditable(this.filterItem.isEditable());
            }
        }

        public void saveValues() {
            if (this.isInterval) {
                this.filterItem.setInterval(this.valueA.getValue(), this.valueB.getValue());
            } else {
                this.filterItem.setValue(this.value.getValue());
            }
        }
    }
}

