/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import tangram.library.Nat;
import tangram.library.TngConfigAbstract;
import tangram.library.TngConnection;
import tangram.swing.TngSwing;
import tangram.swing.TngValidationError;
import tangram.swing.component.TngCheckBox;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.field.TngFieldPassword;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngPanelListValues;
import tangram.swing.valuable.TngValueAdapter;
import tangram.swing.valuable.TngValueWizardEvent;

public class TngPanelSqlLogin
extends TngPanel {
    private TngLabel lDatabase = new TngLabel();
    private TngLabel lUser = new TngLabel();
    private TngLabel lPassword = new TngLabel();
    private TngLabel lSchema = new TngLabel();
    private TngCheckBox jLogInAsSysdba = new TngCheckBox();
    private TngComboBox jDatabase = new TngComboBox();
    private TngFieldString jUser = new TngFieldString();
    private TngFieldPassword jPassword = new TngFieldPassword();
    private TngFieldString jSchema = new TngFieldString();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngConnection connection = new TngConnection();
    private boolean schemaEnabled = true;
    private final List<String> excludedSections = new ArrayList<String>();
    private TngConfigAbstract cfg;
    private String lastSetUser;

    public TngPanelSqlLogin() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(229, 94));
        this.setTitle(Nat.x("Prihl\u00e1senie k datab\u00e1ze"));
        this.setLayout(this.gridBagLayout1);
        this.lDatabase.setText(Nat.x("&Datab\u00e1za"));
        this.lDatabase.setForeground(null);
        this.lDatabase.setHorizontalAlignment(4);
        this.jDatabase.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                TngPanelSqlLogin.this.jDatabase_itemStateChanged(e2);
            }
        });
        this.jLogInAsSysdba.setText(Nat.x("prihl\u00e1si\u0165 ako &administr\u00e1tor"));
        this.jLogInAsSysdba.setForeground(null);
        this.jLogInAsSysdba.setHorizontalAlignment(2);
        this.jLogInAsSysdba.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                boolean selected;
                boolean bl = selected = e2.getStateChange() == 1;
                if (selected) {
                    TngPanelSqlLogin.this.lastSetUser = TngPanelSqlLogin.this.jUser.getStringDef(null);
                }
                TngPanelSqlLogin.this.jUser.setString(selected ? "SYS AS SYSDBA" : TngPanelSqlLogin.this.lastSetUser);
                TngPanelSqlLogin.this.jUser.setEditable(!selected);
                if (selected) {
                    TngPanelSqlLogin.this.jPassword.requestFocusInWindow();
                } else {
                    TngPanelSqlLogin.this.jUser.requestFocusInWindow();
                }
            }
        });
        this.lUser.setForeground(null);
        this.lUser.setHorizontalAlignment(4);
        this.lUser.setText(Nat.x("&Pou\u017e\u00edvate\u013e"));
        this.jUser.setValueCanNull(false);
        this.jUser.setValueFormat(1);
        this.lPassword.setText(Nat.x("&Heslo"));
        this.lPassword.setForeground(null);
        this.lPassword.setHorizontalAlignment(4);
        this.jPassword.setValueCanNull(false);
        this.lSchema.setText(Nat.x("&Sch\u00e9ma"));
        this.lSchema.setForeground(null);
        this.lSchema.setHorizontalAlignment(4);
        this.jSchema.setValueWizard(true);
        this.jSchema.addValueListener(new TngValueAdapter(){

            @Override
            public void valueWizard(TngValueWizardEvent e2) {
                e2.consume();
                TngPanelSqlLogin.this.selectSchema();
            }
        });
        this.jSchema.setValueFormat(1);
        this.add((Component)this.lDatabase, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jDatabase, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLogInAsSysdba, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.lUser, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jUser, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.lPassword, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.lSchema, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jSchema, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.setLogInAsSysdbaEnabled(false);
        this.clearExcludedSections();
        this.setOptimalSize();
    }

    @Override
    public boolean doBeforeShow() {
        if (this.jDatabase.getItemCount() < 2) {
            this.jUser.requestFocusInWindow();
        }
        return true;
    }

    public TngConnection getConnection() {
        return this.connection;
    }

    public void setSchemaEnabled(boolean schemaEnabled) {
        this.schemaEnabled = schemaEnabled;
        this.lSchema.setEnabled(schemaEnabled);
        this.jSchema.setEnabled(schemaEnabled);
    }

    public void setLogInAsSysdbaEnabled(boolean logInAsSysdbaEnabled) {
        this.jLogInAsSysdba.setVisible(logInAsSysdbaEnabled);
    }

    public void clearExcludedSections() {
        this.excludedSections.clear();
        this.addExludedSection("GLOBAL");
    }

    public void addExludedSection(String excludedSection) {
        this.excludedSections.add(excludedSection);
    }

    public void addExludedSections(List<String> excludedSections) {
        this.excludedSections.addAll(excludedSections);
    }

    private String[] excludeSections(String[] databases) {
        if (this.excludedSections.size() == 0) {
            return databases;
        }
        ArrayList<String> ex = new ArrayList<String>();
        for (String db : databases) {
            boolean f2 = false;
            for (String es : this.excludedSections) {
                if (!es.equalsIgnoreCase(db)) continue;
                f2 = true;
            }
            if (f2) continue;
            ex.add(db);
        }
        return ex.toArray(new String[ex.size()]);
    }

    public void setData(TngConfigAbstract cfg) {
        try {
            this.cfg = cfg;
            String[] databases = cfg.getDatabases();
            databases = this.excludeSections(databases);
            this.jDatabase.setModel(new DefaultComboBoxModel<String>(databases));
            this.jDatabase.setSelectedItem(cfg.getDefDatabase());
            this.jDatabase.setEnabled(databases.length != 1);
            this.databaseChanged();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed konfigura\u010dn\u00fdch parametrov prihl\u00e1senia"), e2);
        }
    }

    private void databaseChanged() throws Exception {
        if (this.jDatabase.getSelectedItem() == null) {
            this.jUser.setString("");
            this.jPassword.setPsswd("");
            this.jSchema.setString("");
        } else {
            String database = this.jDatabase.getSelectedItem().toString();
            this.jUser.setString(this.cfg.getDefUser(database));
            this.jPassword.setPsswd(this.cfg.getDefPassword(database));
            this.jSchema.setString(this.schemaEnabled ? this.cfg.getDefSchema(database) : "");
        }
    }

    public String getDatabaseName() {
        return this.jDatabase.getSelectedItem() == null ? "???" : this.jDatabase.getSelectedItem().toString();
    }

    @Override
    public boolean doSave() throws Exception {
        String[] schemas = this.connect();
        if (schemas == null) {
            return false;
        }
        if (!this.schemaEnabled) {
            return true;
        }
        if (this.jSchema.getText().length() == 0) {
            if (schemas.length == 1) {
                this.jSchema.setString(schemas[0]);
            } else if (!this.selectSchema(schemas)) {
                return false;
            }
        }
        this.connection.changeSchema(this.jSchema.getText());
        return true;
    }

    public String[] connect() {
        if (this.jDatabase.getSelectedItem() == null) {
            TngSwing.msgNovalid(Nat.x("Zvo\u013ete datab\u00e1zu"), this.jDatabase);
            return null;
        }
        try {
            String database = this.jDatabase.getSelectedItem().toString();
            this.cfg.setConnection(database, this.connection);
            this.connection.setUser(this.jUser.getText());
            this.connection.setPassword(this.jPassword.getPsswd());
            this.connection.setSchema("");
            this.connection.connect();
            ArrayList<String> schemas = new ArrayList<String>();
            this.connection.readSchemas(this.connection, schemas);
            return schemas.toArray(new String[schemas.size()]);
        }
        catch (Exception e2) {
            if (TngConnection.isErrorLogin(e2)) {
                TngSwing.msgError(Nat.x("Nespr\u00e1vne prihlasovacie meno alebo heslo"));
            } else {
                TngSwing.exceptionShow(Nat.x("Chyba pri prihlasovan\u00ed"), e2);
            }
            this.connection.close();
            return null;
        }
    }

    private void selectSchema() {
        TngValidationError errors = new TngValidationError();
        this.doValidate(errors);
        if (errors.hasError()) {
            TngSwing.msgNovalid(errors.getError(0), errors.getComponent(0));
            return;
        }
        String[] schemas = this.connect();
        if (schemas == null) {
            return;
        }
        this.selectSchema(schemas);
    }

    private boolean selectSchema(String[] schemas) {
        if (schemas.length == 0) {
            TngSwing.msgWarning(Nat.x("Vo zvolenej datab\u00e1ze neexistuj\u00fa \u017eiadne sch\u00e9my"));
            return false;
        }
        TngPanelListValues p2 = new TngPanelListValues();
        p2.setTitle(Nat.x("V\u00fdber sch\u00e9my"));
        p2.setData(schemas, this.jSchema.getText());
        if (!TngDlg.runModal(p2)) {
            return false;
        }
        this.jSchema.setString(p2.getValue());
        return true;
    }

    private void jDatabase_itemStateChanged(ItemEvent e2) {
        try {
            this.databaseChanged();
        }
        catch (Exception er) {
            TngSwing.exceptionShow(Nat.x("Chyba pri zmene parametrov datab\u00e1zy"), er);
        }
    }
}

