/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.progress;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButtonCancel;
import tangram.swing.progress.TngProgressInterface;

public class TngProgressSingle
extends JDialog
implements TngProgressInterface {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jOperation = new TngLabel();
    private TngLabel jStatus = new TngLabel();
    private JProgressBar jProgressBar = new JProgressBar();
    private TngButtonCancel jCancel = new TngButtonCancel();
    private Thread thread;
    private int level = -1;
    private int prgLast = 0;
    private int prgDelta = 0;
    private boolean canceled = false;

    public TngProgressSingle(Frame parent) {
        this(parent, true);
    }

    public TngProgressSingle(Frame parent, boolean modal) {
        super(parent, Nat.x("Priebeh oper\u00e1cie"), modal);
        try {
            this.jbInit();
            this.setLocationRelativeTo(parent);
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.setDefaultCloseOperation(0);
        this.jOperation.setText(Nat.nox("operation"));
        this.jOperation.setFont(new Font("Dialog", 1, 11));
        this.jOperation.setHorizontalAlignment(0);
        this.jOperation.setPreferredSize(new Dimension(200, 15));
        this.jStatus.setText(Nat.nox("status"));
        this.jStatus.setHorizontalAlignment(0);
        this.jCancel.setText(Nat.x("Preru\u0161i\u0165"));
        this.jCancel.setToolTipText(Nat.x("Preru\u0161i\u0165 prebiehaj\u00facu oper\u00e1ciu") + "<ESC>");
        this.jCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngProgressSingle.this.jCancel_actionPerformed(e2);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (TngProgressSingle.this.jCancel.isEnabled()) {
                    TngProgressSingle.this.this_windowClosing(e2);
                }
            }
        });
        this.getContentPane().add((Component)this.jOperation, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 200, 0));
        this.getContentPane().add((Component)this.jStatus, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 6, 0, 6), 0, 0));
        this.getContentPane().add((Component)this.jProgressBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 6, 0, 6), 0, 3));
        this.getContentPane().add((Component)this.jCancel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 6, 0), 0, 0));
        this.pack();
        this.setResizable(true);
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    private void jCancel_actionPerformed(ActionEvent e2) {
        this.cancel();
    }

    private void this_windowClosing(WindowEvent e2) {
        this.cancel();
    }

    @Override
    public void start(String operation) {
        if (++this.level > 0) {
            return;
        }
        this.jOperation.setText(operation);
        this.canceled = false;
        this.jCancel.setEnabled(false);
        this.prgLast = 0;
        this.prgDelta = 0;
        this.jProgressBar.setMaximum(0);
        this.jProgressBar.setValue(0);
        this.jProgressBar.setIndeterminate(true);
        this.jProgressBar.setStringPainted(false);
        this.jStatus.setText(" ");
        this.setVisible(true);
    }

    @Override
    public void end() {
        if (this.level < 0) {
            return;
        }
        if (--this.level >= 0) {
            return;
        }
        this.dispose();
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void setStatus(String status) {
        this.jStatus.setText(status == null && status.length() == 0 ? " " : status);
    }

    @Override
    public boolean setProgress(int value) {
        if (this.level == 0 && this.prgDelta > 0 && value >= this.prgLast + this.prgDelta) {
            this.prgLast = value;
            this.jProgressBar.setValue(value);
        }
        return this.canceled;
    }

    @Override
    public void cancel() {
        if (this.thread != null) {
            this.thread.suspend();
        }
        if (TngSwing.msgAsk(Nat.x("Naozaj si \u017eel\u00e1te preru\u0161i\u0165 prebiehaj\u00facu oper\u00e1ciu?"))) {
            this.canceled = true;
        }
        if (this.thread != null) {
            this.thread.resume();
        }
        this.requestFocus();
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setMax(int max) {
        if (this.level != 0) {
            return;
        }
        if (max > 0) {
            this.jProgressBar.setMaximum(max);
            this.jProgressBar.setIndeterminate(false);
            this.jProgressBar.setStringPainted(true);
            this.jCancel.setEnabled(this.isModal());
            this.prgLast = 0;
            this.prgDelta = max / 100;
            if (this.prgDelta < 1) {
                this.prgDelta = 1;
            }
            this.setProgress(0);
        } else {
            this.jProgressBar.setMaximum(0);
            this.jProgressBar.setIndeterminate(true);
            this.jProgressBar.setStringPainted(false);
            this.jCancel.setEnabled(false);
            this.prgDelta = 0;
        }
    }

    @Override
    public int getMax() {
        if (this.level != 0) {
            return -1;
        }
        return this.jProgressBar.getMaximum();
    }

    @Override
    public int getLevel() {
        return this.level;
    }
}

